/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services.pptx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.gendoc.document.parser.documents.XMLParser;
import org.eclipse.gendoc.document.parser.documents.helper.XMLHelper;
import org.eclipse.gendoc.document.parser.pptx.Activator;
import org.eclipse.gendoc.document.parser.pptx.PPTXDocument;
import org.eclipse.gendoc.document.parser.pptx.PPTXHelper;
import org.eclipse.gendoc.document.parser.pptx.PPTXParser;
import org.eclipse.gendoc.document.parser.pptx.PPTXRef;
import org.eclipse.gendoc.document.parser.pptx.XPathPptxUtils;
import org.eclipse.gendoc.documents.IDocumentManager;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.process.AbstractProcess;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.services.pptx.PPTXImageService;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PPTXUnflattenProcess
extends AbstractProcess {
    /*
     * WARNING - void declaration
     */
    protected void doRun() throws GenDocException {
        IDocumentManager documentManager = (IDocumentManager)GendocServices.getDefault().getService(IDocumentManager.class);
        if (!(documentManager.getDocTemplate() instanceof PPTXDocument)) {
            return;
        }
        IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        PPTXDocument document = (PPTXDocument)documentManager.getDocTemplate();
        document.jumpToStart();
        PPTXParser pptxParser = (PPTXParser)document.getXMLParser();
        Document doc = pptxParser.getDocument();
        ArrayList<Element> parasToRemove = null;
        DocumentFragment activeSlide = null;
        XMLParser activeSlideParser = null;
        ArrayList<DocumentFragment> newSlides = new ArrayList<DocumentFragment>();
        ArrayList<DocumentFragment> newSlideRels = new ArrayList<DocumentFragment>();
        Node flatStruct = null;
        NodeList flatStructList = null;
        try {
            flatStruct = XPathPptxUtils.INSTANCE.evaluateNode((Node)doc, "//gendoc:flatSlide");
            if (flatStruct != null) {
                flatStructList = XPathPptxUtils.INSTANCE.evaluateNodes(flatStruct, "./*");
            }
        }
        catch (XPathExpressionException e) {
            Activator.log((Exception)e, (int)4);
            return;
        }
        if (flatStruct == null || flatStructList == null) {
            return;
        }
        int i = 0;
        while (i < flatStructList.getLength()) {
            block31: {
                Element el;
                block30: {
                    el = (Element)flatStructList.item(i);
                    if (!el.getNodeName().equals("gendoc:ref")) break block30;
                    String typeStr = el.getAttribute("type");
                    PPTXHelper.GENDOC_REF_TYPE type = PPTXHelper.GENDOC_REF_TYPE.valueOf((String)typeStr);
                    String ref = el.getAttribute("ref");
                    PPTXRef slideRef = PPTXRef.parse((String)ref);
                    switch (type) {
                        case startSlide: {
                            activeSlideParser = document.getSubdocument(slideRef.partPath);
                            Element sldEl = (Element)activeSlideParser.getDocument().getDocumentElement().cloneNode(true);
                            activeSlide = activeSlideParser.getDocument().createDocumentFragment();
                            activeSlide.appendChild(sldEl);
                            newSlides.add(activeSlide);
                            String relsPath = String.valueOf(slideRef.partPath.replace("/ppt/slides/", "/ppt/slides/_rels/")) + ".rels";
                            XMLParser relsP = document.getSubdocument(relsPath);
                            DocumentFragment relsFrag = relsP.getDocument().createDocumentFragment();
                            relsFrag.appendChild(relsP.getDocument().getDocumentElement().cloneNode(true));
                            newSlideRels.add(relsFrag);
                            LinkedHashSet<String> parasRefs = new LinkedHashSet<String>(Arrays.asList(el.getAttribute("paras").split(",")));
                            parasToRemove = new ArrayList<Element>();
                            for (String string : parasRefs) {
                                try {
                                    Element par = (Element)XPathPptxUtils.INSTANCE.evaluateNode((Node)activeSlide, PPTXRef.parse((String)string).xpathSelector);
                                    if (par == null) continue;
                                    parasToRemove.add(par);
                                }
                                catch (XPathExpressionException xPathExpressionException) {
                                    // empty catch block
                                }
                            }
                            break block31;
                        }
                        case endSlide: {
                            for (Node node : parasToRemove) {
                                void var24_38;
                                if (node.getNodeName().equals("a:p")) {
                                    try {
                                        if (XPathPptxUtils.INSTANCE.evaluateNodes(node.getParentNode(), "./a:p").getLength() == 1) {
                                            Node node2 = XPathPptxUtils.INSTANCE.evaluateNode(node, "ancestor::p:sp");
                                        }
                                    }
                                    catch (XPathExpressionException xPathExpressionException) {
                                        // empty catch block
                                    }
                                }
                                var24_38.getParentNode().removeChild((Node)var24_38);
                            }
                            activeSlide = null;
                            activeSlideParser = null;
                        }
                    }
                    break block31;
                }
                if (el.getNodeName().equals("a:p") && activeSlide != null) {
                    try {
                        PPTXRef parRef = PPTXRef.parse((String)el.getAttribute("gendoc:ref"));
                        Element par = (Element)XPathPptxUtils.INSTANCE.evaluateNode(activeSlide, parRef.xpathSelector);
                        if (par != null) {
                            Node pic = XPathPptxUtils.INSTANCE.evaluateNode((Node)el, ".//gendoc:pic");
                            if (pic != null) {
                                PPTXImageService imgService = (PPTXImageService)documentService.getAdditionalResourceService().getImageService();
                                String imageId = XPathPptxUtils.INSTANCE.evaluateText(pic, "./@imageId");
                                boolean keepH = "true".equals(XPathPptxUtils.INSTANCE.evaluateText(pic, "./@keepH"));
                                boolean keepW = "true".equals(XPathPptxUtils.INSTANCE.evaluateText(pic, "./@keepW"));
                                boolean maxH = "true".equals(XPathPptxUtils.INSTANCE.evaluateText(pic, "./@maxH"));
                                boolean maxW = "true".equals(XPathPptxUtils.INSTANCE.evaluateText(pic, "./@maxW"));
                                imgService.replaceParagraphWithPicture(document, activeSlideParser, par, imageId, keepH, keepW, maxH, maxW);
                                Element element = (Element)XPathPptxUtils.INSTANCE.evaluateNode((Node)par, "ancestor::p:sp");
                                element.getParentNode().removeChild(element);
                                parasToRemove.remove(par);
                            } else {
                                el.removeAttribute("gendoc:ref");
                                el.removeAttribute("xmlns:gendoc");
                                par.getParentNode().insertBefore(par.getOwnerDocument().importNode(el, true), par);
                                par.getParentNode().removeChild(par);
                                parasToRemove.remove(par);
                            }
                        }
                    }
                    catch (XPathExpressionException parRef) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
        try {
            Node slideList = XPathPptxUtils.INSTANCE.evaluateNode((Node)pptxParser.getDocument(), "//p:sldIdLst");
            NodeList nl = slideList.getChildNodes();
            while (nl.getLength() > 0) {
                slideList.removeChild(nl.item(0));
            }
            int index = 0;
            for (DocumentFragment slide : newSlides) {
                try {
                    document.createSubdocument("/ppt/slides/slide" + (index + 1) + ".xml", (CharSequence)XMLHelper.asText((Node)slide.getFirstChild(), (boolean)true), "application/vnd.openxmlformats-officedocument.presentationml.slide+xml");
                    document.createSubdocument("/ppt/slides/_rels/slide" + (index + 1) + ".xml.rels", (CharSequence)XMLHelper.asText((Node)((DocumentFragment)newSlideRels.get(index)).getFirstChild(), (boolean)true));
                    String relId = pptxParser.addRelationship("http://schemas.openxmlformats.org/officeDocument/2006/relationships/slide", "/ppt/slides/slide" + (index + 1) + ".xml");
                    Element sldIdEl = slideList.getOwnerDocument().createElement("p:sldId");
                    sldIdEl.setAttribute("r:id", relId);
                    sldIdEl.setAttribute("id", "" + (256 + index));
                    slideList.appendChild(sldIdEl);
                }
                catch (IOException e) {
                    Activator.log((Exception)e, (int)4);
                }
                ++index;
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        flatStruct.getParentNode().removeChild(flatStruct);
    }

    protected int getTotalWork() {
        return 1;
    }
}

