/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.messaging;

import com.sun.messaging.jmq.resources.SharedResources;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.messaging.OnewayListener;
import javax.xml.messaging.ReqRespListener;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public abstract class JAXMServlet
extends HttpServlet {
    private static final long serialVersionUID = -2176753361492935877L;
    protected MessageFactory msgFactory = null;
    private static final transient SharedResources cr = SharedResources.getResources();

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            this.msgFactory = MessageFactory.newInstance();
        }
        catch (SOAPException ex) {
            String fctryMsg = cr.getKString("S4008");
            throw new ServletException(fctryMsg + "\n" + ex.getMessage());
        }
    }

    public void setMessageFactory(MessageFactory msgFactory) {
        this.msgFactory = msgFactory;
    }

    protected static MimeHeaders getHeaders(HttpServletRequest req) {
        Enumeration enm = req.getHeaderNames();
        MimeHeaders headers = new MimeHeaders();
        while (enm.hasMoreElements()) {
            String headerName = (String)enm.nextElement();
            String headerValue = req.getHeader(headerName);
            StringTokenizer values = new StringTokenizer(headerValue, ",");
            while (values.hasMoreTokens()) {
                headers.addHeader(headerName, values.nextToken().trim());
            }
        }
        return headers;
    }

    protected static void putHeaders(MimeHeaders headers, HttpServletResponse res) {
        Iterator it = headers.getAllHeaders();
        while (it.hasNext()) {
            MimeHeader header = (MimeHeader)it.next();
            String[] values = headers.getHeader(header.getName());
            if (values.length == 1) {
                res.setHeader(header.getName(), header.getValue());
                continue;
            }
            StringBuffer concat = new StringBuffer();
            int i = 0;
            while (i < values.length) {
                if (i != 0) {
                    concat.append(',');
                }
                concat.append(values[i++]);
            }
            res.setHeader(header.getName(), concat.toString());
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            MimeHeaders headers = JAXMServlet.getHeaders(req);
            ServletInputStream is = req.getInputStream();
            SOAPMessage msg = this.msgFactory.createMessage(headers, (InputStream)is);
            SOAPMessage reply = null;
            if (this instanceof ReqRespListener) {
                reply = ((ReqRespListener)((Object)this)).onMessage(msg);
            } else if (this instanceof OnewayListener) {
                ((OnewayListener)((Object)this)).onMessage(msg);
            } else {
                String lstnrMsg = cr.getKString("S4009", ((Object)((Object)this)).getClass().getName());
                throw new ServletException(lstnrMsg);
            }
            if (reply != null) {
                if (reply.saveRequired()) {
                    reply.saveChanges();
                }
                resp.setStatus(200);
                JAXMServlet.putHeaders(reply.getMimeHeaders(), resp);
                ServletOutputStream os = resp.getOutputStream();
                reply.writeTo((OutputStream)os);
                os.flush();
            } else {
                resp.setStatus(204);
            }
        }
        catch (Exception ex) {
            String postMsg = cr.getKString("S4010");
            throw new ServletException(postMsg + "\n" + ex.getMessage());
        }
    }
}

