/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws.servedcontent;

import java.io.IOException;
import java.net.URI;

public interface Content {
    public State state();

    public boolean isAvailable(URI var1) throws IOException;

    public void suspend();

    public void resume();

    public void start();

    public void stop();

    public static class Adapter
    implements Content {
        private State state = State.AVAILABLE;

        @Override
        public State state() {
            return this.state;
        }

        @Override
        public boolean isAvailable(URI requestURI) throws IOException {
            return this.state == State.AVAILABLE;
        }

        @Override
        public void suspend() {
            this.state = State.SUSPENDED;
        }

        @Override
        public void resume() {
            this.state = State.AVAILABLE;
        }

        @Override
        public void start() {
            this.state = State.AVAILABLE;
        }

        @Override
        public void stop() {
            this.state = State.UNAVAILABLE;
        }
    }

    public static enum State {
        AVAILABLE,
        UNAVAILABLE,
        SUSPENDED;

    }
}

