/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.httptunnel.tunnel.server;

import com.sun.messaging.jmq.httptunnel.api.server.HttpTunnelServerDriver;
import com.sun.messaging.jmq.httptunnel.api.share.HttpTunnelDefaults;
import com.sun.messaging.jmq.httptunnel.tunnel.HttpTunnelConnection;
import com.sun.messaging.jmq.httptunnel.tunnel.HttpTunnelDriver;
import com.sun.messaging.jmq.httptunnel.tunnel.HttpTunnelPacket;
import com.sun.messaging.jmq.httptunnel.tunnel.Link;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;

public class HttpTunnelServerDriverImpl
extends Link
implements HttpTunnelDefaults,
HttpTunnelDriver,
HttpTunnelServerDriver {
    private static boolean DEBUG = Boolean.getBoolean("httptunnel.debug");
    protected static final boolean DEBUGLINK = Boolean.getBoolean("httptunnel.link.debug");
    protected Socket serverConn = null;
    protected Hashtable connTable = null;
    protected String serviceName;
    protected InetAddress webServerHost = null;
    protected int webServerPort = 0;
    protected int inactiveConnAbortInterval = 900000;
    protected int totalRetryWaited = 0;
    private Vector listenQ = null;
    private boolean listenState = false;
    protected int rxBufSize = 0;

    public static boolean getDEBUG() {
        return DEBUG;
    }

    @Override
    public void init(String serviceName) throws IOException {
        this.init(serviceName, InetAddress.getLocalHost().getHostAddress(), 7675);
    }

    @Override
    public void init(String serviceName, String webServerHostName, int webServerPort) throws IOException {
        this.serviceName = serviceName;
        this.webServerHost = InetAddress.getByName(webServerHostName);
        this.webServerPort = webServerPort;
        this.connTable = new Hashtable();
        this.listenQ = new Vector();
        this.setName("HttpTunnelServerDriver");
    }

    @Override
    public void setRxBufSize(int rxBufSize) {
        this.rxBufSize = rxBufSize;
    }

    @Override
    public Vector getListenQ() {
        return this.listenQ;
    }

    @Override
    public void listen(boolean listenState) throws IOException {
        boolean oldListenState = this.listenState;
        this.listenState = listenState;
        if (listenState != oldListenState) {
            this.sendListenStatePacket();
        }
    }

    @Override
    public int getInactiveConnAbortInterval() {
        return this.inactiveConnAbortInterval;
    }

    @Override
    public void setInactiveConnAbortInterval(int inactiveConnAbortInterval) {
        this.inactiveConnAbortInterval = inactiveConnAbortInterval;
    }

    @Override
    protected void createLink() {
        this.totalRetryWaited = 0;
        if (DEBUG) {
            this.log("http:connecting to " + this.webServerHost + ":" + this.webServerPort);
        }
        while (true) {
            try {
                this.serverConn = new Socket();
                if (this.rxBufSize > 0) {
                    try {
                        this.serverConn.setReceiveBufferSize(this.rxBufSize);
                    }
                    catch (SocketException e) {
                        this.log(Level.WARNING, "HTTP socket[" + this.webServerHost + ":" + this.webServerPort + "]setReceiveBufferSize(" + this.rxBufSize + "): " + e.toString(), e);
                    }
                }
                InetSocketAddress addr = new InetSocketAddress(this.webServerHost, this.webServerPort);
                this.serverConn.connect(addr);
                try {
                    this.serverConn.setTcpNoDelay(true);
                }
                catch (SocketException e) {
                    this.log(Level.WARNING, "HTTP socket[" + this.webServerHost + ":" + this.webServerPort + "]setTcpNoDelay: " + e.toString(), e);
                }
                if (DEBUG) {
                    this.log("######## rcvbuf = " + this.serverConn.getReceiveBufferSize());
                }
                this.is = this.serverConn.getInputStream();
                this.os = this.serverConn.getOutputStream();
                if (DEBUG || DEBUGLINK) {
                    this.log("Broker HTTP link up");
                }
                this.totalRetryWaited = 0;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(5000L);
                    this.totalRetryWaited += 5000;
                    if (this.totalRetryWaited < this.inactiveConnAbortInterval * 1000) continue;
                    if (DEBUG || DEBUGLINK) {
                        this.log("Retry connect to servlet timeout - cleanup all (" + this.connTable.size() + ") connections ...");
                    }
                    this.cleanupAllConns();
                    this.totalRetryWaited = 0;
                }
                catch (Exception exception2) {}
                continue;
            }
            break;
        }
        this.sendLinkInitPacket();
        this.sendListenStatePacket();
    }

    protected void sendListenStatePacket() {
        ByteArrayOutputStream bos;
        HttpTunnelPacket p;
        block2: {
            p = new HttpTunnelPacket();
            p.setPacketType(11);
            p.setConnId(0);
            p.setSequence(0);
            p.setWinsize(0);
            p.setChecksum(0);
            bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                dos.writeUTF(this.serviceName);
                dos.writeBoolean(this.listenState);
                dos.flush();
                bos.flush();
            }
            catch (Exception e) {
                if (!DEBUG && !DEBUGLINK) break block2;
                this.log("Got exception while sending LISTEN_STATE_PACKET packet: " + e.getMessage());
            }
        }
        byte[] buf = bos.toByteArray();
        p.setPacketBody(buf);
        this.sendPacket(p);
    }

    void sendLinkInitPacket() {
        ByteArrayOutputStream bos;
        HttpTunnelPacket p;
        block3: {
            p = new HttpTunnelPacket();
            p.setPacketType(8);
            p.setConnId(0);
            p.setSequence(0);
            p.setWinsize(0);
            p.setChecksum(0);
            bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                dos.writeUTF(this.serviceName);
                dos.writeInt(this.connTable.size());
                Enumeration e = this.connTable.elements();
                while (e.hasMoreElements()) {
                    HttpTunnelConnection conn = (HttpTunnelConnection)e.nextElement();
                    dos.writeInt(conn.getConnId());
                    dos.writeInt(conn.getPullPeriod());
                }
                dos.flush();
                bos.flush();
            }
            catch (Exception e) {
                if (!DEBUG && !DEBUGLINK) break block3;
                this.log("Got exception while sending LINK_INIT_PACKET packet: " + e.getMessage());
            }
        }
        byte[] buf = bos.toByteArray();
        p.setPacketBody(buf);
        this.sendPacket(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupAllConns() {
        Vector connids = new Vector();
        Hashtable hashtable = this.connTable;
        synchronized (hashtable) {
            Enumeration e = this.connTable.keys();
            while (e.hasMoreElements()) {
                connids.addElement(e.nextElement());
            }
        }
        for (int i = connids.size() - 1; i >= 0; --i) {
            String connId = (String)connids.elementAt(i);
            HttpTunnelConnection conn = (HttpTunnelConnection)this.connTable.get(connId);
            if (conn == null) continue;
            HttpTunnelPacket pkt = HttpTunnelServerDriverImpl.genAbortPacket(conn.getConnId());
            this.receivePacket(pkt);
        }
        this.connTable.clear();
        connids = null;
    }

    @Override
    protected void handleLinkDown() {
        if ((DEBUG || DEBUGLINK) && this.serverConn != null) {
            this.log("Broker HTTP link down");
        }
        try {
            this.serverConn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.serverConn = null;
    }

    public boolean isLinkReady() {
        return this.serverConn != null;
    }

    @Override
    protected void receivePacket(HttpTunnelPacket p) {
        int packetType = p.getPacketType();
        if (DEBUG) {
            this.log("Received Packet : " + p);
        }
        switch (packetType) {
            case 1: {
                this.handleNewConn(p);
                break;
            }
            case 5: {
                this.handleConnClose(p);
                break;
            }
            case 9: {
                this.handleConnAbort(p);
                break;
            }
            case 10: {
                this.handleConnOption(p);
                break;
            }
            case 4: 
            case 6: {
                this.handlePacket(p);
                break;
            }
            case 100: {
                this.handleDummyPacket(p);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNewConn(HttpTunnelPacket p) {
        Object dis;
        int connId = p.getConnId();
        String remoteip = null;
        byte[] payload = p.getPacketBody();
        if (payload != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(payload);
            dis = new DataInputStream(bis);
            try {
                ((DataInputStream)dis).readUTF();
                remoteip = ((DataInputStream)dis).readUTF();
            }
            catch (Exception e) {
                this.log(Level.WARNING, "Got exception while reading CONN_INIT_PACKET " + e.getMessage(), e);
            }
            try {
                ((FilterInputStream)dis).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        HttpTunnelConnection conn = new HttpTunnelConnection(connId, this);
        conn.setRemoteAddr(remoteip);
        dis = this.connTable;
        synchronized (dis) {
            this.connTable.put(Integer.toString(connId), conn);
        }
        HttpTunnelPacket reply = new HttpTunnelPacket();
        reply.setPacketType(2);
        reply.setPacketBody(null);
        reply.setConnId(connId);
        reply.setSequence(0);
        reply.setWinsize(0);
        reply.setChecksum(0);
        this.sendPacket(reply);
        Vector vector = this.listenQ;
        synchronized (vector) {
            this.listenQ.addElement(conn);
            this.listenQ.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnClose(HttpTunnelPacket p) {
        HttpTunnelConnection conn;
        int connId = p.getConnId();
        Hashtable hashtable = this.connTable;
        synchronized (hashtable) {
            conn = (HttpTunnelConnection)this.connTable.get(Integer.toString(connId));
        }
        if (conn == null) {
            return;
        }
        conn.handleClose(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnAbort(HttpTunnelPacket p) {
        HttpTunnelConnection conn;
        int connId = p.getConnId();
        Hashtable hashtable = this.connTable;
        synchronized (hashtable) {
            conn = (HttpTunnelConnection)this.connTable.get(Integer.toString(connId));
        }
        if (conn == null) {
            return;
        }
        conn.handleAbort(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnOption(HttpTunnelPacket p) {
        HttpTunnelConnection conn;
        int connId = p.getConnId();
        Hashtable hashtable = this.connTable;
        synchronized (hashtable) {
            conn = (HttpTunnelConnection)this.connTable.get(Integer.toString(connId));
        }
        if (conn == null) {
            return;
        }
        conn.handleConnOption(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePacket(HttpTunnelPacket p) {
        HttpTunnelConnection conn;
        int connId = p.getConnId();
        Hashtable hashtable = this.connTable;
        synchronized (hashtable) {
            conn = (HttpTunnelConnection)this.connTable.get(Integer.toString(connId));
        }
        if (conn == null) {
            return;
        }
        conn.receivePacket(p, false);
    }

    private void handleDummyPacket(HttpTunnelPacket p) {
        if (DEBUG) {
            this.log("#### Received dummy packet :");
            this.log(p + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown(int connId) {
        Hashtable hashtable = this.connTable;
        synchronized (hashtable) {
            this.connTable.remove(Integer.toString(connId));
        }
        HttpTunnelPacket p = new HttpTunnelPacket();
        p.setPacketType(7);
        p.setPacketBody(null);
        p.setConnId(connId);
        p.setSequence(0);
        p.setWinsize(0);
        p.setChecksum(0);
        this.sendPacket(p);
    }

    private static HttpTunnelPacket genAbortPacket(int connId) {
        HttpTunnelPacket p = new HttpTunnelPacket();
        p.setPacketType(9);
        p.setConnId(connId);
        p.setSequence(0);
        p.setWinsize(0);
        p.setChecksum(0);
        p.setPacketBody(null);
        return p;
    }

    @Override
    public Hashtable getDebugState() {
        return new Hashtable();
    }
}

