/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.BrokerDialog;
import com.sun.messaging.jmq.admin.apps.console.BrokerListCObj;
import com.sun.messaging.jmq.admin.apps.console.ConsoleBrokerAdminManager;
import com.sun.messaging.jmq.admin.event.BrokerAdminEvent;
import java.awt.Frame;
import javax.swing.JOptionPane;

public class BrokerAddDialog
extends BrokerDialog {
    private static final long serialVersionUID = 8614247311016731996L;
    public static final String DEFAULT_BROKER_HOST = "localhost";
    public static final String DEFAULT_PRIMARY_PORT = "7676";
    private BrokerListCObj blCObj;

    public BrokerAddDialog(Frame parent, BrokerListCObj blCObj) {
        super(parent, acr.getString("A1131"), 89);
        this.setHelpId("add_broker");
        this.blCObj = blCObj;
    }

    @Override
    public void doOK() {
        String brokerName = null;
        brokerName = this.brokerNameTF.getText();
        if ((brokerName = brokerName.trim()).equals("")) {
            JOptionPane.showOptionDialog(this, acr.getString("A3018"), acr.getString("A1131") + ": " + acr.getString("A1218", "A3018"), 0, 0, null, close, close[0]);
            return;
        }
        if (!this.isValidString(this.hostTF.getText()) || !this.isValidString(this.portTF.getText())) {
            JOptionPane.showOptionDialog(this, acr.getString("A3019"), acr.getString("A1131") + ": " + acr.getString("A1218", "A3019"), 0, 0, null, close, close[0]);
            return;
        }
        BrokerAdminEvent bae = new BrokerAdminEvent(this, 1);
        bae.setConnectAttempt(false);
        bae.setBrokerName(brokerName);
        bae.setHost(this.hostTF.getText());
        bae.setPort(Integer.parseInt(this.portTF.getText()));
        bae.setUsername(this.userTF.getText());
        bae.setPassword(String.valueOf(this.passwdTF.getPassword()));
        bae.setOKAction(true);
        this.fireAdminEventDispatched(bae);
    }

    @Override
    public void doReset() {
        this.reset();
    }

    @Override
    public void doCancel() {
        this.hide();
        this.reset();
    }

    @Override
    public void doApply() {
    }

    @Override
    public void doClear() {
    }

    @Override
    public void doClose() {
    }

    @Override
    public void show() {
        this.doReset();
        this.setEditable(true);
        super.show();
    }

    private void reset() {
        this.brokerNameTF.setText(this.getBrokerName(acr.getString("A1423")));
        this.hostTF.setText(DEFAULT_BROKER_HOST);
        this.portTF.setText(DEFAULT_PRIMARY_PORT);
        this.userTF.setText("admin");
        this.passwdTF.setText("");
    }

    protected String getBrokerName(String baseName) {
        ConsoleBrokerAdminManager baMgr = this.blCObj.getBrokerAdminManager();
        if (!baMgr.exist(baseName)) {
            return baseName;
        }
        for (int i = 1; i < 1000; ++i) {
            String newStr = baseName + i;
            if (baMgr.exist(newStr)) continue;
            return newStr;
        }
        return "";
    }
}

