/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.bkrutil;

import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminConn;
import com.sun.messaging.jmq.admin.util.CommonGlobals;
import javax.jms.Message;

class MessageAckThread
implements Runnable {
    private Thread ackThread = null;
    private BrokerAdminConn ba;
    private boolean msgReceived = false;
    private long timeout = 30000L;
    private boolean debug = BrokerAdminConn.getDebug();
    private boolean stopRequested = false;

    public MessageAckThread(BrokerAdminConn ba) {
        if (this.debug) {
            CommonGlobals.stdOutPrintln("***** Created MessageAckThread");
        }
        this.ba = ba;
    }

    public synchronized void start() {
        if (this.ackThread == null) {
            this.ackThread = new Thread((Runnable)this, "JMQ Administration MessageAckThread");
            this.ackThread.start();
            if (this.debug) {
                CommonGlobals.stdOutPrintln("***** Started MessageAckThread");
            }
        }
    }

    public synchronized void stop() {
        this.stopRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Message mesg = null;
        this.ba.setBusy(true);
        while (!this.msgReceived && this.ackThread != null && !this.stopRequested) {
            try {
                MessageAckThread messageAckThread;
                mesg = this.ba.receiver.receive(this.timeout);
                if (mesg != null) {
                    if (this.debug) {
                        CommonGlobals.stdOutPrintln("***** MessageAckThread: received reply message !");
                    }
                    this.msgReceived = true;
                    if (this.debug) {
                        CommonGlobals.stdOutPrintln("***** MessageAckThread: acknowledging reply message.");
                    }
                    mesg.acknowledge();
                    messageAckThread = this;
                    synchronized (messageAckThread) {
                        this.ba.setBusy(false);
                        this.ba.sendStatusEvent(mesg, null);
                        continue;
                    }
                }
                messageAckThread = this;
                synchronized (messageAckThread) {
                    if (this.stopRequested) {
                        if (this.debug) {
                            CommonGlobals.stdOutPrintln("***** MessageAckThread: receive() timed out. Not retrying (stop requested).");
                        }
                        this.stopRequested = false;
                        this.ackThread = null;
                        return;
                    }
                }
                if (!this.debug) continue;
                CommonGlobals.stdOutPrintln("***** MessageAckThread: receive() timed out. Retrying...");
            }
            catch (Exception e) {
                MessageAckThread messageAckThread = this;
                synchronized (messageAckThread) {
                    this.ba.setBusy(false);
                    this.ba.sendStatusEvent(null, e);
                }
            }
        }
        this.ba.setBusy(false);
    }
}

