/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.DateManager;
import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.IconHyperlink;
import com.sun.webui.jsf.component.NextMonthListener;
import com.sun.webui.jsf.component.PreviousMonthListener;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.model.ScheduledEvent;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.beans.Beans;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import javax.el.ValueExpression;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.IntegerConverter;

public class CalendarMonth
extends UIOutput
implements NamingContainer {
    public static final String MONTH_MENU_ID = "monthMenu";
    public static final String YEAR_MENU_ID = "yearMenu";
    public static final String PREVIOUS_MONTH_LINK_ID = "previousMonthLink";
    public static final String NEXT_MONTH_LINK_ID = "nextMonthLink";
    public static final String DATE_LINK_ID = "dateLink";
    public static final String DATE_FIELD_ID = "dateField";
    public static final String DATE_FORMAT_ATTR = "dateFormatAttr";
    public static final String DATE_FORMAT_PATTERN_ATTR = "dateFormatPatternAttr";
    private static final String TIME_ZONE_ATTR = "timeZoneAttr";
    private Calendar calendar = null;
    private static final boolean DEBUG = false;
    private String javaScriptObjectName = null;
    private boolean popup = false;
    private boolean popup_set = false;

    public CalendarMonth() {
        this.setRendererType("com.sun.webui.jsf.CalendarMonth");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.CalendarMonth";
    }

    public boolean isDateSelected(Calendar current, Calendar endDate) {
        Object value = this.getValue();
        if (value == null) {
            return false;
        }
        if (value instanceof Date) {
            Calendar calendar = this.getCalendar();
            calendar.setTime((Date)value);
            return this.compareDate(calendar, current);
        }
        if (value instanceof ScheduledEvent) {
            Iterator dates = ((ScheduledEvent)value).getDates(endDate);
            Calendar calendar = null;
            while (dates.hasNext()) {
                calendar = (Calendar)dates.next();
                if (!this.compareDate(calendar, current)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean compareDate(Calendar selected, Calendar current) {
        return selected.get(1) == current.get(1) && selected.get(2) == current.get(2) && selected.get(5) == current.get(5);
    }

    protected Locale getLocale() {
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getViewRoot().getLocale();
    }

    public Calendar getCalendar() {
        if (this.calendar == null) {
            this.initializeCalendar();
        }
        return (Calendar)this.calendar.clone();
    }

    private void initializeCalendar() {
        Locale locale = this.getLocale();
        TimeZone tz = this.getTimeZone();
        this.calendar = tz == null ? Calendar.getInstance(locale) : Calendar.getInstance(tz, locale);
    }

    public DateFormat getDateFormat() {
        Object o = this.getAttributes().get(DATE_FORMAT_ATTR);
        DateFormat dateFormat = null;
        if (o != null && o instanceof DateFormat) {
            dateFormat = (DateFormat)o;
            return dateFormat;
        }
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, this.getLocale());
        simpleDateFormat.setCalendar(this.getCalendar());
        simpleDateFormat.applyPattern(this.getDateFormatPattern(simpleDateFormat));
        if (!Beans.isDesignTime()) {
            this.getAttributes().put(DATE_FORMAT_ATTR, simpleDateFormat);
        }
        return simpleDateFormat;
    }

    public TimeZone getTimeZone() {
        Object tzo = this.getAttributes().get(TIME_ZONE_ATTR);
        if (tzo != null && tzo instanceof TimeZone) {
            return (TimeZone)tzo;
        }
        UIComponent parent = this.getParent();
        TimeZone tz = null;
        try {
            tz = ((DateManager)parent).getTimeZone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tz == null) {
            tz = Calendar.getInstance(this.getLocale()).getTimeZone();
        }
        if (!Beans.isDesignTime()) {
            this.getAttributes().put(TIME_ZONE_ATTR, tz);
        }
        return tz == null ? TimeZone.getDefault() : tz;
    }

    public void setTimeZone(TimeZone tz) {
        this.getAttributes().remove(TIME_ZONE_ATTR);
        this.calendar = null;
    }

    public DropDown getMonthMenu() {
        UIComponent comp = this.getFacet(MONTH_MENU_ID);
        DropDown monthMenu = null;
        if (comp == null || !(comp instanceof DropDown)) {
            monthMenu = new DropDown();
            monthMenu.setSubmitForm(true);
            monthMenu.setConverter((Converter)new IntegerConverter());
            monthMenu.setId(MONTH_MENU_ID);
            if (!this.isPopup()) {
                monthMenu.setImmediate(true);
            }
            this.getFacets().put(MONTH_MENU_ID, monthMenu);
        } else {
            monthMenu = (DropDown)comp;
        }
        return monthMenu;
    }

    public DropDown getYearMenu() {
        DropDown yearMenu = (DropDown)this.getFacets().get(YEAR_MENU_ID);
        if (yearMenu == null) {
            yearMenu = new DropDown();
            yearMenu.setSubmitForm(true);
            yearMenu.setId(YEAR_MENU_ID);
            yearMenu.setConverter((Converter)new IntegerConverter());
            if (!this.isPopup()) {
                yearMenu.setImmediate(true);
            }
            this.getFacets().put(YEAR_MENU_ID, yearMenu);
        }
        return yearMenu;
    }

    public IconHyperlink getPreviousMonthLink() {
        IconHyperlink link = (IconHyperlink)this.getFacets().get(PREVIOUS_MONTH_LINK_ID);
        if (link == null) {
            link = new IconHyperlink();
            link.setId(PREVIOUS_MONTH_LINK_ID);
            link.setIcon("SCHEDULER_BACKWARD");
            link.setBorder(0);
            if (!this.isPopup()) {
                link.setImmediate(true);
                link.addActionListener(new PreviousMonthListener());
            }
            this.getFacets().put(PREVIOUS_MONTH_LINK_ID, link);
        }
        return link;
    }

    public IconHyperlink getNextMonthLink() {
        IconHyperlink link = (IconHyperlink)this.getFacets().get(NEXT_MONTH_LINK_ID);
        if (link == null) {
            link = new IconHyperlink();
            link.setId(NEXT_MONTH_LINK_ID);
            link.setIcon("SCHEDULER_FORWARD");
            link.setBorder(0);
            if (!this.isPopup()) {
                link.addActionListener(new NextMonthListener());
                link.setImmediate(true);
            }
            this.getFacets().put(NEXT_MONTH_LINK_ID, link);
        }
        return link;
    }

    protected Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    public void initCalendarControls(String jsName) {
        StringBuffer js = new StringBuffer().append(jsName).append(".decreaseMonth(); return false;");
        IconHyperlink link = this.getPreviousMonthLink();
        link.setIcon("CALENDAR_BACKWARD");
        link.setOnClick(js.toString());
        js = new StringBuffer().append(jsName).append(".increaseMonth(); return false;");
        link = this.getNextMonthLink();
        link.setIcon("CALENDAR_FORWARD");
        link.setOnClick(js.toString());
        this.getMonthMenu().setOnChange(jsName.concat(".redrawCalendar(false); return false;"));
        this.getYearMenu().setOnChange(jsName.concat(".redrawCalendar(false); return false;"));
    }

    public void showNextMonth() {
        Integer month = this.getCurrentMonth();
        DropDown monthMenu = this.getMonthMenu();
        if (month < 12) {
            int newMonth = month + 1;
            monthMenu.setSubmittedValue(new String[]{String.valueOf(newMonth)});
        } else if (this.showNextYear()) {
            monthMenu.setSubmittedValue(new String[]{"1"});
        }
    }

    public void showPreviousMonth() {
        Integer month = this.getCurrentMonth();
        DropDown monthMenu = this.getMonthMenu();
        if (month > 1) {
            int newMonth = month - 1;
            monthMenu.setSubmittedValue(new String[]{String.valueOf(newMonth)});
        } else if (this.showPreviousYear()) {
            monthMenu.setSubmittedValue(new String[]{"12"});
        }
    }

    private boolean showNextYear() {
        DropDown yearMenu = this.getYearMenu();
        int year = this.getCurrentYear();
        Option[] options = yearMenu.getOptions();
        Integer lastYear = (Integer)options[options.length - 1].getValue();
        if (lastYear >= ++year) {
            yearMenu.setSubmittedValue(new String[]{String.valueOf(year)});
            return true;
        }
        return false;
    }

    private boolean showPreviousYear() {
        DropDown yearMenu = this.getYearMenu();
        int year = this.getCurrentYear();
        Option[] options = yearMenu.getOptions();
        Integer firstYear = (Integer)options[0].getValue();
        if (firstYear <= --year) {
            yearMenu.setSubmittedValue(new String[]{String.valueOf(year)});
            return true;
        }
        return false;
    }

    public Integer getCurrentMonth() {
        DropDown monthMenu = this.getMonthMenu();
        Object value = monthMenu.getSubmittedValue();
        Integer month = null;
        if (value != null) {
            try {
                String[] vals = (String[])value;
                month = Integer.decode(vals[0]);
            }
            catch (Exception exception) {}
        } else {
            value = monthMenu.getValue();
            if (value != null && value instanceof Integer) {
                month = (Integer)value;
            }
        }
        return month;
    }

    public Integer getCurrentYear() {
        DropDown yearMenu = this.getYearMenu();
        Object value = yearMenu.getSubmittedValue();
        Integer year = null;
        if (value != null) {
            try {
                String[] vals = (String[])value;
                year = Integer.decode(vals[0]);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            value = yearMenu.getValue();
            if (value != null && value instanceof Integer) {
                year = (Integer)value;
            }
        }
        return year;
    }

    public String getJavaScriptObjectName() {
        return this.javaScriptObjectName;
    }

    public void setJavaScriptObjectName(String javaScriptObjectName) {
        this.javaScriptObjectName = javaScriptObjectName;
    }

    private void log(String s) {
        System.out.println(((Object)((Object)this)).getClass().getName() + "::" + s);
    }

    public String getDateFormatPattern() {
        return this.getDateFormatPattern(null);
    }

    public String getDateFormatPattern(SimpleDateFormat dateFormat) {
        if (dateFormat == null) {
            Object dfp = this.getAttributes().get(DATE_FORMAT_PATTERN_ATTR);
            Object pattern = null;
            if (dfp != null && dfp instanceof String) {
                return (String)dfp;
            }
            dateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, this.getLocale());
        }
        String pattern = null;
        UIComponent parent = this.getParent();
        if (parent != null && parent instanceof DateManager) {
            pattern = ((DateManager)parent).getDateFormatPattern();
        }
        if (pattern == null) {
            pattern = dateFormat.toPattern();
            if (pattern.indexOf("yyyy") == -1) {
                pattern = pattern.replaceFirst("yy", "yyyy");
            }
            if (pattern.indexOf("MM") == -1) {
                pattern = pattern.replaceFirst("M", "MM");
            }
            if (pattern.indexOf("dd") == -1) {
                pattern = pattern.replaceFirst("d", "dd");
            }
        }
        dateFormat.applyPattern(pattern);
        pattern = dateFormat.toPattern();
        if (!Beans.isDesignTime()) {
            this.getAttributes().put(DATE_FORMAT_PATTERN_ATTR, pattern);
        }
        return pattern;
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        this.getAttributes().remove(DATE_FORMAT_PATTERN_ATTR);
        this.getAttributes().remove(DATE_FORMAT_ATTR);
    }

    public void displayValue() {
        DropDown monthMenu = this.getMonthMenu();
        DropDown yearMenu = this.getYearMenu();
        Object value = this.getValue();
        if (value == null) {
            monthMenu.setValue(null);
            yearMenu.setValue(null);
        } else if (value instanceof Date) {
            Calendar calendar = this.getCalendar();
            calendar.setTime((Date)value);
            int newMonth = calendar.get(2) + 1;
            monthMenu.setValue(new Integer(newMonth));
            int newYear = calendar.get(1);
            yearMenu.setValue(new Integer(newYear));
        } else if (value instanceof ScheduledEvent) {
            Date date = ((ScheduledEvent)value).getStartTime();
            if (date != null) {
                Calendar calendar = this.getCalendar();
                calendar.setTime(date);
                int newMonth = calendar.get(2) + 1;
                monthMenu.setValue(new Integer(newMonth));
                int newYear = calendar.get(1);
                yearMenu.setValue(new Integer(newYear));
            } else {
                monthMenu.setValue(null);
                yearMenu.setValue(null);
            }
        }
        monthMenu.setSubmittedValue(null);
        yearMenu.setSubmittedValue(null);
    }

    public boolean isPopup() {
        if (this.popup_set) {
            return this.popup;
        }
        ValueExpression _vb = this.getValueExpression("popup");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return false;
    }

    public void setPopup(boolean popup) {
        this.popup = popup;
        this.popup_set = true;
    }

    public void restoreState(FacesContext _context, Object _state) {
        Object[] _values = (Object[])_state;
        super.restoreState(_context, _values[0]);
        this.popup = (Boolean)_values[1];
        this.popup_set = (Boolean)_values[2];
    }

    public Object saveState(FacesContext _context) {
        Object[] _values = new Object[]{super.saveState(_context), this.popup ? Boolean.TRUE : Boolean.FALSE, this.popup_set ? Boolean.TRUE : Boolean.FALSE};
        return _values;
    }
}

