/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Hyperlink;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.component.ImageComponent;
import com.sun.webui.jsf.component.Masthead;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class MastheadRenderer
extends AbstractRenderer {
    private static final String SKIP_UTILITY = "skipUtility";

    protected void renderAlarmsInfo(FacesContext context, Masthead masthead, ResponseWriter writer, int[] alarms, Theme theme) throws IOException {
        writer.startElement("td", (UIComponent)masthead);
        writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_ALARM_DIV"), null);
        UIComponent alarmsFacet = masthead.getFacet("currentAlarmsInfo");
        if (alarmsFacet != null) {
            RenderingUtilities.renderComponent(alarmsFacet, context);
        } else {
            writer.startElement("span", (UIComponent)masthead);
            writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_LABEL"), null);
            writer.write(theme.getMessage("masthead.currentAlarms"));
            writer.endElement("span");
            writer.write("&nbsp;&nbsp;");
            this.writeAlarmCount(writer, context, "ALARM_MASTHEAD_DOWN_MEDIUM", "Alarm.downImageAltText", masthead, "MASTHEAD_ALARM_DOWN_TEXT", alarms[0], theme);
            this.writeAlarmCount(writer, context, "ALARM_MASTHEAD_CRITICAL_MEDIUM", "Alarm.criticalImageAltText", masthead, "MASTHEAD_ALARM_CRITICAL_TEXT", alarms[1], theme);
            this.writeAlarmCount(writer, context, "ALARM_MASTHEAD_MAJOR_MEDIUM", "Alarm.majorImageAltText", masthead, "MASTHEAD_ALARM_MAJOR_TEXT", alarms[2], theme);
            this.writeAlarmCount(writer, context, "ALARM_MASTHEAD_MINOR_MEDIUM", "Alarm.minorImageAltText", masthead, "MASTHEAD_ALARM_MINOR_TEXT", alarms[3], theme);
        }
        writer.endElement("td");
    }

    protected void renderApplicationInfo(FacesContext context, Masthead masthead, ResponseWriter writer, Theme theme) throws IOException {
        writer.startElement("td", (UIComponent)masthead);
        writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_TD_TITLE"), null);
        writer.writeAttribute("width", (Object)"99%", null);
        this.renderUserInfo(context, masthead, writer, theme);
        this.renderProductInfo(context, masthead, writer, theme.getStyleClass("MASTHEAD_DIV_TITLE"));
        writer.endElement("td");
    }

    protected void renderDateTimeInfo(FacesContext context, Masthead masthead, ResponseWriter writer, Theme theme) throws IOException {
        writer.startElement("td", (UIComponent)masthead);
        writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_TIME_DIV"), null);
        UIComponent timeStampFacet = masthead.getFacet("dateTimeInfo");
        if (timeStampFacet != null) {
            RenderingUtilities.renderComponent(timeStampFacet, context);
        } else {
            String textStyle = theme.getStyleClass("MASTHEAD_LABEL");
            writer.startElement("span", (UIComponent)masthead);
            writer.writeAttribute("class", (Object)textStyle, null);
            writer.write(theme.getMessage("masthead.lastUpdate"));
            writer.endElement("span");
            writer.write("&nbsp;");
            writer.startElement("span", (UIComponent)masthead);
            writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_TEXT"), null);
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 1, context.getViewRoot().getLocale());
            writer.write(dateFormat.format(new Date()));
            writer.endElement("span");
            writer.write("&nbsp;");
        }
        writer.endElement("td");
    }

    protected void renderJobsInfo(FacesContext context, Masthead masthead, ResponseWriter writer, boolean divIsOpen, Theme theme) throws IOException {
        writer.startElement("td", (UIComponent)masthead);
        writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_STATUS_DIV"), null);
        UIComponent jobsFacet = masthead.getFacet("jobsInfo");
        if (jobsFacet != null) {
            RenderingUtilities.renderComponent(jobsFacet, context);
        } else {
            Icon icon = ThemeUtilities.getIcon(theme, "MASTHEAD_STATUS_ICON");
            icon.setId(masthead.getId() + "_jobStatusImage");
            icon.setAlt(theme.getMessage("masthead.tasksRunningAltText"));
            icon.setAlign("top");
            icon.setBorder(0);
            RenderingUtilities.renderComponent((UIComponent)icon, context);
            writer.write("&nbsp;");
            Hyperlink hl = (Hyperlink)masthead.getJobCountLink();
            RenderingUtilities.renderComponent((UIComponent)hl, context);
        }
        writer.endElement("td");
    }

    protected void renderNotificationInfo(FacesContext context, Masthead masthead, ResponseWriter writer, boolean leaveDivOpen, Theme theme) throws IOException {
        writer.startElement("td", (UIComponent)masthead);
        writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_TABLE_END"), null);
        UIComponent notificationFacet = masthead.getFacet("notificationInfo");
        if (notificationFacet != null) {
            RenderingUtilities.renderComponent(notificationFacet, context);
        } else {
            ImageComponent image = new ImageComponent();
            image.setId(masthead.getId() + "_notificationInfo");
            image.setParent((UIComponent)masthead);
            image.setIcon("MASTHEAD_STATUS_ICON");
            image.setAlign("top");
            image.setBorder(0);
            image.setAlt(theme.getMessage("Alert.infoImageAltText"));
            RenderingUtilities.renderComponent((UIComponent)image, context);
            writer.write("&nbsp;");
            writer.startElement("span", (UIComponent)masthead);
            writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_LABEL"), null);
            writer.write(masthead.getNotificationMsg());
            writer.endElement("span");
        }
        writer.endElement("td");
    }

    protected void renderProductInfo(FacesContext context, Masthead masthead, ResponseWriter writer, String styleName) throws IOException {
        UIComponent productImage = this.getProductImage(context, masthead, ThemeUtilities.getTheme(context));
        if (productImage == null) {
            return;
        }
        writer.startElement("div", (UIComponent)masthead);
        if (styleName != null && styleName.length() > 0) {
            writer.writeAttribute("class", (Object)styleName, null);
        }
        RenderingUtilities.renderComponent(productImage, context);
        writer.endElement("div");
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Masthead masthead = (Masthead)component;
        Theme theme = ThemeUtilities.getTheme(context);
        if (masthead.isSecondary()) {
            this.renderSecondaryMasthead(context, masthead, theme, writer);
        } else {
            this.renderPrimaryMasthead(context, masthead, theme, writer);
        }
    }

    protected void renderStatusArea(FacesContext context, Masthead masthead, ResponseWriter writer, Theme theme) throws IOException {
        UIComponent statusArea = masthead.getFacet("statusArea");
        if (statusArea != null) {
            this.startTable(writer, masthead, theme.getStyleClass("MASTHEAD_TABLE_END"));
            writer.startElement("tr", (UIComponent)masthead);
            writer.startElement("td", (UIComponent)masthead);
            String labelStyle = theme.getStyleClass("MASTHEAD_LABEL");
            String textStyle = theme.getStyleClass("MASTHEAD_TEXT");
            RenderingUtilities.renderComponent(statusArea, context);
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("table");
        } else {
            this.renderStatusAreaComponents(context, masthead, theme, writer);
        }
    }

    protected void renderUserInfo(FacesContext context, Masthead masthead, ResponseWriter writer, Theme theme) throws IOException {
        String labelStyle = theme.getStyleClass("MASTHEAD_LABEL");
        String textStyle = theme.getStyleClass("MASTHEAD_TEXT");
        writer.startElement("div", (UIComponent)masthead);
        writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_DIV_USER"), null);
        ImageComponent separator = new ImageComponent();
        separator.setParent((UIComponent)masthead);
        separator.setIcon("MASTHEAD_SEPARATOR");
        separator.setAlt(theme.getMessage("masthead.statusAreaSepAltText"));
        this.renderUserInfo(context, masthead, theme, labelStyle, textStyle, (UIComponent)separator, writer);
        this.renderRoleInfo(context, masthead, theme, labelStyle, textStyle, (UIComponent)separator, writer);
        this.renderServerInfo(context, masthead, theme, labelStyle, textStyle, writer);
        writer.endElement("div");
    }

    protected void renderUtilityBar(FacesContext context, Masthead masthead, ResponseWriter writer, Theme theme) throws IOException {
        String style;
        boolean areExtraLinks;
        boolean consoleLinkDisplayed;
        UIComponent facet = masthead.getFacet("utilityBar");
        if (facet != null) {
            RenderingUtilities.renderComponent(facet, context);
            return;
        }
        writer.startElement("tr", (UIComponent)masthead);
        writer.startElement("td", (UIComponent)masthead);
        writer.writeAttribute("nowrap", (Object)"nowrap", null);
        String styleName = null;
        String buttonClassName = theme.getStyleClass("MASTHEAD_BUTTON");
        facet = masthead.getFacet("consoleLink");
        boolean bl = consoleLinkDisplayed = facet != null;
        if (consoleLinkDisplayed) {
            writer.startElement("div", (UIComponent)masthead);
            writer.writeAttribute("class", (Object)buttonClassName, null);
            styleName = "MASTHEAD_LINK";
            this.setAttrs(facet, "MastheadConsoleLink", (UIComponent)masthead, theme.getMessage("masthead.consoleLabel"), theme.getStyleClass(styleName), theme.getMessage("masthead.consoleTooltip"), theme.getMessage("masthead.consoleStatus"));
            RenderingUtilities.renderComponent(facet, context);
            writer.endElement("div");
            this.appendDotImage(writer, context, masthead, "_utilPad", 1, 8, theme);
        }
        if ((facet = masthead.getFacet("versionLink")) != null) {
            writer.startElement("div", (UIComponent)masthead);
            writer.writeAttribute("class", (Object)buttonClassName, null);
            styleName = consoleLinkDisplayed ? "MASTHEAD_LINK_RIGHT" : "MASTHEAD_LINK";
            String styleClass = theme.getStyleClass(styleName);
            this.setAttrs(facet, "MastheadVersionLink", (UIComponent)masthead, theme.getMessage("masthead.versionLabel"), styleClass, theme.getMessage("masthead.versionTooltip"), theme.getMessage("masthead.versionStatus"));
            RenderingUtilities.renderComponent(facet, context);
            writer.endElement("div");
        }
        writer.endElement("td");
        writer.startElement("td", (UIComponent)masthead);
        writer.writeAttribute("align", (Object)"right", null);
        writer.writeAttribute("valign", (Object)"bottom", null);
        String leftLinkStyle = theme.getStyleClass("MASTHEAD_LINK_LEFT");
        String centerLinkStyle = theme.getStyleClass("MASTHEAD_LINK_CENTER");
        String rightLinkStyle = theme.getStyleClass("MASTHEAD_LINK_RIGHT");
        String singleLinkStyle = theme.getStyleClass("MASTHEAD_LINK");
        UIComponent logoutFacet = masthead.getFacet("logoutLink");
        UIComponent helpFacet = masthead.getFacet("helpLink");
        UIComponent searchFacet = masthead.getFacet("search");
        Hyperlink[] extraLinks = masthead.getUtilities();
        boolean logoutLinkDisplayed = logoutFacet != null;
        boolean helpLinkDisplayed = helpFacet != null;
        boolean bl2 = areExtraLinks = extraLinks != null;
        if (searchFacet != null) {
            RenderingUtilities.renderComponent(searchFacet, context);
            if (logoutLinkDisplayed || helpLinkDisplayed || areExtraLinks) {
                ImageComponent separator = new ImageComponent();
                separator.setId("searchSeparator");
                separator.setIcon("MASTHEAD_SEPARATOR_BUTTONS");
                RenderingUtilities.renderComponent((UIComponent)separator, context);
            }
        }
        if (areExtraLinks) {
            boolean extraLinksOnly = !logoutLinkDisplayed && !helpLinkDisplayed;
            StringBuilder sbId = new StringBuilder("_lp");
            int len = sbId.length();
            Icon dot = ThemeUtilities.getIcon(theme, "DOT");
            dot.setParent((UIComponent)masthead);
            dot.setWidth(8);
            dot.setHeight(1);
            dot.setBorder(0);
            dot.setAlt("");
            List children = masthead.getChildren();
            for (int i = 0; i < extraLinks.length; ++i) {
                Hyperlink link = extraLinks[i];
                if (link.getParent() == null) {
                    link.setParent((UIComponent)masthead);
                }
                writer.startElement("div", (UIComponent)masthead);
                writer.writeAttribute("class", (Object)buttonClassName, null);
                RenderingUtilities.renderComponent((UIComponent)link, context);
                writer.endElement("div");
                dot.setId(sbId.append(Integer.toString(i)).toString());
                sbId.setLength(len);
                RenderingUtilities.renderComponent((UIComponent)dot, context);
            }
        }
        if (logoutLinkDisplayed) {
            writer.startElement("div", (UIComponent)masthead);
            writer.writeAttribute("class", (Object)buttonClassName, null);
            style = "MASTHEAD_LINK";
            if (areExtraLinks && helpLinkDisplayed) {
                style = "MASTHEAD_LINK_CENTER";
            } else if (areExtraLinks && !helpLinkDisplayed) {
                style = "MASTHEAD_LINK_RIGHT";
            } else if (!areExtraLinks && helpLinkDisplayed) {
                style = "MASTHEAD_LINK_LEFT";
            }
            this.setAttrs(logoutFacet, "MastheadLogoutLink", (UIComponent)masthead, theme.getMessage("masthead.logoutLabel"), theme.getStyleClass(style), theme.getMessage("masthead.logoutTooltip"), theme.getMessage("masthead.logoutStatus"));
            RenderingUtilities.renderComponent(logoutFacet, context);
            writer.endElement("div");
            this.appendDotImage(writer, context, masthead, "_logoutPad", 1, 8, theme);
        }
        if (helpFacet != null) {
            writer.startElement("div", (UIComponent)masthead);
            writer.writeAttribute("class", (Object)buttonClassName, null);
            style = "MASTHEAD_LINK";
            if (areExtraLinks || logoutLinkDisplayed) {
                style = "MASTHEAD_LINK_RIGHT";
            }
            this.setAttrs(helpFacet, "MastheadHelpLink", (UIComponent)masthead, theme.getMessage("masthead.helpLabel"), theme.getStyleClass(style), theme.getMessage("masthead.helpLabel"), theme.getMessage("masthead.helpLabel"));
            RenderingUtilities.renderComponent(helpFacet, context);
            writer.endElement("div");
            this.appendDotImage(writer, context, masthead, "_helpPad", 1, 8, theme);
        }
        writer.endElement("td");
        writer.endElement("tr");
    }

    private void setAttrs(UIComponent component, String id, UIComponent parent, String label, String styleClass, String toolTip, String focusText) {
        Map attrs = component.getAttributes();
        StringBuffer focusBuff = new StringBuffer(64);
        focusBuff.append("window.status='").append(focusText).append("'; return true; ");
        focusText = focusBuff.toString();
        if (component.getId() == null) {
            component.setId(id);
        }
        if (component.getParent() == null) {
            parent.getChildren().add(component);
        }
        if (attrs.get("text") == null) {
            attrs.put("text", label);
        }
        if (attrs.get("toolTip") == null) {
            attrs.put("toolTip", toolTip);
        }
        if (attrs.get("onFocus") == null) {
            attrs.put("onFocus", focusText);
        }
        if (attrs.get("onMouseOver") == null) {
            attrs.put("onMouseOver", focusText);
        }
        if (attrs.get("onMouseOut") == null) {
            attrs.put("onMouseOut", "window.status=''; return true;");
        }
        if (attrs.get("onBlur") == null) {
            attrs.put("onBlur", "window.status=''; return true;");
        }
    }

    private void startTable(ResponseWriter writer, Masthead masthead, String styleName) throws IOException {
        writer.startElement("table", (UIComponent)masthead);
        writer.writeAttribute("width", (Object)"100%", null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("class", (Object)styleName, null);
        writer.writeAttribute("title", (Object)"", null);
    }

    private void writeAlarmCount(ResponseWriter writer, FacesContext context, String imageName, String imageAlt, Masthead masthead, String style, int count, Theme theme) throws IOException {
        Icon icon = ThemeUtilities.getIcon(theme, imageName);
        icon.setId(imageName);
        icon.setAlt(theme.getMessage(imageAlt));
        RenderingUtilities.renderComponent((UIComponent)icon, context);
        style = theme.getStyleClass(style);
        writer.startElement("span", (UIComponent)masthead);
        writer.writeAttribute("class", (Object)style, null);
        writer.write("&nbsp;" + count + "&nbsp;&nbsp;&nbsp;");
        writer.endElement("span");
    }

    private void writeSpan(ResponseWriter writer, Masthead masthead, String styleName, String text, FacesContext context, String id) throws IOException {
        writer.startElement("span", (UIComponent)masthead);
        writer.writeAttribute("id", (Object)(masthead.getClientId(context) + id), "id");
        writer.writeAttribute("class", (Object)styleName, null);
        writer.write(text != null ? text : "");
        writer.endElement("span");
    }

    private void appendDotImage(ResponseWriter writer, FacesContext context, Masthead masthead, String id, int ht, int wd, Theme theme) throws IOException {
        Icon dot = ThemeUtilities.getIcon(theme, "DOT");
        dot.setParent((UIComponent)masthead);
        dot.setId(id);
        dot.setParent((UIComponent)masthead);
        dot.setWidth(wd);
        dot.setHeight(ht);
        dot.setBorder(0);
        dot.setAlt(id + " dot image");
        RenderingUtilities.renderComponent((UIComponent)dot, context);
    }

    private void appendSeparator(ResponseWriter writer, FacesContext context, String align) throws IOException {
        ImageComponent separator = new ImageComponent();
        separator.setId("searchSeparator");
        separator.setIcon("MASTHEAD_SEPARATOR_STATUS");
        if (align != null) {
            separator.setAlign(align);
        }
        RenderingUtilities.renderComponent((UIComponent)separator, context);
    }

    protected UIComponent getBrandImage(FacesContext context, Masthead masthead, Theme theme) {
        UIComponent facet = masthead.getFacet("brandImage");
        if (facet != null) {
            return facet;
        }
        String imageAttr = masthead.getBrandImageURL();
        if (imageAttr != null && imageAttr.trim().length() != 0) {
            int dim;
            ImageComponent image = new ImageComponent();
            image.setUrl(imageAttr);
            imageAttr = masthead.getBrandImageDescription();
            if (imageAttr != null && imageAttr.trim().length() != 0) {
                image.setAlt(imageAttr);
            }
            if ((dim = masthead.getBrandImageHeight()) != 0) {
                image.setHeight(masthead.getBrandImageHeight());
            }
            if ((dim = masthead.getBrandImageWidth()) != 0) {
                image.setWidth(masthead.getBrandImageWidth());
            }
            return image;
        }
        Icon icon = null;
        try {
            String imagePath = theme.getImagePath("MASTHEAD_CORPLOGO");
            if (imagePath == null) {
                return null;
            }
            icon = ThemeUtilities.getIcon(theme, "MASTHEAD_CORPLOGO");
            icon.setId(masthead.getId() + "_brandImage");
            icon.setParent((UIComponent)masthead);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return icon;
    }

    protected UIComponent getProductImage(FacesContext context, Masthead masthead, Theme theme) {
        UIComponent productFacet = masthead.getFacet("productInfo");
        if (productFacet != null) {
            return productFacet;
        }
        String imageUrl = masthead.getProductImageURL();
        if (imageUrl == null || imageUrl.trim().length() == 0) {
            return null;
        }
        ImageComponent image = new ImageComponent();
        image.setId(masthead.getId() + "_productInfo");
        image.setParent((UIComponent)masthead);
        image.setUrl(imageUrl);
        image.setHeight(masthead.getProductImageHeight());
        image.setWidth(masthead.getProductImageWidth());
        image.setAlt(masthead.getProductImageDescription());
        return image;
    }

    protected void renderSecondaryMasthead(FacesContext context, Masthead masthead, Theme theme, ResponseWriter writer) throws IOException {
        this.startTable(writer, masthead, theme.getStyleClass("MASTHEAD_SECONDARY_STYLE"));
        writer.startElement("tr", (UIComponent)masthead);
        writer.startElement("td", (UIComponent)masthead);
        this.renderProductInfo(context, masthead, writer, null);
        writer.endElement("td");
        writer.startElement("td", (UIComponent)masthead);
        writer.writeAttribute("align", (Object)"right", null);
        UIComponent brandImage = this.getBrandImage(context, masthead, theme);
        if (brandImage != null) {
            RenderingUtilities.renderComponent(brandImage, context);
        }
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
    }

    protected void renderPrimaryMasthead(FacesContext context, Masthead masthead, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement("div", (UIComponent)masthead);
        String styleClass = theme.getStyleClass("MASTHEAD_DIV");
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)masthead, styleClass);
        String style = masthead.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.write("\n");
        RenderingUtilities.renderSkipLink(SKIP_UTILITY, theme.getStyleClass("SKIP_MEDIUM_GREY1"), null, theme.getMessage("masthead.statusSkipTagAltText"), null, (UIComponent)masthead, context);
        this.startTable(writer, masthead, theme.getStyleClass("MASTHEAD_TABLE_TOP"));
        this.renderUtilityBar(context, masthead, writer, theme);
        writer.endElement("table");
        this.startTable(writer, masthead, theme.getStyleClass("MASTHEAD_TABLE_BOTTOM"));
        writer.startElement("tr", (UIComponent)masthead);
        this.renderApplicationInfo(context, masthead, writer, theme);
        this.renderBrandImage(context, masthead, theme, writer);
        writer.endElement("tr");
        writer.startElement("tr", (UIComponent)masthead);
        writer.startElement("td", (UIComponent)masthead);
        writer.writeAttribute("colspan", (Object)"2", null);
        writer.startElement("div", (UIComponent)masthead);
        writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_HRULE"), null);
        this.appendDotImage(writer, context, masthead, "_mhrule", 1, 1, theme);
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        this.renderStatusArea(context, masthead, writer, theme);
        writer.endElement("div");
        RenderingUtilities.renderAnchor(SKIP_UTILITY, (UIComponent)masthead, context);
    }

    protected void renderStatusAreaComponents(FacesContext context, Masthead masthead, Theme theme, ResponseWriter writer) throws IOException {
        boolean havestatus;
        boolean isDateTime = masthead.isDateTime();
        String notificationMsg = masthead.getNotificationMsg();
        int[] alarmCounts = masthead.getAlarmCounts();
        int jobCount = masthead.getJobCount();
        UIComponent notificationInfo = masthead.getFacet("notificationInfo");
        UIComponent jobsInfo = masthead.getFacet("jobsInfo");
        UIComponent dateTimeInfo = masthead.getFacet("dateTimeInfo");
        UIComponent currentAlarmsInfo = masthead.getFacet("currentAlarmsInfo");
        boolean showNotification = notificationInfo != null || notificationMsg != null && notificationMsg.length() != 0;
        boolean showJobs = jobCount != -1 || jobsInfo != null;
        boolean bl = havestatus = isDateTime || alarmCounts != null || showJobs || dateTimeInfo != null || currentAlarmsInfo != null || showNotification;
        if (!havestatus) {
            return;
        }
        this.startTable(writer, masthead, theme.getStyleClass("MASTHEAD_TABLE_END"));
        writer.startElement("tr", (UIComponent)masthead);
        String labelStyle = theme.getStyleClass("MASTHEAD_LABEL");
        String textStyle = theme.getStyleClass("MASTHEAD_TEXT");
        boolean separatorFlag = false;
        if (showNotification) {
            this.renderNotificationInfo(context, masthead, writer, showNotification && showJobs, theme);
            separatorFlag = true;
        }
        if (showJobs) {
            if (separatorFlag) {
                writer.startElement("td", (UIComponent)masthead);
                writer.writeAttribute("valign", (Object)"middle", null);
                this.appendSeparator(writer, context, "top");
                writer.endElement("td");
                separatorFlag = false;
            }
            this.renderJobsInfo(context, masthead, writer, showNotification && showJobs, theme);
            separatorFlag = true;
        }
        if (isDateTime || dateTimeInfo != null) {
            if (separatorFlag) {
                writer.startElement("td", (UIComponent)masthead);
                writer.writeAttribute("valign", (Object)"middle", null);
                this.appendSeparator(writer, context, "top");
                writer.endElement("td");
                separatorFlag = false;
            }
            this.renderDateTimeInfo(context, masthead, writer, theme);
            separatorFlag = true;
        }
        if (alarmCounts != null && alarmCounts.length == 4 || currentAlarmsInfo != null) {
            if (separatorFlag) {
                writer.startElement("td", (UIComponent)masthead);
                writer.writeAttribute("valign", (Object)"middle", null);
                this.appendSeparator(writer, context, "top");
                writer.endElement("td");
            }
            this.renderAlarmsInfo(context, masthead, writer, alarmCounts, theme);
        }
        writer.endElement("tr");
        writer.endElement("table");
    }

    private void renderUserInfo(FacesContext context, Masthead masthead, Theme theme, String labelStyle, String textStyle, UIComponent separator, ResponseWriter writer) throws IOException {
        UIComponent facet = masthead.getFacet("userInfoLabel");
        if (facet != null) {
            RenderingUtilities.renderComponent(facet, context);
        } else {
            String label = masthead.getUserInfoLabel();
            if (label == null) {
                label = theme.getMessage("masthead.userLabel");
            }
            this.writeSpan(writer, masthead, labelStyle, label, context, "_userLabel");
        }
        writer.write("&nbsp;");
        facet = masthead.getFacet("userInfo");
        if (facet != null) {
            RenderingUtilities.renderComponent(facet, context);
        } else {
            this.writeSpan(writer, masthead, textStyle, masthead.getUserInfo(), context, "_userInfo");
        }
        separator.setId("_userInfoSeparator");
        RenderingUtilities.renderComponent(separator, context);
    }

    private void renderRoleInfo(FacesContext context, Masthead masthead, Theme theme, String labelStyle, String textStyle, UIComponent separator, ResponseWriter writer) throws IOException {
        boolean haveRoleFacet = false;
        String roleInfo = masthead.getRoleInfo();
        boolean haveRoleInfo = roleInfo != null && roleInfo.trim().length() != 0;
        UIComponent roleLabelFacet = masthead.getFacet("roleInfoLabel");
        if (roleLabelFacet != null) {
            RenderingUtilities.renderComponent(roleLabelFacet, context);
            haveRoleFacet = true;
        } else if (haveRoleInfo) {
            String label = masthead.getRoleInfoLabel();
            if (label == null) {
                label = theme.getMessage("masthead.roleLabel");
            }
            this.writeSpan(writer, masthead, labelStyle, label, context, "_roleLabel");
        }
        writer.write("&nbsp;");
        UIComponent roleInfoFacet = masthead.getFacet("roleInfo");
        if (roleInfoFacet != null) {
            RenderingUtilities.renderComponent(roleInfoFacet, context);
            haveRoleFacet = true;
        } else if (haveRoleInfo) {
            this.writeSpan(writer, masthead, textStyle, roleInfo, context, "_roleInfo");
        }
        if (haveRoleFacet || haveRoleInfo) {
            separator.setId("_roleInfoSeparator");
            RenderingUtilities.renderComponent(separator, context);
        }
    }

    private void renderServerInfo(FacesContext context, Masthead masthead, Theme theme, String labelStyle, String textStyle, ResponseWriter writer) throws IOException {
        UIComponent facet = masthead.getFacet("serverInfoLabel");
        if (facet != null) {
            RenderingUtilities.renderComponent(facet, context);
        } else {
            String label = masthead.getServerInfoLabel();
            if (label == null) {
                label = theme.getMessage("masthead.serverLabel");
            }
            this.writeSpan(writer, masthead, labelStyle, label, context, "_serverLabel");
        }
        writer.write("&nbsp;");
        facet = masthead.getFacet("serverInfo");
        if (facet != null) {
            RenderingUtilities.renderComponent(facet, context);
        } else {
            this.writeSpan(writer, masthead, textStyle, masthead.getServerInfo(), context, "_serverInfo");
        }
    }

    private void renderBrandImage(FacesContext context, Masthead masthead, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement("td", (UIComponent)masthead);
        writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_TD_LOGO"), null);
        writer.writeAttribute("width", (Object)"1%", null);
        writer.writeAttribute("align", (Object)"right", null);
        writer.writeAttribute("nowrap", (Object)"nowrap", "nowrap");
        UIComponent brandImage = this.getBrandImage(context, masthead, theme);
        if (brandImage == null) {
            this.appendDotImage(writer, context, masthead, "_logoSep", 37, 2, theme);
        } else {
            Object separatorFacet = masthead.getFacet("separatorImage");
            if (separatorFacet == null) {
                separatorFacet = ThemeUtilities.getIcon(theme, "MASTHEAD_JAVA_LOGO_SEPARATOR");
                separatorFacet.setId("_logoSep");
                separatorFacet.setParent((UIComponent)masthead);
            }
            RenderingUtilities.renderComponent(separatorFacet, context);
            this.appendDotImage(writer, context, masthead, "_logoPad", 1, 10, theme);
            RenderingUtilities.renderComponent(brandImage, context);
        }
        writer.endElement("td");
    }
}

