/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.io.PortMapperEntry;
import com.sun.messaging.jmq.io.PortMapperTable;
import com.sun.messaging.jmq.jmsclient.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;

public class GenericPortMapperClient {
    protected PortMapperTable portMapperTable = null;
    protected String host;
    protected int port;
    private boolean debug = Debug.debug;

    public GenericPortMapperClient(String host, int port) {
        this.host = host;
        this.port = port;
        this.init();
    }

    public int getPortForProtocol(String protocol, String type) {
        return this.getPort(protocol, type, null);
    }

    public int getPortForService(String protocol, String service, String type) {
        return this.getPort(protocol, type, service);
    }

    public String getProperty(String key, String protocol, String type, String servicename) {
        int port = 25374;
        String propVal = null;
        Map table = this.portMapperTable.getServices();
        PortMapperEntry pme2 = null;
        for (PortMapperEntry pme2 : table.values()) {
            if (protocol != null && !pme2.getProtocol().equals(protocol) || type != null && !pme2.getType().equals(type) || servicename != null && !pme2.getName().equals(servicename) || (propVal = pme2.getProperty(key)) == null) continue;
            break;
        }
        return propVal;
    }

    private int getPort(String protocol, String type, String servicename) {
        int port = 25374;
        Map table = this.portMapperTable.getServices();
        PortMapperEntry pme2 = null;
        for (PortMapperEntry pme2 : table.values()) {
            if (!pme2.getProtocol().equals(protocol) || !pme2.getType().equals(type)) continue;
            if (servicename == null) {
                port = pme2.getPort();
                break;
            }
            if (!pme2.getName().equals(servicename)) continue;
            port = pme2.getPort();
            break;
        }
        return port;
    }

    protected void init() {
        this.readBrokerPorts();
    }

    public String getPaketVersion() {
        return this.portMapperTable.getPacketVersion();
    }

    protected void readBrokerPorts() {
        if (this.debug) {
            Debug.println("PortMapper connecting to host: " + this.host + "  port: " + this.port);
        }
        try {
            String version = String.valueOf(101) + "\n";
            Socket socket = new Socket(this.host, this.port);
            InputStream is = socket.getInputStream();
            OutputStream os = socket.getOutputStream();
            try {
                os.write(version.getBytes());
                os.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.portMapperTable = new PortMapperTable();
            this.portMapperTable.read(is);
            is.close();
            socket.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception caught when reading portmapper.", e);
        }
    }

    public static void main(String[] args) {
        try {
            GenericPortMapperClient pmc = new GenericPortMapperClient("localhost", 7676);
            String url = pmc.getProperty("url", "rmi", "JMX", null);
            System.out.println("url = " + url);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }
}

