/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.log;

import com.sun.messaging.jmq.resources.SharedResources;
import com.sun.messaging.jmq.util.log.LogHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;

public class StreamLogHandler
extends LogHandler {
    private OutputStream os = null;

    @Override
    public void configure(Properties props, String prefix) throws IllegalArgumentException {
        String value = null;
        String property = null;
        String error_msg = null;
        long bytes = 0L;
        long secs = 0L;
        property = (prefix = prefix + ".") + "stream";
        value = props.getProperty(property);
        if (value != null) {
            if (value.equals("ERR")) {
                this.setLogStream(System.err);
            } else if (value.equals("OUT")) {
                this.setLogStream(System.out);
            } else {
                error_msg = rb.getString("S2002", property, value);
            }
        }
        if ((value = props.getProperty(property = prefix + "output")) != null) {
            try {
                this.setLevels(value);
            }
            catch (IllegalArgumentException e) {
                error_msg = (error_msg != null ? error_msg + SharedResources.NL : "") + property + ": " + e.getMessage();
            }
        }
        if (error_msg != null) {
            throw new IllegalArgumentException(error_msg);
        }
    }

    public void setLogStream(OutputStream os) {
        this.close();
        this.os = os;
    }

    @Override
    public void publish(int level, String message) throws IOException {
        if (level == 64 && !this.isAllowForceMessage()) {
            return;
        }
        if (this.os != null) {
            this.os.write(message.getBytes());
        }
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public void close() {
        if (this.os != null) {
            try {
                this.os.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void flush() {
        if (this.os != null) {
            try {
                this.os.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.os.toString();
    }
}

