/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.io.JMSPacket;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.util.io.FilteringObjectInputStream;
import com.sun.messaging.jms.ra.ConvertValue;
import com.sun.messaging.jms.ra.DirectPacket;
import com.sun.messaging.jms.ra.DirectSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;

public class DirectMapPacket
extends DirectPacket
implements MapMessage {
    private Map<String, Object> map = new HashMap<String, Object>();
    private byte[] messageBody = null;
    private ByteArrayOutputStream byteArrayOutputStream = null;
    private ObjectOutputStream objectOutputStream = null;
    private ByteArrayInputStream byteArrayInputStream = null;
    private ObjectInputStream objectInputStream = null;
    private static final transient String _className = "com.sun.messaging.jms.ra.DirectMapPacket";

    public DirectMapPacket(DirectSession ds) throws JMSException {
        super(ds);
        if (_logFINE) {
            Object[] params = new Object[2];
            params[0] = ds;
            _loggerOC.entering(_className, "constructor()", params);
        }
    }

    public DirectMapPacket(JMSPacket jmsPacket, long consumerId, DirectSession ds, JMSService jmsservice) throws JMSException {
        super(jmsPacket, consumerId, ds, jmsservice);
        this._getMessageBodyFromPacket();
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.map.clear();
    }

    public boolean getBoolean(String name) throws JMSException {
        return ConvertValue.toBoolean(this.map.get(name));
    }

    public byte getByte(String name) throws JMSException {
        return ConvertValue.toByte(this.map.get(name));
    }

    public byte[] getBytes(String name) throws JMSException {
        Object obj = this.map.get(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        String errMsg = "MQJMSRA_DM4001: :MapMessage:getBytes[]:Key=" + name + ":cannot be rea as a byte array.";
        _loggerJM.severe(errMsg);
        MessageFormatException mfe = new MessageFormatException(errMsg);
        throw mfe;
    }

    public char getChar(String name) throws JMSException {
        return ConvertValue.toChar(this.map.get(name));
    }

    public double getDouble(String name) throws JMSException {
        return ConvertValue.toDouble(this.map.get(name));
    }

    public float getFloat(String name) throws JMSException {
        return ConvertValue.toFloat(this.map.get(name));
    }

    public int getInt(String name) throws JMSException {
        return ConvertValue.toInt(this.map.get(name));
    }

    public long getLong(String name) throws JMSException {
        return ConvertValue.toLong(this.map.get(name));
    }

    public Enumeration getMapNames() throws JMSException {
        return Collections.enumeration(this.map.keySet());
    }

    public Object getObject(String name) throws JMSException {
        return this.map.get(name);
    }

    public short getShort(String name) throws JMSException {
        return ConvertValue.toShort(this.map.get(name));
    }

    public String getString(String name) throws JMSException {
        return ConvertValue.toString(this.map.get(name));
    }

    public boolean itemExists(String name) throws JMSException {
        return this.map.containsKey(name);
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        String methodName = "setBoolean()";
        this._checkValidKeyAndReadOnlyBody(methodName, name);
        this.map.put(name, value);
    }

    public void setByte(String name, byte value) throws JMSException {
        String methodName = "setByte()";
        this._checkValidKeyAndReadOnlyBody(methodName, name);
        this.map.put(name, value);
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        String methodName = "setBytes(byte[])";
        this._checkValidKeyAndReadOnlyBody(methodName, name);
        this.map.put(name, value);
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        String methodName = "setBytes(byte[], offset, length)";
        this._checkValidKeyAndReadOnlyBody(methodName, name);
        byte[] dest = new byte[length];
        System.arraycopy(value, offset, dest, 0, length);
        this.map.put(name, dest);
    }

    public void setChar(String name, char value) throws JMSException {
        String methodName = "setChar()";
        this._checkValidKeyAndReadOnlyBody(methodName, name);
        this.map.put(name, Character.valueOf(value));
    }

    public void setDouble(String name, double value) throws JMSException {
        String methodName = "setDouble()";
        this._checkValidKeyAndReadOnlyBody(methodName, name);
        this.map.put(name, value);
    }

    public void setFloat(String name, float value) throws JMSException {
        String methodName = "setFloat()";
        this._checkValidKeyAndReadOnlyBody(methodName, name);
        this.map.put(name, Float.valueOf(value));
    }

    public void setInt(String name, int value) throws JMSException {
        String methodName = "setInt()";
        this._checkValidKeyAndReadOnlyBody(methodName, name);
        this.map.put(name, value);
    }

    public void setLong(String name, long value) throws JMSException {
        String methodName = "setLong()";
        this._checkValidKeyAndReadOnlyBody(methodName, name);
        this.map.put(name, value);
    }

    public void setObject(String name, Object value) throws JMSException {
        String methodName = "setLong()";
        this._checkValidKeyAndReadOnlyBody(methodName, name);
        this._checkValidObjectType(value, name);
        this.map.put(name, value);
    }

    public void setShort(String name, short value) throws JMSException {
        String methodName = "setShort()";
        this._checkValidKeyAndReadOnlyBody(methodName, name);
        this.map.put(name, value);
    }

    public void setString(String name, String value) throws JMSException {
        String methodName = "setString()";
        this._checkValidKeyAndReadOnlyBody(methodName, name);
        this.map.put(name, value);
    }

    @Override
    protected void _setDefaultValues() throws JMSException {
        super._setDefaultValues();
        this.pkt.setPacketType(3);
    }

    @Override
    protected void _setBodyToPacket() throws JMSException {
        try {
            this.byteArrayOutputStream = new ByteArrayOutputStream();
            this.objectOutputStream = new ObjectOutputStream(this.byteArrayOutputStream);
            this.objectOutputStream.writeObject(this.map);
            this.objectOutputStream.flush();
            this.messageBody = this.byteArrayOutputStream.toByteArray();
            this.objectOutputStream.close();
            this.byteArrayOutputStream.close();
            super._setMessageBodyOfPacket(this.messageBody);
        }
        catch (Exception ex) {
            String errMsg = "MQJMSRA_DM4001: :MapMessage:Exception setting MapMessage body on send:" + ex.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)ex);
            throw jmse;
        }
    }

    @Override
    protected void _getMessageBodyFromPacket() throws JMSException {
        try {
            this.messageBody = super._getMessageBodyByteArray();
            this.byteArrayInputStream = new ByteArrayInputStream(this.messageBody);
            this.objectInputStream = new FilteringObjectInputStream(this.byteArrayInputStream);
            this.map = (Map)this.objectInputStream.readObject();
        }
        catch (Exception e) {
            String errMsg = "MQJMSRA_DM4001: :MapMessage:Exception deserializing on deliver:" + e.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
    }

    private void _checkValidKeyAndReadOnlyBody(String methodName, String key) throws IllegalArgumentException, JMSException {
        this.checkForReadOnlyMessageBody(methodName);
        if (key == null || "".equals(key)) {
            throw new IllegalArgumentException("MapMessage:" + methodName + ":name parameter is not allowed to be NULL or empty");
        }
    }

    private void _checkValidObjectType(Object value, String name) throws MessageFormatException {
        if (!(value != null && (value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String || value instanceof byte[]))) {
            String errMsg = "MQJMSRA_DM4001: :MapMessage:setObject():Invalid type:name=" + name + ":type=" + (value == null ? "NULL" : value.getClass().getName());
            _loggerJM.severe(errMsg);
            MessageFormatException mfe = new MessageFormatException(errMsg);
            throw mfe;
        }
    }
}

