/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.impl;

import com.sun.appserv.util.cache.Cache;
import com.sun.appserv.util.cache.CacheListener;
import com.sun.appserv.util.cache.LruCache;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperPersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.VersionConsistencyCache;
import com.sun.jdo.spi.persistence.utility.BucketizedHashtable;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;

public class VersionConsistencyCacheImpl
implements VersionConsistencyCache {
    private final Map pcTypeMap = new HashMap();
    private static CacheFactory cacheFactory;
    private static final ResourceBundle messages;
    private static Logger logger;
    private static final String LRU_CACHE_CLASSNAME = "com.sun.appserv.util.cache.LruCache";
    private static final String PROPERTY_PREFIX = "com.sun.jdo.spi.persistence.support.sqlstore.impl.VersionConsistency.";
    private static boolean lruCache;
    private static final String LRU_CACHE_PROPERTY = "com.sun.jdo.spi.persistence.support.sqlstore.impl.VersionConsistency.LruCache";
    private static float loadFactor;
    private static final String LOAD_FACTOR_PROPERTY = "com.sun.jdo.spi.persistence.support.sqlstore.impl.VersionConsistency.loadFactor";
    private static int bucketSize;
    private static final String BUCKET_SIZE_PROPERTY = "com.sun.jdo.spi.persistence.support.sqlstore.impl.VersionConsistency.bucketSize";
    private static int initialCapacity;
    private static final String INITIAL_CAPACITY_PROPERTY = "com.sun.jdo.spi.persistence.support.sqlstore.impl.VersionConsistency.initialCapacity";
    private static int maxEntries;
    private static final String MAX_ENTRIES_PROPERTY = "com.sun.jdo.spi.persistence.support.sqlstore.impl.VersionConsistency.maxEntries";
    private static long timeout;
    private static final String TIMEOUT_PROPERTY = "com.sun.jdo.spi.persistence.support.sqlstore.impl.VersionConsistency.timeout";

    private VersionConsistencyCacheImpl() {
    }

    protected VersionConsistencyCacheImpl(boolean highPerf) {
        cacheFactory = highPerf ? new LruCacheFactory() : new BasicCacheFactory();
    }

    static VersionConsistencyCache create() {
        return new VersionConsistencyCacheImpl();
    }

    static CacheFactory createCacheFactory() {
        CacheFactory rc = null;
        loadFactor = VersionConsistencyCacheImpl.getFloatValue(LOAD_FACTOR_PROPERTY, loadFactor);
        bucketSize = VersionConsistencyCacheImpl.getIntValue(BUCKET_SIZE_PROPERTY, bucketSize);
        initialCapacity = VersionConsistencyCacheImpl.getIntValue(INITIAL_CAPACITY_PROPERTY, initialCapacity);
        maxEntries = VersionConsistencyCacheImpl.getIntValue(MAX_ENTRIES_PROPERTY, maxEntries);
        timeout = VersionConsistencyCacheImpl.getLongValue(TIMEOUT_PROPERTY, timeout);
        boolean lruCache = false;
        try {
            String s = System.getProperty(LRU_CACHE_PROPERTY);
            if (s != null) {
                lruCache = Boolean.valueOf(s);
                if (lruCache) {
                    try {
                        Class.forName(LRU_CACHE_CLASSNAME);
                    }
                    catch (Exception ex) {
                        logger.warning(I18NHelper.getMessage(messages, "jdo.versionconsistencycacheimpl.lrucachenotfound"));
                        lruCache = false;
                    }
                }
            } else {
                try {
                    Class.forName(LRU_CACHE_CLASSNAME);
                    lruCache = true;
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception ex) {
            lruCache = false;
            logger.warning(I18NHelper.getMessage(messages, "jdo.versionconsistencycacheimpl.unexpectedduringcreate", ex));
        }
        rc = lruCache ? new LruCacheFactory() : new BasicCacheFactory();
        if (logger.isLoggable(400)) {
            String values = "\nloadFactor= " + loadFactor + "\nbucketSize= " + bucketSize + "\ninitialCapacity=" + initialCapacity + "\nmaxEntries=" + maxEntries + "\ntimeout=" + timeout + "\nlruCache=" + lruCache;
            logger.finer(I18NHelper.getMessage(messages, "jdo.versionconsistencycacheimpl.created", values));
        }
        return rc;
    }

    private static int getIntValue(String propName, int defaultVal) {
        int rc = defaultVal;
        String valString = System.getProperty(propName);
        if (null != valString && valString.length() > 0) {
            try {
                rc = Integer.parseInt(valString);
            }
            catch (NumberFormatException ex) {
                VersionConsistencyCacheImpl.logBadConfigValue(propName, valString);
            }
        }
        return rc;
    }

    private static float getFloatValue(String propName, float defaultVal) {
        float rc = defaultVal;
        String valString = System.getProperty(propName);
        if (null != valString && valString.length() > 0) {
            try {
                rc = Float.parseFloat(valString);
            }
            catch (NumberFormatException ex) {
                VersionConsistencyCacheImpl.logBadConfigValue(propName, valString);
            }
        }
        return rc;
    }

    private static long getLongValue(String propName, long defaultVal) {
        long rc = defaultVal;
        String valString = System.getProperty(propName);
        if (null != valString && valString.length() > 0) {
            try {
                rc = Long.parseLong(valString);
            }
            catch (NumberFormatException ex) {
                VersionConsistencyCacheImpl.logBadConfigValue(propName, valString);
            }
        }
        return rc;
    }

    private static void logBadConfigValue(String propName, String valString) {
        logger.warning(I18NHelper.getMessage(messages, "jdo.versionconsistencycacheimpl.badconfigvalue", propName, valString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateManager put(Class pcType, Object oid, StateManager sm) {
        boolean logAtFinest = logger.isLoggable(300);
        if (logAtFinest) {
            logger.finest(I18NHelper.getMessage(messages, "jdo.versionconsistencycacheimpl.put.entering", new Object[]{pcType, oid, sm}));
        }
        StateManager rc = null;
        VCCache oid2sm = null;
        Map map = this.pcTypeMap;
        synchronized (map) {
            oid2sm = (VCCache)this.pcTypeMap.get(pcType);
            if (null == oid2sm) {
                oid2sm = cacheFactory.create();
                this.pcTypeMap.put(pcType, oid2sm);
            }
        }
        rc = oid2sm.put(oid, sm);
        if (logAtFinest) {
            logger.finest(I18NHelper.getMessage(messages, "jdo.versionconsistencycacheimpl.put.returning", rc));
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateManager get(Class pcType, Object oid) {
        boolean logAtFinest = logger.isLoggable(300);
        if (logAtFinest) {
            logger.finest(I18NHelper.getMessage(messages, "jdo.versionconsistencycacheimpl.get.entering", new Object[]{pcType, oid}));
        }
        StateManager rc = null;
        VCCache oid2sm = null;
        Map map = this.pcTypeMap;
        synchronized (map) {
            oid2sm = (VCCache)this.pcTypeMap.get(pcType);
        }
        if (null != oid2sm) {
            rc = oid2sm.get(oid);
        }
        if (logAtFinest) {
            logger.finest(I18NHelper.getMessage(messages, "jdo.versionconsistencycacheimpl.get.returning", rc));
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateManager remove(Class pcType, Object oid) {
        boolean logAtFinest = logger.isLoggable(300);
        if (logAtFinest) {
            logger.finest(I18NHelper.getMessage(messages, "jdo.versionconsistencycacheimpl.remove.entering", new Object[]{pcType, oid}));
        }
        StateManager rc = null;
        Map map = this.pcTypeMap;
        synchronized (map) {
            VCCache oid2sm = (VCCache)this.pcTypeMap.get(pcType);
            if (null != oid2sm) {
                rc = oid2sm.remove(oid);
                if (oid2sm.isEmpty()) {
                    this.pcTypeMap.remove(pcType);
                }
            }
        }
        if (logAtFinest) {
            logger.finest(I18NHelper.getMessage(messages, "jdo.versionconsistencycacheimpl.remove.returning", rc));
        }
        return rc;
    }

    @Override
    public void addPCType(Class pcType) {
        if (logger.isLoggable(300)) {
            logger.finest(I18NHelper.getMessage(messages, "jdo.versionconsistencycacheimpl.addpctype", pcType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePCType(Class pcType) {
        if (logger.isLoggable(300)) {
            logger.finest(I18NHelper.getMessage(messages, "jdo.versionconsistencycacheimpl.removepctype", pcType));
        }
        Map map = this.pcTypeMap;
        synchronized (map) {
            VCCache oid2sm = (VCCache)this.pcTypeMap.get(pcType);
            if (null != oid2sm) {
                oid2sm.clear();
            }
            this.pcTypeMap.remove(pcType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int rc = 0;
        Map map = this.pcTypeMap;
        synchronized (map) {
            Iterator i = this.pcTypeMap.keySet().iterator();
            while (i.hasNext()) {
                VCCache oid2sm = (VCCache)this.pcTypeMap.get(i.next());
                rc += oid2sm.size();
            }
        }
        return rc;
    }

    public boolean isHighPerf() {
        return LruCacheFactory.class.equals(cacheFactory.getClass());
    }

    static {
        messages = I18NHelper.loadBundle(VersionConsistencyCacheImpl.class);
        logger = LogHelperPersistenceManager.getLogger();
        lruCache = false;
        loadFactor = 0.75f;
        bucketSize = 13;
        initialCapacity = 131;
        maxEntries = 131;
        timeout = 600000L;
        cacheFactory = VersionConsistencyCacheImpl.createCacheFactory();
    }

    static class LruCacheFactory
    implements CacheFactory {
        LruCacheFactory() {
        }

        @Override
        public VCCache create() {
            return new LruVCCache(maxEntries, timeout, loadFactor);
        }
    }

    static class BasicCacheFactory
    implements CacheFactory {
        BasicCacheFactory() {
        }

        @Override
        public VCCache create() {
            return new BasicVCCache();
        }
    }

    static interface CacheFactory {
        public VCCache create();
    }

    static class LruVCCache
    implements VCCache {
        private final Cache cache;

        LruVCCache(int maxEntries, long timeout, float loadFactor) {
            if (logger.isLoggable(400)) {
                logger.finer(I18NHelper.getMessage(messages, "jdo.versionconsistencycacheimpl.usinglrucache", new Object[]{new Integer(maxEntries), new Long(timeout), new Float(loadFactor)}));
            }
            LruCache c = new LruCache();
            c.init(maxEntries, timeout, loadFactor, (Properties)null);
            c.addCacheListener(new CacheListener(){

                public void trimEvent(Object key, Object value) {
                    cache.remove(key);
                    if (logger.isLoggable(400)) {
                        logger.finer(I18NHelper.getMessage(messages, "jdo.versionconsistencycacheimpl.trimevent"));
                    }
                }
            });
            this.cache = c;
        }

        @Override
        public StateManager put(Object key, StateManager value) {
            return (StateManager)this.cache.put(key, (Object)value);
        }

        @Override
        public StateManager get(Object key) {
            return (StateManager)this.cache.get(key);
        }

        @Override
        public StateManager remove(Object key) {
            return (StateManager)this.cache.remove(key);
        }

        @Override
        public void clear() {
            this.cache.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.cache.isEmpty();
        }

        @Override
        public int size() {
            return this.cache.getEntryCount();
        }
    }

    static class BasicVCCache
    implements VCCache {
        private final Map cache;

        BasicVCCache() {
            if (logger.isLoggable(400)) {
                logger.finer(I18NHelper.getMessage(messages, "jdo.versionconsistencycacheimpl.usinghashmap", new Object[]{new Integer(bucketSize), new Long(initialCapacity), new Float(loadFactor)}));
            }
            this.cache = Collections.synchronizedMap(new BucketizedHashtable(bucketSize, initialCapacity, loadFactor));
        }

        @Override
        public StateManager put(Object key, StateManager value) {
            return this.cache.put(key, value);
        }

        @Override
        public StateManager get(Object key) {
            return (StateManager)this.cache.get(key);
        }

        @Override
        public StateManager remove(Object key) {
            return (StateManager)this.cache.remove(key);
        }

        @Override
        public void clear() {
            this.cache.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.cache.isEmpty();
        }

        @Override
        public int size() {
            return this.cache.size();
        }
    }

    static interface VCCache {
        public StateManager put(Object var1, StateManager var2);

        public StateManager get(Object var1);

        public StateManager remove(Object var1);

        public void clear();

        public boolean isEmpty();

        public int size();
    }
}

