/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.manager.ha;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ha.HAClusterManagerImpl;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ha.HAClusteredBrokerImpl;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ha.SFSHABrokerInfoMap;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ha.SFSHAClusteredBrokerImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.MigratableStoreUtil;
import com.sun.messaging.jmq.jmsserver.persist.api.StoreManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import java.util.Map;
import javax.inject.Singleton;
import org.jvnet.hk2.annotations.Service;

@Service(name="com.sun.messaging.jmq.jmsserver.cluster.manager.ha.SFSHAClusterManagerImpl")
@Singleton
public class SFSHAClusterManagerImpl
extends HAClusterManagerImpl {
    @Override
    public String initialize(MQAddress address) throws BrokerException {
        Globals.getStore().updateBrokerInfo(Globals.getBrokerID(), 1, null, address.toString());
        String bid = super.initialize(address);
        UID ss = Globals.getStoreSession();
        ((SFSHAClusteredBrokerImpl)this.getLocalBroker()).setStoreSessionUID(ss);
        return bid;
    }

    @Override
    protected void checkStore() throws BrokerException {
        if (!StoreManager.isConfiguredBDBSharedFS()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3221"));
        }
    }

    @Override
    protected HAClusteredBroker newHAClusteredBroker(String brokerid, MQAddress url, int version, BrokerState state, UID session) throws BrokerException {
        return new SFSHAClusteredBrokerImpl(brokerid, url, version, state, session, this);
    }

    @Override
    protected ClusteredBroker updateBrokerOnActivation(ClusteredBroker broker, Object userData) {
        ((SFSHAClusteredBrokerImpl)broker).setStoreSessionUID(((BrokerInfo)userData).getBrokerAddr().getStoreSessionUID());
        ((SFSHAClusteredBrokerImpl)broker).setRemoteBrokerStateOnActivation();
        return broker;
    }

    @Override
    protected ClusteredBroker updateBrokerOnDeactivation(ClusteredBroker broker, Object userData) {
        ((SFSHAClusteredBrokerImpl)broker).setRemoteBrokerStateOnDeactivation();
        return broker;
    }

    @Override
    public String lookupStoreSessionOwner(UID uid) {
        try {
            if (Globals.getMyAddress().getStoreSessionUID().equals(uid)) {
                return Globals.getBrokerID();
            }
            if (Globals.getStore().ifOwnStoreSession(uid.longValue(), null)) {
                return Globals.getBrokerID();
            }
            return Globals.getClusterBroadcast().lookupStoreSessionOwner(uid);
        }
        catch (Exception ex) {
            this.logger.logStack(16, ex.getMessage(), ex);
            return null;
        }
    }

    @Override
    protected Map newHABrokerInfoMap() throws BrokerException {
        return new SFSHABrokerInfoMap(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClusteredBroker getBrokerByNodeName(String nodeName) throws BrokerException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        HAClusteredBrokerImpl cb2 = null;
        Map map = this.allBrokers;
        synchronized (map) {
            for (HAClusteredBrokerImpl cb2 : this.allBrokers.values()) {
                String instn = cb2.getInstanceName();
                UID ss = cb2.getStoreSessionUID();
                if (instn == null || ss == null || !MigratableStoreUtil.makeEffectiveBrokerID(instn, ss).equals(nodeName)) continue;
                return cb2;
            }
        }
        return null;
    }
}

