/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.common.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Hashtable;

public class ClientIDHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;

    @Override
    public boolean handle(IMQConnection con, Packet msg) throws BrokerException {
        Hashtable<String, Object> hash;
        Packet pkt;
        block14: {
            block13: {
                Hashtable props;
                String reason;
                int status;
                block12: {
                    pkt = new Packet(con.useDirectBuffers());
                    pkt.setConsumerID(msg.getConsumerID());
                    pkt.setPacketType(51);
                    hash = new Hashtable<String, Object>();
                    status = 200;
                    reason = null;
                    props = null;
                    try {
                        props = msg.getProperties();
                    }
                    catch (Exception ex) {
                        this.logger.logStack(16, "SET-CLIENTID Packet.getProperties()", ex);
                        if ($assertionsDisabled) break block12;
                        throw new AssertionError();
                    }
                }
                String cclientid = null;
                boolean shared = false;
                String namespace = null;
                if (props != null) {
                    cclientid = (String)props.get("JMQClientID");
                    namespace = (String)props.get("JMQNamespace");
                    Boolean shareProp = (Boolean)props.get("JMQShare");
                    shared = shareProp == null ? namespace != null : shareProp;
                } else assert (false);
                this.logger.log(4, "ClientID[" + namespace + "," + cclientid + "," + shared + "] ");
                if (DEBUG) {
                    this.logger.log(4, "ClientIDHandler: registering clientID " + cclientid);
                }
                try {
                    status = 200;
                    reason = null;
                    this.setClientID(con, cclientid, namespace, shared);
                }
                catch (BrokerException ex) {
                    status = ex.getStatusCode();
                    reason = ex.getMessage();
                }
                hash.put("JMQStatus", status);
                if (reason != null) {
                    hash.put("JMQReason", reason);
                }
                IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)con;
                if (IMQBasicConnection.getDumpPacket()) break block13;
                IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)con;
                if (!IMQBasicConnection.getDumpOutPacket()) break block14;
            }
            hash.put("JMQReqID", msg.getSysMessageID().toString());
        }
        pkt.setProperties(hash);
        con.sendControlMessage(pkt);
        return true;
    }

    private String validate(String clientid, Connection con) throws BrokerException {
        String cid = clientid;
        if (clientid != null) {
            if (clientid.startsWith("${u}")) {
                AccessController ac = con.getAccessController();
                String user = ac.getAuthenticatedName().getName();
                cid = "${u:" + user + "}" + clientid.substring(4);
            } else if (clientid.startsWith("${u:")) {
                cid = null;
            } else if (clientid.indexOf("${%%}") != -1) {
                this.logger.log(4, "bad client id ${%%}");
                cid = null;
            }
        }
        if (cid == null || cid.trim().length() == 0) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4109", clientid == null ? "null" : clientid));
        }
        if (DEBUG) {
            this.logger.log(4, "ClientIDHandler:validated client ID:" + cid + ":");
        }
        return cid;
    }

    public void setClientID(IMQConnection con, String cclientid, String namespace, boolean shared) throws BrokerException {
        int status = 200;
        String reason = null;
        try {
            String clientid = cclientid == null ? null : this.validate(cclientid, con);
            String oldid = (String)con.getClientData("client id");
            if (DEBUG && oldid != null) {
                this.logger.log(4, "ClientIDHandler: replacing clientID " + oldid + " with " + clientid);
            }
            if (!(clientid == null || oldid != null && oldid.equals(clientid))) {
                int lockstatus;
                if (namespace != null) {
                    String unspace = namespace + "${%%}" + clientid;
                    int lockstatus2 = Globals.getClusterBroadcast().lockClientID(unspace, con.getConnectionUID(), false);
                    if (lockstatus2 != 0) {
                        if (lockstatus2 == -1) {
                            String emsg = Globals.getBrokerResources().getKString("B4457", unspace, con.getRemoteConnectionString());
                            this.logger.log(8, emsg);
                            status = 408;
                            throw new BrokerException(emsg, status);
                        }
                        this.logger.log(8, "B1033", (Object)con.getRemoteConnectionString(), unspace);
                        Connection owner = Globals.getConnectionManager().matchProperty("client id", unspace);
                        assert (owner == null || owner instanceof IMQConnection);
                        if (owner == null) {
                            this.logger.log(8, "B1135", unspace);
                        } else {
                            this.logger.log(8, "B1134", (Object)unspace, ((IMQConnection)owner).getRemoteConnectionString());
                        }
                        reason = "conflict w/ clientID";
                        status = 409;
                        throw new BrokerException(reason, status);
                    }
                }
                if ((lockstatus = Globals.getClusterBroadcast().lockClientID(clientid, con.getConnectionUID(), shared)) != 0) {
                    if (lockstatus == -1) {
                        String emsg = Globals.getBrokerResources().getKString("B4457", clientid, con.getRemoteConnectionString());
                        this.logger.log(8, emsg);
                        status = 408;
                        throw new BrokerException(emsg, status);
                    }
                    this.logger.log(8, "B1033", (Object)con.getRemoteConnectionString(), clientid);
                    Connection owner = Globals.getConnectionManager().matchProperty("client id", clientid);
                    assert (owner == null || owner instanceof IMQConnection);
                    if (owner == null) {
                        this.logger.log(8, "B1135", clientid);
                    } else {
                        this.logger.log(8, "B1134", (Object)clientid, ((IMQConnection)owner).getRemoteConnectionString());
                    }
                    reason = "conflict w/ clientID";
                    status = 409;
                    throw new BrokerException(reason, status);
                }
            } else if (oldid != null && !oldid.equals(clientid)) {
                String oldunspace = namespace + "${%%}" + oldid;
                this.logger.log(4, "ClientIDHandler: removing old namespace/clientID " + oldunspace);
                Globals.getClusterBroadcast().unlockClientID(oldunspace, con.getConnectionUID());
                this.logger.log(4, "ClientIDHandler: removing old clientID " + oldid);
                Globals.getClusterBroadcast().unlockClientID(oldid, con.getConnectionUID());
                con.removeClientData("client id");
            }
            if (clientid != null && status != 409) {
                con.addClientData("client id", clientid);
            }
        }
        catch (BrokerException ex) {
            if (ex.getStatusCode() == 409) {
                throw ex;
            }
            if (ex.getStatusCode() == 408) {
                throw ex;
            }
            this.logger.log(16, "B2024", cclientid, con.toString(), ex);
            status = 400;
            reason = ex.getMessage();
            throw new BrokerException(reason, ex, status);
        }
        catch (OutOfMemoryError err) {
            throw err;
        }
        catch (Throwable thr) {
            this.logger.log(16, "unexpected error processing clientid ", thr);
            reason = thr.getMessage();
            status = 500;
            throw new BrokerException(reason, thr, status);
        }
    }
}

