/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.support;

import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.api.persistence.support.PersistenceManager;
import com.sun.jdo.api.persistence.support.Transaction;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.Synchronization;

public class SynchronizationManager
implements Synchronization {
    protected static int defaultCapacity = 100;
    protected final List synchronizations;

    public SynchronizationManager(int initialCapacity) {
        this.synchronizations = new ArrayList(initialCapacity);
    }

    public SynchronizationManager() {
        this(defaultCapacity);
    }

    public static void registerSynchronization(Synchronization instance, PersistenceManager pm) {
        SynchronizationManager synchronizationManager = SynchronizationManager.getSynchronizationManager(pm);
        synchronizationManager.registerSynchronization(instance);
    }

    public static void setDefaultCapacity(int capacity) {
        defaultCapacity = capacity;
    }

    protected SynchronizationManager(PersistenceManager pm) {
        this();
        Transaction tx = pm.currentTransaction();
        tx.setSynchronization(this);
    }

    protected static SynchronizationManager getSynchronizationManager(PersistenceManager pm) {
        Transaction tx = pm.currentTransaction();
        Synchronization oldsync = tx.getSynchronization();
        if (oldsync instanceof SynchronizationManager) {
            return (SynchronizationManager)oldsync;
        }
        SynchronizationManager newsync = new SynchronizationManager(pm);
        if (oldsync != null) {
            newsync.registerSynchronization(oldsync);
        }
        return newsync;
    }

    @Override
    public void beforeCompletion() {
        int size = this.synchronizations.size();
        for (int i = 0; i < size; ++i) {
            Synchronization instance = (Synchronization)this.synchronizations.get(i);
            instance.beforeCompletion();
        }
    }

    @Override
    public void afterCompletion(int status) {
        int size = this.synchronizations.size();
        StringBuffer sb = null;
        for (int i = 0; i < size; ++i) {
            Synchronization instance = (Synchronization)this.synchronizations.get(i);
            try {
                instance.afterCompletion(status);
                continue;
            }
            catch (Exception e) {
                if (sb == null) {
                    sb = new StringBuffer();
                }
                sb.append(e.getMessage()).append('\n');
            }
        }
        this.synchronizations.clear();
        if (sb != null) {
            throw new JDOUserException(sb.toString());
        }
    }

    protected void registerSynchronization(Synchronization instance) {
        this.synchronizations.add(instance);
    }
}

