/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.appclient.server.core.AppClientDeployerHelper;
import org.glassfish.appclient.server.core.ApplicationSignedJARManager;
import org.glassfish.appclient.server.core.NestedAppClientDeployerHelper;
import org.glassfish.appclient.server.core.StandaloneAppClientDeployerHelper;
import org.glassfish.appclient.server.core.jws.DeveloperContentHandler;
import org.glassfish.appclient.server.core.jws.JavaWebStartInfo;
import org.glassfish.appclient.server.core.jws.servedcontent.Content;
import org.glassfish.appclient.server.core.jws.servedcontent.DynamicContent;
import org.glassfish.appclient.server.core.jws.servedcontent.SimpleDynamicContentImpl;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;
import org.glassfish.logging.annotation.LogMessageInfo;

abstract class XPathToDeveloperProvidedContentRefs<T extends Content> {
    private static final String STATIC_REFS_PROPERTY_NAME = "static.refs";
    private static final String DYNAMIC_REFS_PROPERTY_NAME = "dynamic.refs";
    private static final XPathFactory xPathFactory = XPathFactory.newInstance();
    private static final XPath xPath = xPathFactory.newXPath();
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.container.appclient", "org.glassfish.appclient.server.LogMessages");
    @LogMessageInfo(message="Client JNLP document {0} refers to the static resource {1} that does not exist or is not readable.", cause="The developer-provided JNLP content refers to a file as if the file is in the application but the server could not find the file.", action="Make sure the file is packaged in the application and that the reference to the file is correct.  Then rebuild and redeploy the application.")
    public static final String BAD_STATIC_CONTENT = "AS-ACDEPL-00111";
    @LogMessageInfo(message="The ApplicationSignedJARManager for a nested app client deployer helper is unexpectedly null.", cause="During deployment of nested app clients (those inside EARs), the system should use an ApplicationSignedJARManager but it is null.", action="This is a system error.  Please report this as a bug.")
    public static final String SIGNED_JAR_MGR_NULL = "AS-ACDEPL-00114";
    @LogMessageInfo(message="Tbe custom JNLP document {0} in a stand-alone app client incorrectly refers to a JAR {1}", cause="The app client includes a custom JNLP document which refers to a JAR.  Stand-alone app clients cannot refer to other JARs because they are self-contained deployment units.", action="Remove references to JAR from the custom JNLP document or package the app client inside an EAR that also contains the referenced JAR.")
    public static final String USER_REFERENCED_JAR = "AS-ACDEPL-00115";
    private final XPathExpression xPathExpr;

    private XPathToDeveloperProvidedContentRefs(String path) {
        try {
            this.xPathExpr = xPath.compile(path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static List<XPathToDeveloperProvidedContentRefs> parse(Properties p) {
        ArrayList<XPathToDeveloperProvidedContentRefs> result = new ArrayList<XPathToDeveloperProvidedContentRefs>();
        result.addAll(XPathToDeveloperProvidedContentRefs.parse(p, Type.STATIC));
        result.addAll(XPathToDeveloperProvidedContentRefs.parse(p, Type.DYNAMIC));
        return result;
    }

    private static List<XPathToDeveloperProvidedContentRefs> parse(Properties p, Type type) {
        ArrayList<XPathToDeveloperProvidedContentRefs> result = new ArrayList<XPathToDeveloperProvidedContentRefs>();
        String refs = p.getProperty(type.propertyName);
        for (String ref : refs.split(",")) {
            result.add(type == Type.STATIC ? new XPathToStaticContent(ref) : new XPathToDynamicContent(ref));
        }
        return result;
    }

    XPathExpression xPathExpr() {
        return this.xPathExpr;
    }

    abstract void addToContentIfInApp(DeveloperContentHandler var1, AppClientDeployerHelper var2, String var3, URI var4, String var5, ClassLoader var6, Map<String, StaticContent> var7, Map<String, DynamicContent> var8, URI var9, ReadableArchive var10) throws URISyntaxException, IOException;

    private static class XPathToDynamicContent
    extends XPathToDeveloperProvidedContentRefs<DynamicContent> {
        XPathToDynamicContent(String path) {
            super(path);
        }

        @Override
        void addToContentIfInApp(DeveloperContentHandler dch, AppClientDeployerHelper helper, String referringDocument, URI codebase, String pathToContent, ClassLoader loader, Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent, URI appRootURI, ReadableArchive appClientArchive) throws URISyntaxException, IOException {
            URI uriToContent = new URI(pathToContent);
            URI absURI = codebase.resolve(uriToContent);
            if (absURI.equals(uriToContent)) {
                return;
            }
            String combinedContent = dch.combineJNLP(JavaWebStartInfo.textFromURL("/org/glassfish/appclient/server/core/jws/templates/developerProvidedDocumentTemplate.jnlp"), pathToContent);
            dynamicContent.put(pathToContent, new SimpleDynamicContentImpl(combinedContent, URLConnection.guessContentTypeFromName(pathToContent)));
            dch.addDeveloperContent(pathToContent, combinedContent);
        }
    }

    private static class XPathToStaticContent
    extends XPathToDeveloperProvidedContentRefs<StaticContent> {
        XPathToStaticContent(String path) {
            super(path);
        }

        @Override
        void addToContentIfInApp(DeveloperContentHandler dch, AppClientDeployerHelper helper, String referringDocument, URI codebase, String pathToContent, ClassLoader loader, Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent, URI appRootURI, ReadableArchive appClientArchive) throws URISyntaxException {
            URI uriToContent = new URI(pathToContent);
            URI absURI = codebase.resolve(uriToContent);
            if (absURI.equals(uriToContent)) {
                return;
            }
            URI fileURI = appRootURI.resolve(pathToContent);
            File f = new File(fileURI);
            if (!f.exists() || !f.canRead()) {
                logger.log(Level.WARNING, XPathToDeveloperProvidedContentRefs.BAD_STATIC_CONTENT, new Object[]{referringDocument, pathToContent});
            } else {
                ApplicationSignedJARManager signedJARManager = helper.signedJARManager();
                if (signedJARManager == null && helper instanceof NestedAppClientDeployerHelper) {
                    logger.log(Level.SEVERE, XPathToDeveloperProvidedContentRefs.SIGNED_JAR_MGR_NULL);
                } else if (helper instanceof StandaloneAppClientDeployerHelper) {
                    logger.log(Level.WARNING, XPathToDeveloperProvidedContentRefs.USER_REFERENCED_JAR, new Object[]{referringDocument, pathToContent});
                } else {
                    try {
                        URI signedURI = signedJARManager.addJAR(fileURI);
                        staticContent.put(pathToContent, signedJARManager.staticContent(signedURI));
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    private static enum Type {
        STATIC("static.refs"),
        DYNAMIC("dynamic.refs");

        private String propertyName;

        private Type(String propName) {
            this.propertyName = propName;
        }
    }
}

