/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.ExecutionContext;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandContextForInstance;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandModelProvider;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Progress;
import org.glassfish.api.admin.ProgressStatus;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.api.admin.SupplementalCommandExecutor;
import org.glassfish.common.util.admin.CommandModelImpl;
import org.glassfish.common.util.admin.MapInjectionResolver;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.config.InjectionManager;
import org.jvnet.hk2.config.InjectionResolver;

@Service(name="SupplementalCommandExecutorImpl")
public class SupplementalCommandExecutorImpl
implements SupplementalCommandExecutor {
    @Inject
    private ServiceLocator habitat;
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    private ServerContext sc;
    private static final Logger logger = KernelLoggerInfo.getLogger();
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(SupplementalCommandExecutor.class);
    private Map<String, List<ServiceHandle<?>>> supplementalCommandsMap = null;

    @Override
    public Collection<SupplementalCommandExecutor.SupplementalCommand> listSuplementalCommands(String commandName) {
        List<ServiceHandle<?>> supplementalList = this.getSupplementalCommandsList().get(commandName);
        if (supplementalList == null) {
            return Collections.emptyList();
        }
        ArrayList<SupplementalCommandExecutor.SupplementalCommand> result = new ArrayList<SupplementalCommandExecutor.SupplementalCommand>(supplementalList.size());
        for (ServiceHandle<?> handle : supplementalList) {
            AdminCommand cmdObject = (AdminCommand)handle.getService();
            SupplementalCommandImpl aCmd = new SupplementalCommandImpl(cmdObject);
            if ((!this.serverEnv.isDas() || !aCmd.whereToRun().contains((Object)RuntimeType.DAS)) && (!this.serverEnv.isInstance() || !aCmd.whereToRun().contains((Object)RuntimeType.INSTANCE))) continue;
            result.add(aCmd);
        }
        return result;
    }

    @Override
    public ActionReport.ExitCode execute(Collection<SupplementalCommandExecutor.SupplementalCommand> suplementals, Supplemental.Timing time, AdminCommandContext context, ParameterMap parameters, MultiMap<String, File> optionFileMap) {
        ActionReport.ExitCode finalResult = ActionReport.ExitCode.SUCCESS;
        if (suplementals == null) {
            return finalResult;
        }
        for (SupplementalCommandExecutor.SupplementalCommand aCmd : suplementals) {
            if (!(time.equals((Object)Supplemental.Timing.Before) && aCmd.toBeExecutedBefore() || time.equals((Object)Supplemental.Timing.After) && aCmd.toBeExecutedAfter()) && (!time.equals((Object)Supplemental.Timing.AfterReplication) || !aCmd.toBeExecutedAfterReplication())) continue;
            ActionReport.ExitCode result = FailurePolicy.applyFailurePolicy(aCmd.onFailure(), this.inject(aCmd, this.getInjector(aCmd.getCommand(), parameters, optionFileMap, context), context.getActionReport()));
            if (!result.equals((Object)ActionReport.ExitCode.SUCCESS)) {
                if (!finalResult.equals((Object)ActionReport.ExitCode.SUCCESS)) continue;
                finalResult = result;
                continue;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(strings.getLocalString("dynamicreconfiguration.diagnostics.supplementalexec", "Executing supplemental command " + aCmd.getClass().getCanonicalName()));
            }
            aCmd.execute(context);
            if (context.getActionReport().hasFailures()) {
                result = FailurePolicy.applyFailurePolicy(aCmd.onFailure(), ActionReport.ExitCode.FAILURE);
            } else if (context.getActionReport().hasWarnings()) {
                result = FailurePolicy.applyFailurePolicy(aCmd.onFailure(), ActionReport.ExitCode.WARNING);
            }
            if (result.equals((Object)ActionReport.ExitCode.SUCCESS) || !finalResult.equals((Object)ActionReport.ExitCode.SUCCESS)) continue;
            finalResult = result;
        }
        return finalResult;
    }

    private static String getOne(String key, Map<String, List<String>> metadata) {
        if (key == null || metadata == null) {
            return null;
        }
        List<String> found = metadata.get(key);
        if (found == null) {
            return null;
        }
        if (found.isEmpty()) {
            return null;
        }
        return found.get(0);
    }

    private synchronized Map<String, List<ServiceHandle<?>>> getSupplementalCommandsList() {
        if (this.supplementalCommandsMap != null) {
            return this.supplementalCommandsMap;
        }
        this.supplementalCommandsMap = new ConcurrentHashMap();
        List supplementals = this.habitat.getAllServiceHandles(Supplemental.class, new Annotation[0]);
        for (ServiceHandle handle : supplementals) {
            ActiveDescriptor inh = handle.getActiveDescriptor();
            String commandName = SupplementalCommandExecutorImpl.getOne("target", inh.getMetadata());
            if (this.supplementalCommandsMap.containsKey(commandName)) {
                this.supplementalCommandsMap.get(commandName).add(handle);
                continue;
            }
            ArrayList<ServiceHandle> inhList = new ArrayList<ServiceHandle>();
            inhList.add(handle);
            this.supplementalCommandsMap.put(commandName, inhList);
        }
        return this.supplementalCommandsMap;
    }

    private InjectionResolver<Param> getInjector(AdminCommand command, ParameterMap parameters, MultiMap<String, File> map, AdminCommandContext context) {
        Object model = command instanceof CommandModelProvider ? ((CommandModelProvider)((Object)command)).getModel() : new CommandModelImpl(command.getClass());
        MapInjectionResolver injector = new MapInjectionResolver((CommandModel)model, parameters, map);
        injector.setContext((ExecutionContext)context);
        return injector;
    }

    private ActionReport.ExitCode inject(SupplementalCommandExecutor.SupplementalCommand cmd, InjectionResolver<Param> injector, ActionReport subActionReport) {
        ActionReport.ExitCode result = ActionReport.ExitCode.SUCCESS;
        try {
            new InjectionManager().inject((Object)cmd.getCommand(), injector);
        }
        catch (Exception e) {
            result = ActionReport.ExitCode.FAILURE;
            subActionReport.setActionExitCode(result);
            subActionReport.setMessage(e.getMessage());
            subActionReport.setFailureCause(e);
        }
        return result;
    }

    public class SupplementalCommandImpl
    implements SupplementalCommandExecutor.SupplementalCommand {
        private AdminCommand command;
        private Supplemental.Timing timing;
        private FailurePolicy failurePolicy;
        private List<RuntimeType> whereToRun = new ArrayList<RuntimeType>(2);
        private ProgressStatus progressStatus;
        private Progress progressAnnotation;

        private SupplementalCommandImpl(AdminCommand cmd) {
            this.command = cmd;
            Supplemental supAnn = cmd.getClass().getAnnotation(Supplemental.class);
            this.timing = supAnn.on();
            this.failurePolicy = supAnn.ifFailure();
            ExecuteOn onAnn = cmd.getClass().getAnnotation(ExecuteOn.class);
            this.progressAnnotation = cmd.getClass().getAnnotation(Progress.class);
            if (onAnn == null) {
                this.whereToRun.add(RuntimeType.DAS);
                this.whereToRun.add(RuntimeType.INSTANCE);
            } else if (onAnn.value().length == 0) {
                this.whereToRun.add(RuntimeType.DAS);
                this.whereToRun.add(RuntimeType.INSTANCE);
            } else {
                this.whereToRun.addAll(Arrays.asList(onAnn.value()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(AdminCommandContext ctxt) {
            Thread thread = Thread.currentThread();
            ClassLoader origCL = thread.getContextClassLoader();
            ClassLoader ccl = SupplementalCommandExecutorImpl.this.sc.getCommonClassLoader();
            if (this.progressStatus != null) {
                ctxt = new AdminCommandContextForInstance(ctxt, this.progressStatus);
            }
            if (origCL != ccl) {
                try {
                    thread.setContextClassLoader(ccl);
                    if (this.command instanceof AdminCommandSecurity.Preauthorization) {
                        ((AdminCommandSecurity.Preauthorization)((Object)this.command)).preAuthorization(ctxt);
                    }
                    this.command.execute(ctxt);
                }
                finally {
                    thread.setContextClassLoader(origCL);
                }
            } else {
                if (this.command instanceof AdminCommandSecurity.Preauthorization) {
                    ((AdminCommandSecurity.Preauthorization)((Object)this.command)).preAuthorization(ctxt);
                }
                this.command.execute(ctxt);
            }
        }

        @Override
        public AdminCommand getCommand() {
            return this.command;
        }

        @Override
        public boolean toBeExecutedBefore() {
            return this.timing.equals((Object)Supplemental.Timing.Before);
        }

        @Override
        public boolean toBeExecutedAfter() {
            return this.timing.equals((Object)Supplemental.Timing.After);
        }

        @Override
        public boolean toBeExecutedAfterReplication() {
            return this.timing.equals((Object)Supplemental.Timing.AfterReplication);
        }

        @Override
        public FailurePolicy onFailure() {
            return this.failurePolicy;
        }

        @Override
        public List<RuntimeType> whereToRun() {
            return this.whereToRun;
        }

        @Override
        public ProgressStatus getProgressStatus() {
            return this.progressStatus;
        }

        @Override
        public void setProgressStatus(ProgressStatus progressStatus) {
            this.progressStatus = progressStatus;
        }

        @Override
        public Progress getProgressAnnotation() {
            return this.progressAnnotation;
        }
    }
}

