/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.BytesMessageImpl;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MapMessageImpl;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.ObjectMessageImpl;
import com.sun.messaging.jmq.jmsclient.StreamMessageImpl;
import com.sun.messaging.jmq.jmsclient.TextMessageImpl;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public class MessageConvert {
    protected static final MessageConvert messageConvert = new MessageConvert();

    public static synchronized MessageConvert getInstance() {
        return messageConvert;
    }

    protected Message convertJMSMessage(Message foreignMessage) throws JMSException {
        Message message = null;
        message = foreignMessage instanceof TextMessage ? this.convertTextMessage((TextMessage)foreignMessage) : (foreignMessage instanceof MapMessage ? this.convertMapMessage((MapMessage)foreignMessage) : (foreignMessage instanceof BytesMessage ? this.convertBytesMessage((BytesMessage)foreignMessage) : (foreignMessage instanceof ObjectMessage ? this.convertObjectMessage((ObjectMessage)foreignMessage) : (foreignMessage instanceof StreamMessage ? this.convertStreamMessage((StreamMessage)foreignMessage) : new MessageImpl()))));
        this.convertJMSHeader(message, foreignMessage);
        this.convertJMSProperties(message, foreignMessage);
        return message;
    }

    protected void convertJMSHeader(Message message, Message foreignMessage) throws JMSException {
        message.setJMSCorrelationID(foreignMessage.getJMSCorrelationID());
        message.setJMSType(message.getJMSType());
    }

    protected void resetForeignMessageHeader(Message message, Message foreignMessage) throws JMSException {
        foreignMessage.setJMSDeliveryMode(message.getJMSDeliveryMode());
        foreignMessage.setJMSExpiration(message.getJMSExpiration());
        Method m = null;
        try {
            Class<?> c = foreignMessage.getClass();
            m = c.getMethod("getJMSDeliveryTime", null);
            if (Modifier.isAbstract(m.getModifiers())) {
                m = null;
            }
        }
        catch (NoSuchMethodException e) {
            m = null;
        }
        if (m != null && message.getJMSDeliveryTime() != 0L) {
            foreignMessage.setJMSDeliveryTime(message.getJMSDeliveryTime());
        }
        foreignMessage.setJMSMessageID(message.getJMSMessageID());
        foreignMessage.setJMSPriority(message.getJMSPriority());
        foreignMessage.setJMSTimestamp(message.getJMSTimestamp());
        foreignMessage.setJMSDestination(message.getJMSDestination());
    }

    protected void convertJMSProperties(Message message, Message foreignMessage) throws JMSException {
        Enumeration keys = foreignMessage.getPropertyNames();
        String key = null;
        Object value = null;
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            value = foreignMessage.getObjectProperty(key);
            message.setObjectProperty(key, value);
        }
    }

    protected Message convertTextMessage(TextMessage foreignMessage) throws JMSException {
        TextMessageImpl message = new TextMessageImpl();
        message.setText(foreignMessage.getText());
        return message;
    }

    protected Message convertMapMessage(MapMessage foreignMessage) throws JMSException {
        MapMessageImpl message = new MapMessageImpl();
        String key = null;
        Enumeration keys = foreignMessage.getMapNames();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            message.setObject(key, foreignMessage.getObject(key));
        }
        return message;
    }

    protected Message convertBytesMessage(BytesMessage foreignMessage) throws JMSException {
        BytesMessageImpl message = new BytesMessageImpl(true);
        byte b = 0;
        foreignMessage.reset();
        try {
            while (true) {
                b = foreignMessage.readByte();
                message.writeByte(b);
            }
        }
        catch (MessageEOFException messageEOFException) {
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4070");
        }
        return message;
    }

    protected Message convertObjectMessage(ObjectMessage foreignMessage) throws JMSException {
        ObjectMessageImpl message = new ObjectMessageImpl();
        message.setObject(foreignMessage.getObject());
        return message;
    }

    protected Message convertStreamMessage(StreamMessage foreignMessage) throws JMSException {
        StreamMessageImpl message = new StreamMessageImpl(true);
        Object obj = null;
        foreignMessage.reset();
        try {
            while (true) {
                obj = foreignMessage.readObject();
                message.writeObject(obj);
            }
        }
        catch (MessageEOFException messageEOFException) {
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4070");
        }
        return message;
    }
}

