/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth.usermgr;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserInfo;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserMgrException;
import com.sun.messaging.jmq.util.FileUtil;
import com.sun.messaging.jmq.util.MD5;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;

public class PasswdDB {
    private static boolean DEBUG = false;
    public static final char PASSWD_FIELD_SEPARATOR = ':';
    static String pas_file;

    public static void setPasswordFileName(String pfname) {
        pas_file = pfname;
    }

    public static String getPasswordFileName() {
        if (pas_file == null) {
            pas_file = Globals.getJMQ_ETC_HOME() + File.separator + "passwd";
            if (DEBUG) {
                System.out.println("Password Filename = " + pas_file);
            }
        }
        return pas_file;
    }

    public void addUser(String user_name, String password, String role) throws UserMgrException {
        int count;
        Hashtable user_add = this.getUserTable();
        if (role.equals("anonymous") && (count = this.getUserCount(user_add, "anonymous")) != 0) {
            UserMgrException ume = new UserMgrException(14);
            throw ume;
        }
        if (DEBUG) {
            Enumeration e = user_add.keys();
            while (e.hasMoreElements()) {
                String key_val = (String)e.nextElement();
                System.out.println("\t" + key_val + " = " + user_add.get(key_val));
            }
        }
        if (user_add.containsKey(user_name)) {
            UserMgrException ume = new UserMgrException(10);
            ume.setUserName(user_name);
            throw ume;
        }
        UserInfo newUserInfo = new UserInfo(user_name, this.hashPassword(user_name, password), role);
        user_add.put(user_name, newUserInfo);
        this.writeUserTable(user_add);
        if (DEBUG) {
            System.err.println("Users in role ADMIN: " + this.getUserCount("admin"));
            System.err.println("Users in role USER: " + this.getUserCount("user"));
            System.err.println("Users in role ANONYMOUS: " + this.getUserCount("anonymous"));
        }
    }

    public void deleteUser(String user_name) throws UserMgrException {
        Hashtable users = this.getUserTable();
        if (!users.containsKey(user_name)) {
            UserMgrException ume = new UserMgrException(9);
            ume.setUserName(user_name);
            throw ume;
        }
        users.remove(user_name);
        this.writeUserTable(users);
    }

    public void updateUser(String user_name, String new_pass, Boolean new_active) throws UserMgrException {
        Hashtable musers = this.getUserTable();
        if (!this.userExists(user_name, musers)) {
            UserMgrException ume = new UserMgrException(9);
            ume.setUserName(user_name);
            throw ume;
        }
        UserInfo curInfo = (UserInfo)musers.get(user_name);
        String curPasswd = curInfo.getPasswd();
        String curRole = curInfo.getRole();
        boolean curActive = curInfo.isActive();
        String newHashedPasswd = new_pass == null ? curPasswd : this.hashPassword(user_name, new_pass);
        boolean b = new_active == null ? curActive : new_active;
        UserInfo updateInfo = new UserInfo(user_name, newHashedPasswd, curRole, b);
        musers.put(user_name, updateInfo);
        this.writeUserTable(musers);
    }

    public UserInfo getUserInfo(String user) throws UserMgrException {
        Hashtable users = this.getUserTable();
        UserInfo uInfo = (UserInfo)users.get(user);
        return uInfo;
    }

    public Enumeration getUsers() throws UserMgrException {
        Hashtable users = this.getUserTable();
        return users.elements();
    }

    public boolean userExists(String user_name, Hashtable users) {
        return users.containsKey(user_name);
    }

    public int getUserCount(String role) throws UserMgrException {
        Hashtable users = this.getUserTable();
        return this.getUserCount(users, role);
    }

    private int getUserCount(Hashtable users, String role) throws UserMgrException {
        int count = 0;
        if (role == null || role.equals("")) {
            return users.size();
        }
        Enumeration e = this.getUsers();
        while (e.hasMoreElements()) {
            UserInfo oneUser = (UserInfo)e.nextElement();
            if (!oneUser.getRole().equals(role)) continue;
            ++count;
        }
        return count;
    }

    private String hashPassword(String u_name, String pass) throws UserMgrException {
        String s;
        try {
            s = MD5.getHashString((String)(u_name + ":" + pass));
        }
        catch (Exception ex) {
            UserMgrException ume = new UserMgrException(20);
            ume.setLinkedException(ex);
            throw ume;
        }
        return s;
    }

    private Hashtable getUserTable() throws UserMgrException {
        Hashtable<String, UserInfo> user_list = new Hashtable<String, UserInfo>(13);
        FileInputStream fis = null;
        InputStreamReader in = null;
        String passwd_filename = PasswdDB.getPasswordFileName();
        try {
            fis = new FileInputStream(passwd_filename);
        }
        catch (FileNotFoundException fnfe) {
            UserMgrException ume = new UserMgrException(7);
            ume.setPasswordFile(FileUtil.getCanonicalPath((String)passwd_filename));
            ume.setLinkedException(fnfe);
            throw ume;
        }
        try {
            in = new InputStreamReader((InputStream)fis, "UTF8");
        }
        catch (UnsupportedEncodingException usEncEx) {
            in = null;
        }
        if (in == null) {
            in = new InputStreamReader(fis);
        }
        try (BufferedReader br = new BufferedReader(in);){
            String str;
            while ((str = br.readLine()) != null) {
                if (DEBUG) {
                    System.out.println("Uname:Pwd read from file = " + str);
                }
                int ind1 = str.indexOf(58);
                int ind2 = str.indexOf(58, ind1 + 1);
                int ind3 = str.lastIndexOf(58);
                if (ind1 == -1 || ind2 == -1 || ind3 == -1) {
                    throw new IOException(Globals.getBrokerResources().getString("B4117", "format error in passwd file " + FileUtil.getCanonicalPath((String)passwd_filename)));
                }
                String u_name = str.substring(0, ind1);
                String u_pwd = str.substring(ind1 + 1, ind2);
                String u_role = str.substring(ind2 + 1, ind3);
                String u_active = str.substring(ind3 + 1);
                if (DEBUG) {
                    System.out.println("User name = " + u_name + " & Password = " + u_pwd + " & role = " + u_role + " & active = " + u_active);
                }
                boolean active = u_active.equals("1");
                user_list.put(u_name, new UserInfo(u_name, u_pwd, u_role, active));
            }
        }
        catch (IOException ioe) {
            UserMgrException ume = new UserMgrException(13);
            ume.setPasswordFile(FileUtil.getCanonicalPath((String)passwd_filename));
            ume.setLinkedException(ioe);
            throw ume;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
        return user_list;
    }

    private void writeUserTable(Hashtable users) throws UserMgrException {
        String passwd_filename = PasswdDB.getPasswordFileName();
        FileOutputStream fos = null;
        OutputStreamWriter out = null;
        try {
            fos = new FileOutputStream(passwd_filename);
        }
        catch (FileNotFoundException fnfe) {
            UserMgrException ume = new UserMgrException(7);
            ume.setPasswordFile(FileUtil.getCanonicalPath((String)passwd_filename));
            ume.setLinkedException(fnfe);
            throw ume;
        }
        try {
            out = new OutputStreamWriter((OutputStream)fos, "UTF8");
        }
        catch (UnsupportedEncodingException usEncEx) {
            out = null;
        }
        if (out == null) {
            out = new OutputStreamWriter(fos);
        }
        try {
            Enumeration e = users.keys();
            while (e.hasMoreElements()) {
                String k_val = (String)e.nextElement();
                UserInfo user = (UserInfo)users.get(k_val);
                out.write(user.getPasswdEntry() + "\n");
            }
            out.flush();
        }
        catch (IOException ioe) {
            UserMgrException ume = new UserMgrException(12);
            ume.setPasswordFile(passwd_filename);
            ume.setLinkedException(ioe);
            throw ume;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            try {
                fos.close();
            }
            catch (Exception exception) {}
        }
    }
}

