/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GetTransactionsHandler
extends AdminCmdHandler {
    private static boolean DEBUG = GetTransactionsHandler.getDEBUG();
    private static int LOCAL = 0;
    private static int CLUSTER = 1;
    private static int REMOTE = 2;
    private static int UNKNOWN = -1;

    public GetTransactionsHandler(AdminDataHandler parent) {
        super(parent);
    }

    public static Hashtable getTransactionInfo(TransactionList tl, TransactionUID id, int type) {
        return GetTransactionsHandler.getTransactionInfo(tl, id, type, false);
    }

    private static Hashtable getTransactionInfo(TransactionList tl, TransactionUID id, int type, boolean showpartition) {
        Logger logger = Globals.getLogger();
        TransactionState ts = tl.retrieveState(id);
        if (type == LOCAL) {
            ts = tl.retrieveState(id, true);
        } else if (type == CLUSTER) {
            ts = tl.retrieveState(id, true);
        } else if (type == REMOTE) {
            ts = tl.getRemoteTransactionState(id);
        }
        if (ts == null) {
            return null;
        }
        JMQXid xid = tl.UIDToXid(id);
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        table.put("type", type);
        if (xid != null) {
            table.put("xid", xid.toString());
        }
        PartitionedStore pstore = tl.getPartitionedStore();
        table.put("txnid", Long.valueOf(id.longValue()) + (showpartition ? "[" + pstore.getPartitionID() + (pstore.isPrimaryPartition() ? "*]" : "]") : ""));
        if (ts.getUser() != null) {
            table.put("user", ts.getUser());
        }
        if (ts.getClientID() != null) {
            table.put("clientid", ts.getClientID());
        }
        table.put("timestamp", System.currentTimeMillis() - id.age());
        table.put("connection", ts.getConnectionString());
        table.put("nmsgs", tl.retrieveNSentMessages(id));
        if (type != REMOTE) {
            table.put("nacks", tl.retrieveNConsumedMessages(id));
        } else {
            table.put("nacks", tl.retrieveNRemoteConsumedMessages(id));
        }
        table.put("state", ts.getState());
        ConnectionUID cuid = ts.getConnectionUID();
        if (cuid != null) {
            table.put("connectionid", cuid.longValue());
        }
        TransactionBroker homeBroker = tl.getRemoteTransactionHomeBroker(id);
        String homeBrokerStr = "";
        if (homeBroker != null) {
            homeBrokerStr = homeBroker.getBrokerAddress().toString();
        }
        table.put("homebroker", homeBrokerStr);
        TransactionBroker[] brokers = null;
        if (type != REMOTE) {
            try {
                brokers = tl.getClusterTransactionBrokers(id);
            }
            catch (BrokerException be) {
                logger.log(16, "Exception caught while obtaining list of brokers in transaction", (Throwable)be);
            }
        }
        StringBuffer allBrokers = new StringBuffer();
        StringBuffer pendingBrokers = new StringBuffer();
        if (brokers != null) {
            for (int i = 0; i < brokers.length; ++i) {
                TransactionBroker oneBroker = brokers[i];
                BrokerAddress addr = oneBroker.getBrokerAddress();
                if (allBrokers.length() != 0) {
                    allBrokers.append(", ");
                }
                allBrokers.append(addr.toString());
                if (oneBroker.isCompleted()) continue;
                if (pendingBrokers.length() != 0) {
                    pendingBrokers.append(", ");
                }
                pendingBrokers.append(addr.toString());
            }
        }
        table.put("allbrokers", allBrokers.toString());
        table.put("pendingbrokers", pendingBrokers.toString());
        return table;
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        Vector<Hashtable> v;
        TransactionUID tid;
        String errMsg;
        int status;
        block24: {
            boolean showpartition;
            if (DEBUG) {
                this.logger.log(8, this.getClass().getName() + ": Getting transactions " + cmd_props);
            }
            status = 200;
            errMsg = null;
            tid = null;
            Long id = (Long)cmd_props.get("JMQTransactionID");
            Boolean val = (Boolean)cmd_props.get("JMQShowPartition");
            boolean bl = showpartition = val == null ? false : val;
            if (id != null) {
                tid = new TransactionUID(id);
            }
            v = new Vector<Hashtable>();
            try {
                TransactionList tl = null;
                Hashtable table = null;
                if (tid != null) {
                    Object[] oo = TransactionList.getTransListAndState(tid, null, true, false);
                    if (oo == null) {
                        oo = TransactionList.getTransListAndRemoteState(tid);
                    }
                    if (oo == null) {
                        throw new BrokerException(this.rb.getKString("B4271", tid), 404);
                    }
                    tl = (TransactionList)oo[0];
                    int type = UNKNOWN;
                    if (tl.isRemoteTransaction(tid)) {
                        type = REMOTE;
                    } else if (tl.isClusterTransaction(tid)) {
                        type = CLUSTER;
                    } else if (tl.isLocalTransaction(tid)) {
                        type = LOCAL;
                    }
                    table = GetTransactionsHandler.getTransactionInfo(tl, tid, type, showpartition);
                    if (table != null) {
                        v.add(table);
                    }
                } else {
                    TransactionList[] tls = DestinationList.getTransactionList(null);
                    for (int i = 0; i < tls.length; ++i) {
                        Enumeration e;
                        tl = tls[i];
                        TransactionUID ttid = null;
                        Vector transactions = tl.getTransactions(-1);
                        if (transactions != null) {
                            e = transactions.elements();
                            while (e.hasMoreElements()) {
                                ttid = (TransactionUID)e.nextElement();
                                table = GetTransactionsHandler.getTransactionInfo(tl, ttid, LOCAL, showpartition);
                                if (table == null) continue;
                                v.add(table);
                            }
                        }
                        if ((transactions = tl.getClusterTransactions(-1)) != null) {
                            e = transactions.elements();
                            while (e.hasMoreElements()) {
                                ttid = (TransactionUID)e.nextElement();
                                table = GetTransactionsHandler.getTransactionInfo(tl, ttid, CLUSTER, showpartition);
                                if (table == null) continue;
                                v.add(table);
                            }
                        }
                        if ((transactions = tl.getRemoteTransactions(-1)) == null) continue;
                        e = transactions.elements();
                        while (e.hasMoreElements()) {
                            ttid = (TransactionUID)e.nextElement();
                            table = GetTransactionsHandler.getTransactionInfo(tl, ttid, REMOTE, showpartition);
                            if (table == null) continue;
                            v.add(table);
                        }
                    }
                }
            }
            catch (Exception e) {
                errMsg = e.getMessage();
                status = 500;
                if (!(e instanceof BrokerException)) break block24;
                status = ((BrokerException)e).getStatusCode();
            }
        }
        if (tid != null && v.size() == 0) {
            status = 404;
            errMsg = this.rb.getString("B3113", tid);
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        GetTransactionsHandler.setProperties(reply, 61, status, errMsg);
        try {
            reply.getProperties().put("JMQQuantity", v.size());
        }
        catch (IOException e) {
            this.logger.logStack(16, "B3100", (Object)"Admin: GetTransactions: Could not extract properties from pkt", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            this.logger.logStack(16, "B3100", (Object)"Admin: GetTransactions: Could not extract properties from pkt", (Throwable)e);
        }
        this.setBodyObject(reply, v);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }
}

