/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.group;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.pool.RunnableFactory;
import com.sun.messaging.jmq.jmsserver.pool.ThreadPool;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPService;
import com.sun.messaging.jmq.jmsserver.service.imq.group.GroupNotificationInfo;
import com.sun.messaging.jmq.jmsserver.service.imq.group.GroupRunnableFactory;
import com.sun.messaging.jmq.jmsserver.service.imq.group.MapList;
import com.sun.messaging.jmq.jmsserver.service.imq.group.SelectThread;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;

public class GroupService
extends IMQIPService {
    static boolean DEBUG = false;
    static MapList serviceReadSelectors = new MapList();
    static MapList serviceWriteSelectors = new MapList();
    static Class readSelectorClass = null;
    static Class writeSelectorClass = null;
    private static final String pkgname = "com.sun.messaging.jmq.jmsserver.service.imq.group.";
    public static final int UNLIMITED = -1;
    private static final int limit;

    Logger getLogger() {
        return this.logger;
    }

    public GroupService(String name, Protocol protocol, int type, PacketRouter router, int min, int max) {
        super(name, protocol, type, router, min, max);
        this.logger.log(4, "Running Group Service");
        serviceReadSelectors.initializeService(this, min / 2 + min % 2, limit, readSelectorClass, 1);
        serviceWriteSelectors.initializeService(this, min / 2, limit, writeSelectorClass, 4);
    }

    @Override
    public Hashtable getDebugState() {
        Hashtable ht = super.getDebugState();
        ht.put("readState", this.getDebugState(true));
        ht.put("writeState", this.getDebugState(false));
        return ht;
    }

    @Override
    public void acceptConnection(IMQIPConnection con) throws IOException, BrokerException {
        if (DEBUG) {
            this.logger.log(4, "Adding new Connection {0} ", (Object)con.toString());
        }
        GroupService.addConnection(this, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConnection(GroupService svc, IMQIPConnection conn) throws IOException {
        Class<GroupService> clazz = GroupService.class;
        synchronized (GroupService.class) {
            SelectThread readthr = serviceReadSelectors.findThread(svc);
            SelectThread writethr = serviceWriteSelectors.findThread(svc);
            if (readthr == null || writethr == null) {
                throw new IOException(Globals.getBrokerResources().getKString("B3100", " No threads allocated for " + (readthr == null ? (writethr == null ? "both" : "read") : "write") + " selector thread on service " + svc + " closing connection " + conn));
            }
            GroupNotificationInfo ninfo = new GroupNotificationInfo();
            ninfo.targetThreads(readthr, writethr);
            conn.attach(ninfo);
            readthr.addNewConnection(conn);
            writethr.addNewConnection(conn);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyService(Service svc) {
        Class<GroupService> clazz = GroupService.class;
        synchronized (GroupService.class) {
            serviceReadSelectors.destroy(svc);
            serviceWriteSelectors.destroy(svc);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void dump(PrintStream str) {
    }

    @Override
    public RunnableFactory getRunnableFactory() {
        return new GroupRunnableFactory();
    }

    ThreadPool getPool() {
        return this.pool;
    }

    public Hashtable getDebugState(boolean read) {
        if (read) {
            if (serviceReadSelectors == null) {
                Hashtable<String, String> ht = new Hashtable<String, String>();
                ht.put("serviceReadSelectors", "null");
                return ht;
            }
            return serviceReadSelectors.getDebugState(this);
        }
        if (serviceWriteSelectors == null) {
            Hashtable<String, String> ht = new Hashtable<String, String>();
            ht.put("serviceWriteSelectors", "null");
            return ht;
        }
        return serviceWriteSelectors.getDebugState(this);
    }

    static {
        try {
            readSelectorClass = Class.forName("com.sun.messaging.jmq.jmsserver.service.imq.group.ReadThread");
        }
        catch (Exception ex) {
            Globals.getLogger().logStack(32, "B3100", (Object)"unable to create class for handling READ selectors.", (Throwable)ex);
        }
        try {
            writeSelectorClass = Class.forName("com.sun.messaging.jmq.jmsserver.service.imq.group.WriteThread");
        }
        catch (Exception ex) {
            Globals.getLogger().logStack(32, "B3100", (Object)"unable to create class for handling WRITE selectors.", (Throwable)ex);
        }
        limit = Globals.getConfig().getIntProperty("imq.shared.connectionMonitor_limit", 64);
    }
}

