/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.operations;

import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.command.Command;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.server.actions.AbstractActionHandler;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.features.core.model.ModelSubmissionHandler;
import org.eclipse.glsp.server.internal.gmodel.commandstack.GModelRecordingCommand;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.operations.Operation;
import org.eclipse.glsp.server.operations.OperationHandler;
import org.eclipse.glsp.server.operations.OperationHandlerRegistry;
import org.eclipse.glsp.server.utils.ServerMessageUtil;

public class OperationActionHandler
extends AbstractActionHandler<Operation> {
    @Inject
    protected OperationHandlerRegistry operationHandlerRegistry;
    @Inject
    protected ModelSubmissionHandler modelSubmissionHandler;
    @Inject
    protected GModelState modelState;

    @Override
    public boolean handles(Action action) {
        return action instanceof Operation;
    }

    @Override
    public List<Action> executeAction(Operation operation) {
        if (this.modelState.isReadonly()) {
            return this.listOf(ServerMessageUtil.warn("Server is in readonly-mode! Could not execute operation: " + operation.getKind()));
        }
        return this.executeOperation(operation);
    }

    protected List<Action> executeOperation(Operation operation) {
        return this.operationHandlerRegistry.getOperationHandler(operation).map(handler -> this.executeHandler(operation, (OperationHandler)handler)).orElseGet(this::none);
    }

    protected List<Action> executeHandler(Operation operation, OperationHandler handler) {
        GModelRecordingCommand command = new GModelRecordingCommand((GModelRoot)this.modelState.getRoot(), handler.getLabel(), () -> handler.execute(operation));
        this.modelState.execute((Command)command);
        return this.modelSubmissionHandler.submitModel("operation");
    }

    @Deprecated
    public static Optional<? extends OperationHandler> getOperationHandler(Operation operation, OperationHandlerRegistry registry) {
        return registry.getOperationHandler(operation);
    }
}

