/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.gmodel;

import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.command.Command;
import org.eclipse.glsp.graph.GDimension;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.graph.GNode;
import org.eclipse.glsp.graph.GPoint;
import org.eclipse.glsp.graph.util.GraphUtil;
import org.eclipse.glsp.server.operations.ChangeBoundsOperation;
import org.eclipse.glsp.server.operations.GModelOperationHandler;
import org.eclipse.glsp.server.types.ElementAndBounds;
import org.eclipse.glsp.server.types.GLSPServerException;

public class GModelChangeBoundsOperationHandler
extends GModelOperationHandler<ChangeBoundsOperation> {
    protected static Logger LOGGER = LogManager.getLogger(GModelChangeBoundsOperationHandler.class);

    @Override
    public Optional<Command> createCommand(ChangeBoundsOperation operation) {
        return this.commandOf(() -> this.executeChangeBounds(operation));
    }

    protected void executeChangeBounds(ChangeBoundsOperation operation) {
        for (ElementAndBounds element : operation.getNewBounds()) {
            this.changeElementBounds(element.getElementId(), element.getNewPosition(), element.getNewSize());
        }
    }

    protected void changeElementBounds(String elementId, GPoint newPosition, GDimension newSize) {
        GPoint positionToSet;
        if (elementId == null) {
            LOGGER.warn("Invalid ChangeBounds Action; missing mandatory arguments");
            return;
        }
        GModelIndex index = this.modelState.getIndex();
        GNode nodeToUpdate = (GNode)GLSPServerException.getOrThrow(index.findElementByClass(elementId, GNode.class), "GNode with id " + elementId + " not found");
        GModelElement parent = nodeToUpdate.getParent();
        GPoint gPoint = positionToSet = parent instanceof GModelRoot ? newPosition : GraphUtil.point((double)Math.max(0.0, newPosition.getX()), (double)Math.max(0.0, newPosition.getY()));
        if (nodeToUpdate.getLayout() != null) {
            nodeToUpdate.getLayoutOptions().put((Object)"prefWidth", (Object)newSize.getWidth());
            nodeToUpdate.getLayoutOptions().put((Object)"prefHeight", (Object)newSize.getHeight());
        }
        nodeToUpdate.setSize(newSize);
        nodeToUpdate.setPosition(positionToSet);
    }
}

