/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.actions;

import java.util.Arrays;
import java.util.List;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionHandler;
import org.eclipse.glsp.server.internal.util.GenericsUtil;

public abstract class AbstractActionHandler<A extends Action>
implements ActionHandler {
    protected final Class<A> actionType = this.deriveActionType();

    protected Class<A> deriveActionType() {
        return GenericsUtil.getActualTypeArgument(this.getClass(), Action.class);
    }

    @Override
    public boolean handles(Action action) {
        return this.actionType.isInstance(action);
    }

    @Override
    public List<Action> execute(Action action) {
        if (this.handles(action)) {
            Action actualAction = (Action)this.actionType.cast(action);
            return this.executeAction(actualAction);
        }
        return this.none();
    }

    protected abstract List<Action> executeAction(A var1);

    public Class<A> getActionType() {
        return this.actionType;
    }

    @Override
    public List<Class<? extends Action>> getHandledActionTypes() {
        return Arrays.asList(this.actionType);
    }
}

