/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.DeviceContext;

public class GdiBrush {
    public static final int BS_SOLID = 0;
    public static final int BS_NULL = 1;
    public static final int BS_HOLLOW = 1;
    public static final int BS_HATCHED = 2;
    public static final int BS_PATTERN = 3;
    public static final int BS_INDEXED = 4;
    public static final int BS_DIBPATTERN = 5;
    public static final int BS_DIBPATTERNPT = 6;
    public static final int BS_PATTERN8X8 = 7;
    public static final int BS_DIBPATTERN8X8 = 8;
    public static final int BS_MONOPATTERN = 9;
    public static final int HS_HORIZONTAL = 0;
    public static final int HS_VERTICAL = 1;
    public static final int HS_FDIAGONAL = 2;
    public static final int HS_BDIAGONAL = 3;
    public static final int HS_CROSS = 4;
    public static final int HS_DIAGCROSS = 5;
    private int m_style = 0;
    private Color m_color = new Color(255, 255, 255);
    private int m_hatch = 0;
    private BufferedImage m_pattern = null;

    public GdiBrush() {
    }

    GdiBrush(GdiBrush brush) {
        this.m_style = brush.m_style;
        this.m_color = brush.m_color != null ? new Color(brush.m_color.getRGB()) : null;
        this.m_hatch = brush.m_hatch;
        if (brush.m_pattern != null) {
            this.m_pattern = brush.m_pattern.getSubimage(0, 0, this.m_pattern.getWidth(), this.m_pattern.getHeight());
        }
    }

    public GdiBrush(int style, Color color, int hatch) {
        this.m_style = style;
        this.m_color = color;
        this.m_hatch = hatch;
    }

    public GdiBrush(int style, BufferedImage pattern) {
        this.m_style = style;
        this.m_pattern = pattern;
    }

    public void fill(Shape s, Graphics2D g, DeviceContext context) {
        g.setColor(this.m_color);
        Paint oldPaint = null;
        switch (this.m_style) {
            default: {
                break;
            }
            case 1: {
                return;
            }
            case 2: {
                BufferedImage image = this.getHatch(context);
                Rectangle2D.Double anchor = new Rectangle2D.Double(0.0, 0.0, 8.0, 8.0);
                TexturePaint tp = new TexturePaint(image, anchor);
                oldPaint = g.getPaint();
                g.setPaint(tp);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                Rectangle2D.Double anchor = new Rectangle2D.Double(0.0, 0.0, this.m_pattern.getWidth(), this.m_pattern.getHeight());
                TexturePaint tp = new TexturePaint(this.m_pattern, anchor);
                oldPaint = g.getPaint();
                g.setPaint(tp);
                break;
            }
            case 6: {
                break;
            }
            case 9: {
                BufferedImage image = this.mapPatternToForeColor(context);
                Rectangle2D.Double anchor = new Rectangle2D.Double(0.0, 0.0, image.getWidth(), image.getHeight());
                TexturePaint tp = new TexturePaint(image, anchor);
                oldPaint = g.getPaint();
                g.setPaint(tp);
            }
            case 4: 
        }
        g.fill(s);
        if (oldPaint != null) {
            g.setPaint(oldPaint);
        }
    }

    private BufferedImage getHatch(DeviceContext context) {
        BufferedImage image = new BufferedImage(8, 8, 5);
        Graphics2D textureGraphics = image.createGraphics();
        textureGraphics.setColor(this.m_color);
        textureGraphics.setBackground(context.getBackColor());
        textureGraphics.clearRect(0, 0, 8, 8);
        switch (this.m_hatch) {
            case 0: {
                textureGraphics.drawLine(0, 4, 7, 4);
                break;
            }
            case 1: {
                textureGraphics.drawLine(4, 0, 4, 7);
                break;
            }
            case 2: {
                textureGraphics.drawLine(0, 0, 7, 7);
                break;
            }
            case 3: {
                textureGraphics.drawLine(7, 0, 0, 7);
                break;
            }
            case 4: {
                textureGraphics.drawLine(0, 4, 7, 4);
                textureGraphics.drawLine(4, 0, 4, 7);
                break;
            }
            default: {
                textureGraphics.drawLine(0, 0, 7, 7);
                textureGraphics.drawLine(7, 0, 0, 7);
            }
        }
        return image;
    }

    private BufferedImage mapPatternToForeColor(DeviceContext context) {
        BufferedImage image = this.m_pattern.getSubimage(0, 0, this.m_pattern.getWidth(), this.m_pattern.getHeight());
        int height = image.getHeight();
        int y = 0;
        while (y < height) {
            int width = image.getWidth();
            int x = 0;
            while (x < width) {
                int rgb = image.getRGB(x, y) & 0xFFFFFF;
                if (rgb == 0) {
                    image.setRGB(x, y, context.getTextColor().getRGB());
                } else {
                    image.setRGB(x, y, context.getBackColor().getRGB());
                }
                ++x;
            }
            ++y;
        }
        return image;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Brush: color=" + this.m_color.toString());
        sb.append(", style=");
        block0 : switch (this.m_style) {
            default: {
                sb.append("solid");
                break;
            }
            case 1: {
                sb.append("null");
                break;
            }
            case 2: {
                sb.append("hatch ");
                switch (this.m_hatch) {
                    case 0: {
                        sb.append("-----");
                        break block0;
                    }
                    case 1: {
                        sb.append("|||||");
                        break block0;
                    }
                    case 2: {
                        sb.append("\\\\\\\\\\");
                        break block0;
                    }
                    case 3: {
                        sb.append("/////");
                        break block0;
                    }
                    case 4: {
                        sb.append("+++++");
                        break block0;
                    }
                }
                sb.append("XXXXX");
                break;
            }
            case 3: {
                sb.append("pattern");
                break;
            }
            case 7: {
                sb.append("pattern8x8");
                break;
            }
            case 5: {
                sb.append("dibPattern");
                break;
            }
            case 8: {
                sb.append("dibPattern8x8");
                break;
            }
            case 6: {
                sb.append("dibPatternPT");
                break;
            }
            case 9: {
                sb.append("monoPattern");
                break;
            }
            case 4: {
                sb.append("indexed");
            }
        }
        return sb.toString();
    }
}

