/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.graphics;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.Stack;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeTypes;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderInfo;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.image.ImageConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.GdiFont;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.DrawableRenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.RenderingListener;
import org.eclipse.gmf.runtime.draw2d.ui.text.TextUtilitiesEx;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextLayout;

public class GraphicsToGraphics2DAdaptor
extends Graphics
implements DrawableRenderedImage {
    static final int ADVANCED_GRAPHICS_MASK;
    static final int ADVANCED_SHIFT;
    static final int FILL_RULE_MASK;
    static final int FILL_RULE_SHIFT;
    static final int FILL_RULE_WHOLE_NUMBER = -1;
    private SWTGraphics swtGraphics;
    private Graphics2D graphics2D;
    private BasicStroke stroke;
    private Stack<State> states = new Stack();
    private final State currentState = new State();
    private final State appliedState = new State();
    protected boolean paintNotCompatibleStringsAsBitmaps = true;
    private static final TextUtilitiesEx TEXT_UTILITIES;
    private Rectangle relativeClipRegion;
    private org.eclipse.swt.graphics.Rectangle viewBox;
    private org.eclipse.swt.graphics.Image image;
    private int transX = 0;
    private int transY = 0;

    static {
        FILL_RULE_SHIFT = 14;
        ADVANCED_SHIFT = 15;
        FILL_RULE_MASK = 1 << FILL_RULE_SHIFT;
        ADVANCED_GRAPHICS_MASK = 1 << ADVANCED_SHIFT;
        TEXT_UTILITIES = new TextUtilitiesEx(MapModeTypes.IDENTITY_MM);
    }

    public GraphicsToGraphics2DAdaptor(Graphics2D graphics, Rectangle viewPort) {
        this(graphics, new org.eclipse.swt.graphics.Rectangle(viewPort.x, viewPort.y, viewPort.width, viewPort.height));
    }

    public GraphicsToGraphics2DAdaptor(Graphics2D graphics, org.eclipse.swt.graphics.Rectangle viewPort) {
        this.viewBox = viewPort;
        this.createSWTGraphics();
        this.initSVGGraphics(graphics);
        this.init();
    }

    private void createSWTGraphics() {
        org.eclipse.swt.graphics.Rectangle tempRect = new org.eclipse.swt.graphics.Rectangle(0, 0, 10, 10);
        this.image = new org.eclipse.swt.graphics.Image((Device)DisplayUtils.getDisplay(), tempRect);
        GC gc = new GC((Drawable)this.image);
        this.swtGraphics = new SWTGraphics(gc);
    }

    private void initSVGGraphics(Graphics2D graphics) {
        this.graphics2D = graphics;
        this.relativeClipRegion = new Rectangle(this.viewBox.x, this.viewBox.y, this.viewBox.width, this.viewBox.height);
        this.stroke = new BasicStroke(this.swtGraphics.getLineWidth(), 2, 1, 0.0f, null, 0.0f);
        LineAttributes lineAttributes = new LineAttributes(1.0f);
        this.swtGraphics.getLineAttributes(lineAttributes);
        this.setLineAttributes(lineAttributes);
        this.setFillRule(this.swtGraphics.getFillRule());
        this.setAdvanced(this.swtGraphics.getAdvanced());
        this.getGraphics2D().setStroke(this.stroke);
    }

    private void init() {
        this.setForegroundColor(this.getForegroundColor());
        this.setBackgroundColor(this.getBackgroundColor());
        this.setXORMode(this.getXORMode());
        this.setFont(this.getFont());
        this.currentState.font = this.appliedState.font = this.getFont();
        this.currentState.translateX = this.appliedState.translateX = this.transX;
        this.currentState.translateY = this.appliedState.translateY = this.transY;
        this.currentState.clipX = this.appliedState.clipX = this.relativeClipRegion.x;
        this.currentState.clipY = this.appliedState.clipY = this.relativeClipRegion.y;
        this.currentState.clipW = this.appliedState.clipW = this.relativeClipRegion.width;
        this.currentState.clipH = this.appliedState.clipH = this.relativeClipRegion.height;
        this.currentState.alpha = this.appliedState.alpha = this.getAlpha();
    }

    protected void checkState() {
        if (this.appliedState.font != this.currentState.font) {
            this.appliedState.font = this.currentState.font;
            this.setFont(this.currentState.font);
        }
        if (this.appliedState.clipX != this.currentState.clipX || this.appliedState.clipY != this.currentState.clipY || this.appliedState.clipW != this.currentState.clipW || this.appliedState.clipH != this.currentState.clipH) {
            this.appliedState.clipX = this.currentState.clipX;
            this.appliedState.clipY = this.currentState.clipY;
            this.appliedState.clipW = this.currentState.clipW;
            this.appliedState.clipH = this.currentState.clipH;
            this.getGraphics2D().setClip(this.currentState.clipX - 1, this.currentState.clipY - 1, this.currentState.clipW + 2, this.currentState.clipH + 2);
        }
        if (this.appliedState.alpha != this.currentState.alpha) {
            this.appliedState.alpha = this.currentState.alpha;
            this.setAlpha(this.currentState.alpha);
        }
        this.appliedState.graphicHints = this.currentState.graphicHints;
    }

    public void clipRect(Rectangle rect) {
        this.relativeClipRegion.intersect(rect);
        this.setClipAbsolute(this.relativeClipRegion.x + this.transX, this.relativeClipRegion.y + this.transY, this.relativeClipRegion.width, this.relativeClipRegion.height);
    }

    public void dispose() {
        this.swtGraphics.dispose();
        if (this.image != null) {
            this.image.dispose();
        }
        this.states.clear();
    }

    protected Color getColor(org.eclipse.swt.graphics.Color toConvert) {
        return new Color(toConvert.getRed(), toConvert.getGreen(), toConvert.getBlue());
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int endAngle) {
        Arc2D.Float arc = new Arc2D.Float(x + this.transX, y + this.transY, width - 1, height, startAngle, endAngle, 0);
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getForegroundColor()));
        this.getGraphics2D().setStroke(this.createStroke());
        this.getGraphics2D().draw(arc);
    }

    public void fillArc(int x, int y, int w, int h, int offset, int length) {
        Arc2D.Float arc = new Arc2D.Float(x + this.transX, y + this.transY, w, h, offset, length, 0);
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getBackgroundColor()));
        this.getGraphics2D().fill(arc);
    }

    public void drawFocus(int x, int y, int w, int h) {
        this.drawRectangle(x, y, w, h);
    }

    public void drawTextLayout(TextLayout layout, int x, int y, int selectionStart, int selectionEnd, org.eclipse.swt.graphics.Color selectionForeground, org.eclipse.swt.graphics.Color selectionBackground) {
        this.checkState();
        if (!layout.getBounds().isEmpty()) {
            org.eclipse.swt.graphics.Image image = new org.eclipse.swt.graphics.Image((Device)DisplayUtils.getDisplay(), layout.getBounds().width, layout.getBounds().height);
            GC gc = new GC((Drawable)image);
            this.cloneGC(gc);
            layout.draw(gc, 0, 0, selectionStart, selectionEnd, selectionForeground, selectionBackground);
            ImageData imageData = image.getImageData();
            imageData.transparentPixel = imageData.palette.getPixel(this.getBackgroundColor().getRGB());
            gc.dispose();
            image.dispose();
            this.getGraphics2D().drawImage((Image)ImageConverter.convertFromImageData(imageData), x + this.transX, y + this.transY, null);
        }
    }

    private void cloneGC(GC gc) {
        gc.setAdvanced(this.getAdvanced());
        gc.setAlpha(this.getAlpha());
        gc.setAntialias(this.getAntialias());
        gc.setFillRule(this.getFillRule());
        gc.setFont(this.getFont());
        gc.setInterpolation(this.getInterpolation());
        gc.setLineAttributes(this.getLineAttributes());
        gc.setTextAntialias(this.getTextAntialias());
        gc.setBackground(this.getBackgroundColor());
        gc.setForeground(this.getForegroundColor());
    }

    public int getInterpolation() {
        return this.swtGraphics.getInterpolation();
    }

    public LineAttributes getLineAttributes() {
        LineAttributes la = new LineAttributes(1.0f);
        this.swtGraphics.getLineAttributes(la);
        return la;
    }

    public int getTextAntialias() {
        return this.swtGraphics.getTextAntialias();
    }

    public void drawImage(org.eclipse.swt.graphics.Image srcImage, int xpos, int ypos) {
        BufferedImage toDraw = ImageConverter.convert(srcImage);
        this.checkState();
        this.getGraphics2D().drawImage(toDraw, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, xpos += this.transX, ypos += this.transY), null);
    }

    public void drawImage(org.eclipse.swt.graphics.Image srcImage, int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        BufferedImage toDraw = ImageConverter.convert(srcImage);
        this.checkState();
        this.getGraphics2D().drawImage(toDraw, x2 += this.transX, y2 += this.transY, w2, h2, null);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        Line2D.Float line = new Line2D.Float(x1 + this.transX, y1 + this.transY, x2 + this.transX, y2 + this.transY);
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getForegroundColor()));
        this.getGraphics2D().setStroke(this.createStroke());
        this.getGraphics2D().draw(line);
    }

    public void drawOval(int x, int y, int w, int h) {
        Ellipse2D.Float ellipse = new Ellipse2D.Float(x + this.transX, y + this.transY, w, h);
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getForegroundColor()));
        this.getGraphics2D().setStroke(this.createStroke());
        this.getGraphics2D().draw(ellipse);
    }

    public void fillOval(int x, int y, int w, int h) {
        Ellipse2D.Float ellipse = new Ellipse2D.Float(x + this.transX, y + this.transY, w - 1, h - 1);
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getBackgroundColor()));
        this.getGraphics2D().fill(ellipse);
    }

    private Polygon createPolygon(PointList pointList) {
        Polygon toCreate = new Polygon();
        int i = 0;
        while (i < pointList.size()) {
            Point pt = pointList.getPoint(i);
            toCreate.addPoint(pt.x + this.transX, pt.y + this.transY);
            ++i;
        }
        return toCreate;
    }

    public void drawPolygon(PointList pointList) {
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getForegroundColor()));
        this.getGraphics2D().setStroke(this.createStroke());
        this.getGraphics2D().draw(this.createPolygon(pointList));
    }

    public void fillPolygon(PointList pointList) {
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getBackgroundColor()));
        this.getGraphics2D().fill(this.createPolygon(pointList));
    }

    public void drawPolyline(PointList pointList) {
        int x = 1;
        while (x < pointList.size()) {
            Point p1 = pointList.getPoint(x - 1);
            Point p2 = pointList.getPoint(x);
            this.drawLine(p1.x, p1.y, p2.x, p2.y);
            ++x;
        }
    }

    public void drawRectangle(int x, int y, int w, int h) {
        Rectangle2D.Float rect = new Rectangle2D.Float(x + this.transX, y + this.transY, w, h);
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getForegroundColor()));
        this.getGraphics2D().setStroke(this.createStroke());
        this.getGraphics2D().draw(rect);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        Rectangle2D.Float rect = new Rectangle2D.Float(x + this.transX, y + this.transY, width, height);
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getBackgroundColor()));
        this.getGraphics2D().fill(rect);
    }

    public void drawRoundRectangle(Rectangle rect, int arcWidth, int arcHeight) {
        RoundRectangle2D.Float roundRect = new RoundRectangle2D.Float(rect.x + this.transX, rect.y + this.transY, rect.width, rect.height, arcWidth, arcHeight);
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getForegroundColor()));
        this.getGraphics2D().setStroke(this.createStroke());
        this.getGraphics2D().draw(roundRect);
    }

    public void fillRoundRectangle(Rectangle rect, int arcWidth, int arcHeight) {
        RoundRectangle2D.Float roundRect = new RoundRectangle2D.Float(rect.x + this.transX, rect.y + this.transY, rect.width, rect.height, arcWidth, arcHeight);
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getBackgroundColor()));
        this.getGraphics2D().fill(roundRect);
    }

    public void drawText(String s, int x, int y) {
        this.drawString(s, x, y);
    }

    public void drawString(String s, int x, int y) {
        int lineWidth;
        if (s == null || s.length() == 0) {
            return;
        }
        java.awt.FontMetrics metrics = this.getGraphics2D().getFontMetrics();
        int stringLength = metrics.stringWidth(s);
        Dimension swtStringSize = TEXT_UTILITIES.getStringExtents(s, this.swtGraphics.getFont());
        float xpos = x + this.transX;
        float ypos = y + this.transY;
        if (this.paintNotCompatibleStringsAsBitmaps && this.getGraphics2D().getFont().canDisplayUpTo(s) != -1) {
            org.eclipse.swt.graphics.Image image = new org.eclipse.swt.graphics.Image((Device)DisplayUtils.getDisplay(), swtStringSize.width, swtStringSize.height);
            GC gc = new GC((Drawable)image);
            gc.setForeground(this.getForegroundColor());
            gc.setBackground(this.getBackgroundColor());
            gc.setAntialias(this.getAntialias());
            gc.setFont(this.getFont());
            gc.drawString(s, 0, 0);
            gc.dispose();
            ImageData data = image.getImageData();
            image.dispose();
            RGB backgroundRGB = this.getBackgroundColor().getRGB();
            int i = 0;
            while (i < data.width) {
                int j = 0;
                while (j < data.height) {
                    if (data.palette.getRGB(data.getPixel(i, j)).equals((Object)backgroundRGB)) {
                        data.setAlpha(i, j, 0);
                    } else {
                        data.setAlpha(i, j, 255);
                    }
                    ++j;
                }
                ++i;
            }
            this.checkState();
            this.getGraphics2D().drawImage(ImageConverter.convertFromImageData(data), new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, xpos, ypos), null);
            stringLength = swtStringSize.width;
        } else {
            this.checkState();
            this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getForegroundColor()));
            this.getGraphics2D().drawString(s, xpos, ypos += (float)metrics.getAscent());
        }
        if (this.isFontUnderlined(this.getFont())) {
            int baseline = y + metrics.getAscent();
            lineWidth = this.getLineWidth();
            this.setLineWidth(1);
            this.drawLine(x, baseline, x + stringLength, baseline);
            this.setLineWidth(lineWidth);
        }
        if (this.isFontStrikeout(this.getFont())) {
            int strikeline = y + metrics.getHeight() / 2;
            lineWidth = this.getLineWidth();
            this.setLineWidth(1);
            this.drawLine(x, strikeline, x + stringLength, strikeline);
            this.setLineWidth(lineWidth);
        }
    }

    public void fillString(String s, int x, int y) {
    }

    public void fillText(String s, int x, int y) {
    }

    public org.eclipse.swt.graphics.Color getBackgroundColor() {
        return this.swtGraphics.getBackgroundColor();
    }

    public Rectangle getClip(Rectangle rect) {
        rect.setBounds(this.relativeClipRegion);
        return rect;
    }

    public Font getFont() {
        return this.swtGraphics.getFont();
    }

    public FontMetrics getFontMetrics() {
        return this.swtGraphics.getFontMetrics();
    }

    public org.eclipse.swt.graphics.Color getForegroundColor() {
        return this.swtGraphics.getForegroundColor();
    }

    public int getLineStyle() {
        return this.swtGraphics.getLineStyle();
    }

    public int getLineWidth() {
        return this.swtGraphics.getLineWidth();
    }

    public float getLineWidthFloat() {
        return this.swtGraphics.getLineWidthFloat();
    }

    public boolean getXORMode() {
        return this.swtGraphics.getXORMode();
    }

    public void popState() {
        this.swtGraphics.popState();
        this.restoreState(this.states.pop());
    }

    public void pushState() {
        this.swtGraphics.pushState();
        State toPush = new State();
        toPush.copyFrom(this.currentState);
        this.states.push(toPush);
    }

    public void restoreState() {
        this.swtGraphics.restoreState();
        this.restoreState(this.states.peek());
    }

    private void restoreState(State state) {
        this.setBackgroundColor(state.bgColor);
        this.setForegroundColor(state.fgColor);
        this.setLineAttributes(state.lineAttributes);
        this.setXORMode(state.XorMode);
        this.setClipAbsolute(state.clipX, state.clipY, state.clipW, state.clipH);
        this.transX = this.currentState.translateX = state.translateX;
        this.transY = this.currentState.translateY = state.translateY;
        this.relativeClipRegion.x = state.clipX - this.transX;
        this.relativeClipRegion.y = state.clipY - this.transY;
        this.relativeClipRegion.width = state.clipW;
        this.relativeClipRegion.height = state.clipH;
        this.currentState.font = state.font;
        this.currentState.alpha = state.alpha;
    }

    public void scale(double amount) {
        this.swtGraphics.scale(amount);
    }

    public void setBackgroundColor(org.eclipse.swt.graphics.Color rgb) {
        this.currentState.bgColor = rgb;
        this.swtGraphics.setBackgroundColor(rgb);
    }

    public void setClip(Rectangle rect) {
        this.relativeClipRegion.x = rect.x;
        this.relativeClipRegion.y = rect.y;
        this.relativeClipRegion.width = rect.width;
        this.relativeClipRegion.height = rect.height;
        this.setClipAbsolute(rect.x + this.transX, rect.y + this.transY, rect.width, rect.height);
    }

    private void setClipAbsolute(int x, int y, int width, int height) {
        this.currentState.clipX = x;
        this.currentState.clipY = y;
        this.currentState.clipW = width;
        this.currentState.clipH = height;
    }

    private boolean isFontUnderlined(Font f) {
        return false;
    }

    private boolean isFontStrikeout(Font f) {
        return false;
    }

    public void setFont(Font f) {
        this.swtGraphics.setFont(f);
        this.currentState.font = f;
        FontData[] fontInfo = f.getFontData();
        if (fontInfo[0] != null) {
            int height = fontInfo[0].getHeight();
            float fsize = (float)height * (float)DisplayUtils.getDisplay().getDPI().x / 72.0f;
            height = Math.round(fsize);
            int style = fontInfo[0].getStyle();
            boolean bItalic = (style & 2) == 2;
            boolean bBold = (style & 1) == 1;
            String faceName = fontInfo[0].getName();
            int escapement = 0;
            boolean bUnderline = this.isFontUnderlined(f);
            boolean bStrikeout = this.isFontStrikeout(f);
            GdiFont font = new GdiFont(height, bItalic, bUnderline, bStrikeout, bBold, faceName, escapement);
            this.getGraphics2D().setFont(font.getFont());
        }
    }

    public void setForegroundColor(org.eclipse.swt.graphics.Color rgb) {
        this.currentState.fgColor = rgb;
        this.swtGraphics.setForegroundColor(rgb);
    }

    public void setLineDash(int[] dash) {
        float[] dashFlt = new float[dash.length];
        int i = 0;
        while (i < dash.length) {
            dashFlt[i] = dash[i];
            ++i;
        }
        this.setLineDash(dashFlt);
    }

    public void setLineDash(float[] dash) {
        this.currentState.lineAttributes.dash = dash;
        this.setLineStyle(6);
        this.swtGraphics.setLineDash(dash);
    }

    public void setLineStyle(int style) {
        this.currentState.lineAttributes.style = style;
        this.swtGraphics.setLineStyle(style);
    }

    public void setLineMiterLimit(float miterLimit) {
    }

    public void setLineCap(int cap) {
    }

    public void setLineJoin(int join) {
    }

    public void setLineWidth(int width) {
        this.setLineWidthFloat(width);
    }

    public void setLineWidthFloat(float width) {
        this.currentState.lineAttributes.width = width;
        this.swtGraphics.setLineWidthFloat(width);
    }

    public void setLineAttributes(LineAttributes lineAttributes) {
        SWTGraphics.copyLineAttributes((LineAttributes)this.currentState.lineAttributes, (LineAttributes)lineAttributes);
        this.swtGraphics.setLineAttributes(lineAttributes);
    }

    public void setXORMode(boolean xorMode) {
        this.currentState.XorMode = xorMode;
        this.swtGraphics.setXORMode(xorMode);
    }

    private void setTranslation(int x, int y) {
        this.transX = this.currentState.translateX = x;
        this.transY = this.currentState.translateY = y;
    }

    public void translate(int dx, int dy) {
        this.swtGraphics.translate(dx, dy);
        this.setTranslation(this.transX + dx, this.transY + dy);
        this.relativeClipRegion.x -= dx;
        this.relativeClipRegion.y -= dy;
    }

    protected Graphics2D getGraphics2D() {
        return this.graphics2D;
    }

    private SWTGraphics getSWTGraphics() {
        return this.swtGraphics;
    }

    public void fillGradient(int x, int y, int w, int h, boolean vertical) {
        this.checkState();
        Color start = this.getColor(this.getSWTGraphics().getForegroundColor());
        Color stop = this.getColor(this.getSWTGraphics().getBackgroundColor());
        GradientPaint gradient = vertical ? new GradientPaint(x + this.transX, y + this.transY, start, x + this.transX, y + h + this.transY, stop) : new GradientPaint(x + this.transX, y + this.transY, start, x + w + this.transX, y + this.transY, stop);
        Paint oldPaint = this.getGraphics2D().getPaint();
        this.getGraphics2D().setPaint(gradient);
        this.getGraphics2D().fill(new Rectangle2D.Double(x + this.transX, y + this.transY, w, h));
        this.getGraphics2D().setPaint(oldPaint);
    }

    public void drawPath(Path path) {
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getForegroundColor()));
        this.getGraphics2D().setStroke(this.createStroke());
        this.getGraphics2D().draw(this.createPathAWT(path));
    }

    public void fillPath(Path path) {
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getBackgroundColor()));
        this.getGraphics2D().fill(this.createPathAWT(path));
    }

    public void setClip(Path path) {
        if (((this.appliedState.graphicHints ^ this.currentState.graphicHints) & FILL_RULE_MASK) != 0) {
            this.appliedState.graphicHints ^= FILL_RULE_MASK;
        }
        this.getGraphics2D().setClip(this.createPathAWT(path));
        this.currentState.clipX = 0;
        this.appliedState.clipX = 0;
        this.currentState.clipY = 0;
        this.appliedState.clipY = 0;
        this.currentState.clipW = 0;
        this.appliedState.clipW = 0;
        this.currentState.clipH = 0;
        this.appliedState.clipH = 0;
    }

    public int getFillRule() {
        return ((this.currentState.graphicHints & FILL_RULE_MASK) >> FILL_RULE_SHIFT) - -1;
    }

    public void setFillRule(int rule) {
        this.currentState.graphicHints &= ~FILL_RULE_MASK;
        this.currentState.graphicHints |= rule + -1 << FILL_RULE_SHIFT;
    }

    private GeneralPath createPathAWT(Path path) {
        GeneralPath pathAWT = new GeneralPath();
        PathData pathData = path.getPathData();
        int idx = 0;
        int i = 0;
        while (i < pathData.types.length) {
            switch (pathData.types[i]) {
                case 1: {
                    pathAWT.moveTo(pathData.points[idx++] + (float)this.transX, pathData.points[idx++] + (float)this.transY);
                    break;
                }
                case 2: {
                    pathAWT.lineTo(pathData.points[idx++] + (float)this.transX, pathData.points[idx++] + (float)this.transY);
                    break;
                }
                case 4: {
                    pathAWT.curveTo(pathData.points[idx++] + (float)this.transX, pathData.points[idx++] + (float)this.transY, pathData.points[idx++] + (float)this.transX, pathData.points[idx++] + (float)this.transY, pathData.points[idx++] + (float)this.transX, pathData.points[idx++] + (float)this.transY);
                    break;
                }
                case 3: {
                    pathAWT.quadTo(pathData.points[idx++] + (float)this.transX, pathData.points[idx++] + (float)this.transY, pathData.points[idx++] + (float)this.transX, pathData.points[idx++] + (float)this.transY);
                    break;
                }
                case 5: {
                    pathAWT.closePath();
                    break;
                }
                default: {
                    this.dispose();
                    SWT.error((int)5);
                }
            }
            ++i;
        }
        int swtWindingRule = ((this.appliedState.graphicHints & FILL_RULE_MASK) >> FILL_RULE_SHIFT) - -1;
        if (swtWindingRule == 2) {
            pathAWT.setWindingRule(1);
        } else if (swtWindingRule == 1) {
            pathAWT.setWindingRule(0);
        } else {
            SWT.error((int)5);
        }
        return pathAWT;
    }

    public RenderedImage drawRenderedImage(RenderedImage srcImage, Rectangle rect, RenderingListener listener) {
        RenderInfo info = srcImage.getRenderInfo();
        info.setValues(rect.width, rect.height, info.shouldMaintainAspectRatio(), info.shouldAntiAlias(), info.getBackgroundColor(), info.getForegroundColor());
        RenderedImage img = srcImage.getNewRenderedImage(info);
        BufferedImage bufImg = (BufferedImage)img.getAdapter(BufferedImage.class);
        if (bufImg == null) {
            bufImg = ImageConverter.convert(img.getSWTImage());
        }
        int x = rect.x + this.transX;
        int y = rect.y + this.transY + rect.height - bufImg.getHeight();
        this.checkState();
        this.getGraphics2D().drawImage(bufImg, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), null);
        return img;
    }

    public boolean shouldAllowDelayRender() {
        return false;
    }

    public Dimension getMaximumRenderSize() {
        return null;
    }

    protected Point getTranslationOffset() {
        return new Point(this.transX, this.transY);
    }

    public int getAntialias() {
        Object antiAlias = this.getGraphics2D().getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (antiAlias != null) {
            if (antiAlias.equals(RenderingHints.VALUE_ANTIALIAS_ON)) {
                return 1;
            }
            if (antiAlias.equals(RenderingHints.VALUE_ANTIALIAS_OFF)) {
                return 0;
            }
            if (antiAlias.equals(RenderingHints.VALUE_ANTIALIAS_DEFAULT)) {
                return -1;
            }
        }
        return -1;
    }

    public void setAntialias(int value) {
        if (value == 1) {
            this.getGraphics2D().setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else if (value == 0) {
            this.getGraphics2D().setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.setAdvanced(true);
    }

    public int getAlpha() {
        return this.swtGraphics.getAlpha();
    }

    public void setAlpha(int alpha) {
        this.swtGraphics.setAlpha(alpha);
        this.currentState.alpha = alpha;
        Composite composite = this.getGraphics2D().getComposite();
        if (composite instanceof AlphaComposite) {
            AlphaComposite newComposite = AlphaComposite.getInstance(((AlphaComposite)composite).getRule(), (float)alpha / 255.0f);
            this.getGraphics2D().setComposite(newComposite);
        }
    }

    protected BasicStroke getStroke() {
        return this.stroke;
    }

    protected void setStroke(BasicStroke stroke) {
        this.stroke = stroke;
        this.getGraphics2D().setStroke(stroke);
    }

    private Stroke createStroke() {
        int awt_join;
        int awt_cap;
        float[] awt_dash;
        float factor = this.currentState.lineAttributes.width > 0.0f ? this.currentState.lineAttributes.width : 3.0f;
        switch (this.currentState.lineAttributes.style) {
            case 2: {
                awt_dash = new float[]{factor * 6.0f, factor * 3.0f};
                break;
            }
            case 4: {
                awt_dash = new float[]{factor * 3.0f, factor, factor, factor};
                break;
            }
            case 5: {
                awt_dash = new float[]{factor * 3.0f, factor, factor, factor, factor, factor};
                break;
            }
            case 3: {
                awt_dash = new float[]{factor, factor};
                break;
            }
            case 6: {
                awt_dash = this.currentState.lineAttributes.dash;
                break;
            }
            default: {
                awt_dash = null;
            }
        }
        switch (this.currentState.lineAttributes.cap) {
            case 1: {
                awt_cap = 0;
                break;
            }
            case 2: {
                awt_cap = 1;
                break;
            }
            case 3: {
                awt_cap = 2;
                break;
            }
            default: {
                awt_cap = 0;
            }
        }
        switch (this.currentState.lineAttributes.join) {
            case 3: {
                awt_join = 2;
                break;
            }
            case 1: {
                awt_join = 0;
                break;
            }
            case 2: {
                awt_join = 1;
                break;
            }
            default: {
                awt_join = 0;
            }
        }
        this.stroke = new BasicStroke(this.currentState.lineAttributes.width != 0.0f ? this.currentState.lineAttributes.width : 1.0f, awt_cap, awt_join, this.currentState.lineAttributes.miterLimit, awt_dash, this.currentState.lineAttributes.dashOffset);
        return this.stroke;
    }

    public boolean getAdvanced() {
        return (this.currentState.graphicHints & ADVANCED_GRAPHICS_MASK) != 0;
    }

    public void setAdvanced(boolean value) {
        this.currentState.graphicHints = value ? (this.currentState.graphicHints |= ADVANCED_GRAPHICS_MASK) : (this.currentState.graphicHints &= ~ADVANCED_GRAPHICS_MASK);
    }

    public void clipPath(Path path) {
        if (((this.appliedState.graphicHints ^ this.currentState.graphicHints) & FILL_RULE_MASK) != 0) {
            this.appliedState.graphicHints ^= FILL_RULE_MASK;
        }
        this.setClip(path);
        this.getGraphics2D().clipRect(this.relativeClipRegion.x + this.transX, this.relativeClipRegion.y + this.transY, this.relativeClipRegion.width, this.relativeClipRegion.height);
        java.awt.Rectangle bounds = this.getGraphics2D().getClip().getBounds();
        this.relativeClipRegion = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    private static class State {
        public int translateX = 0;
        public int translateY = 0;
        public int clipX = 0;
        public int clipY = 0;
        public int clipW = 0;
        public int clipH = 0;
        public Font font;
        public boolean XorMode = false;
        public org.eclipse.swt.graphics.Color fgColor;
        public org.eclipse.swt.graphics.Color bgColor;
        public int alpha;
        public LineAttributes lineAttributes = new LineAttributes(1.0f);
        int graphicHints;

        private State() {
        }

        public void copyFrom(State state) {
            this.translateX = state.translateX;
            this.translateY = state.translateY;
            this.clipX = state.clipX;
            this.clipY = state.clipY;
            this.clipW = state.clipW;
            this.clipH = state.clipH;
            this.font = state.font;
            this.fgColor = state.fgColor;
            this.bgColor = state.bgColor;
            this.XorMode = state.XorMode;
            this.alpha = state.alpha;
            this.graphicHints = state.graphicHints;
            this.lineAttributes = SWTGraphics.clone((LineAttributes)state.lineAttributes);
        }
    }
}

