/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.render.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.figures.ScalableImageFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.WrapperNodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public abstract class AbstractImageEditPart
extends ShapeNodeEditPart {
    private RenderedImage renderedImage = null;
    ScalableImageFigure sif = null;

    public AbstractImageEditPart(View view) {
        super(view);
    }

    protected NodeFigure createNodeFigure() {
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getDiagramPreferencesHint().getPreferenceStore();
        boolean antiAlias = preferenceStore.getBoolean("Global.enableAntiAlias");
        this.sif = new ScalableImageFigure(this.getRenderedImage(), true, true, antiAlias);
        this.sif.setMaintainAspectRatio(false);
        return new WrapperNodeFigure((IFigure)this.sif);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshImage();
    }

    protected void refreshImage() {
        this.renderedImage = null;
        this.getFigure().invalidate();
    }

    protected void refreshEnableAntiAlias() {
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getDiagramPreferencesHint().getPreferenceStore();
        boolean antiAlias = preferenceStore.getBoolean("Global.enableAntiAlias");
        this.sif.setAntiAlias(antiAlias);
    }

    protected abstract RenderedImage regenerateImageFromSource();

    public final RenderedImage getRenderedImage() {
        RenderedImage img;
        if (this.renderedImage == null && (img = this.regenerateImageFromSource()) != null && img.getSWTImage() != null) {
            this.renderedImage = img;
        }
        return this.renderedImage;
    }

    protected class PreferencePropertyChangeListener
    implements IPropertyChangeListener {
        protected PreferencePropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("Global.enableAntiAlias")) {
                AbstractImageEditPart.this.refreshEnableAntiAlias();
            }
        }
    }
}

