/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.ui.pde.internal.wizards;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.gmf.examples.runtime.ui.pde.internal.GmfExamplesPlugin;
import org.eclipse.gmf.examples.runtime.ui.pde.internal.l10n.ResourceManager;
import org.eclipse.gmf.examples.runtime.ui.pde.util.Log;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class ProjectUnzipperNewWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private static final String ORG_ECLIPSE_JDT_CORE_JAVANATURE = "org.eclipse.jdt.core.javanature";
    private static final String ORG_ECLIPSE_PDE_PLUGIN_NATURE = "org.eclipse.pde.PluginNature";
    private static String KEY_CREATING_PROJECT = "monitor.creatingProject";
    private static String KEY_UNZIPPING_PROJECT = "monitor.unzippingProject";
    private WizardNewProjectCreationPage wizardNewProjectCreationPage;
    private String pageName;
    private String pageTitle;
    private String pageDescription;
    private String pageProjectName;
    private URL[] projectZipURL;
    private String[] nameFormats;
    private IConfigurationElement config;

    public ProjectUnzipperNewWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        try {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) throws InterruptedException {
                    try {
                        try {
                            monitor.beginTask(ResourceManager.getI18NString(KEY_CREATING_PROJECT), 120);
                            IPath projectPath = ProjectUnzipperNewWizard.this.wizardNewProjectCreationPage.getLocationPath();
                            int i = 0;
                            while (i < ProjectUnzipperNewWizard.this.nameFormats.length) {
                                IProjectDescription desc;
                                String projectName = MessageFormat.format(ProjectUnzipperNewWizard.this.nameFormats[i], ProjectUnzipperNewWizard.this.wizardNewProjectCreationPage.getProjectName());
                                String projectFolder = String.valueOf(projectPath.toOSString()) + File.separator + projectName;
                                File projectFolderFile = new File(projectFolder);
                                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                                IProject project = workspace.getRoot().getProject(projectName);
                                if (!project.exists()) {
                                    projectFolderFile.mkdirs();
                                    monitor.worked(10);
                                    ProjectUnzipperNewWizard.this.extractProject(projectFolderFile, ProjectUnzipperNewWizard.this.getProjectZipURL()[i], (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                                    if (monitor.isCanceled()) {
                                        throw new InterruptedException();
                                    }
                                    if (projectPath.equals((Object)workspace.getRoot().getLocation())) {
                                        project.create(monitor);
                                    } else {
                                        desc = workspace.newProjectDescription(project.getName());
                                        desc.setLocation((IPath)new Path(projectFolder));
                                        project.create(desc, monitor);
                                    }
                                }
                                project.open(monitor);
                                ProjectUnzipperNewWizard.this.renameProject(project, projectName);
                                desc = workspace.newProjectDescription(project.getName());
                                desc.setNatureIds(new String[]{ProjectUnzipperNewWizard.ORG_ECLIPSE_PDE_PLUGIN_NATURE, ProjectUnzipperNewWizard.ORG_ECLIPSE_JDT_CORE_JAVANATURE});
                                project.setDescription(desc, monitor);
                                monitor.worked(10);
                                if (monitor.isCanceled()) {
                                    throw new InterruptedException();
                                }
                                ++i;
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        catch (CoreException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.getConfigurationElement());
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (Exception e) {
            Log.error((Plugin)GmfExamplesPlugin.getDefault(), 10, e.getMessage(), e);
            return false;
        }
        return true;
    }

    private void extractProject(File projectFolderFile, URL url, IProgressMonitor monitor) throws FileNotFoundException, IOException, InterruptedException {
        URL urlZipLocal = FileLocator.toFileURL((URL)url);
        ZipFile zipFile = new ZipFile(urlZipLocal.getPath());
        try {
            monitor.beginTask(ResourceManager.getI18NString(KEY_UNZIPPING_PROJECT), zipFile.size());
            this.unzip(zipFile, projectFolderFile, monitor);
        }
        finally {
            zipFile.close();
            monitor.done();
        }
    }

    private void unzip(ZipFile zipFile, File projectFolderFile, IProgressMonitor monitor) throws IOException, FileNotFoundException, InterruptedException {
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            block18: {
                ZipEntry zipEntry = e.nextElement();
                File file = new File(projectFolderFile, zipEntry.getName());
                if (!zipEntry.isDirectory()) {
                    int len;
                    Object[] buffer;
                    Closeable os;
                    Closeable is;
                    Path path;
                    File parentFile = file.getParentFile();
                    if (parentFile != null && !parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    if ((path = new Path(file.getPath())).getFileExtension().equals("java")) {
                        is = null;
                        os = null;
                        try {
                            is = new InputStreamReader(zipFile.getInputStream(zipEntry), "ISO-8859-1");
                            os = new OutputStreamWriter((OutputStream)new FileOutputStream(file), ResourcesPlugin.getEncoding());
                            buffer = new char[102400];
                            while (true) {
                                if ((len = ((Reader)is).read((char[])buffer)) < 0) {
                                    break block18;
                                }
                                ((OutputStreamWriter)os).write((char[])buffer, 0, len);
                            }
                        }
                        finally {
                            if (is != null) {
                                ((InputStreamReader)is).close();
                            }
                            if (os != null) {
                                ((OutputStreamWriter)os).close();
                            }
                        }
                    }
                    is = null;
                    os = null;
                    try {
                        is = zipFile.getInputStream(zipEntry);
                        os = new FileOutputStream(file);
                        buffer = new byte[102400];
                        while ((len = ((InputStream)is).read((byte[])buffer)) >= 0) {
                            ((OutputStream)os).write((byte[])buffer, 0, len);
                        }
                    }
                    finally {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                        if (os != null) {
                            ((OutputStream)os).close();
                        }
                    }
                }
            }
            monitor.worked(1);
            if (!monitor.isCanceled()) continue;
            throw new InterruptedException();
        }
    }

    private void renameProject(IProject project, String projectName) throws CoreException {
        IProjectDescription description = project.getDescription();
        description.setName(projectName);
        project.move(description, 33, null);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.wizardNewProjectCreationPage = new WizardNewProjectCreationPage(this.getPageName());
        this.wizardNewProjectCreationPage.setTitle(this.getPageTitle());
        this.wizardNewProjectCreationPage.setDescription(this.getPageDescription());
        this.wizardNewProjectCreationPage.setInitialProjectName(this.getPageProjectName());
        this.addPage((IWizardPage)this.wizardNewProjectCreationPage);
    }

    private String getPageName() {
        return this.pageName;
    }

    private String getPageTitle() {
        return this.pageTitle;
    }

    private String getPageDescription() {
        return this.pageDescription;
    }

    private String getPageProjectName() {
        return this.pageProjectName;
    }

    private URL[] getProjectZipURL() {
        return this.projectZipURL;
    }

    private IConfigurationElement getConfigurationElement() {
        return this.config;
    }

    public void setInitializationData(IConfigurationElement configIn, String propertyName, Object data) throws CoreException {
        this.config = configIn;
        this.pageName = this.config.getAttribute("name");
        this.pageTitle = this.config.getAttribute("projectPageTitle");
        this.pageDescription = this.config.getAttribute("projectPageDescription");
        this.pageProjectName = this.config.getAttribute("projectName");
        ArrayList<String> nameFormatsL = new ArrayList<String>();
        ArrayList<URL> zipURLs = new ArrayList<URL>();
        IConfigurationElement[] projectElements = this.config.getChildren("project");
        int i = 0;
        while (i < projectElements.length) {
            zipURLs.add(GmfExamplesPlugin.getDefault().find((IPath)new Path(projectElements[i].getAttribute("zipPath"))));
            if (projectElements[i].getAttribute("nameFormat") == null) {
                nameFormatsL.add("{0}");
            } else {
                nameFormatsL.add(projectElements[i].getAttribute("nameFormat"));
            }
            ++i;
        }
        this.projectZipURL = new URL[zipURLs.size()];
        zipURLs.toArray(this.projectZipURL);
        assert (this.projectZipURL.length > 0);
        this.nameFormats = new String[nameFormatsL.size()];
        nameFormatsL.toArray(this.nameFormats);
        assert (this.nameFormats.length > 0);
        assert (this.projectZipURL.length == this.nameFormats.length);
    }
}

