/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.callhierarchy;

import org.eclipse.handly.internal.ui.Activator;
import org.eclipse.handly.ui.callhierarchy.ICallLocation;
import org.eclipse.handly.ui.callhierarchy.Messages;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class LocationTableLabelProvider
extends BaseLabelProvider
implements ITableLabelProvider {
    private static final Column[] COLUMNS = Column.values();

    public Image getColumnImage(Object element, int columnIndex) {
        if (this.getColumn(columnIndex) == Column.ICON) {
            return Activator.getImage("org.eclipse.handly.ui/obj16/occ_match.png");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof ICallLocation) {
            ICallLocation callLocation = (ICallLocation)element;
            Column column = this.getColumn(columnIndex);
            if (column == Column.LINE) {
                int lineNumber = callLocation.getLineNumber();
                if (lineNumber == -1) {
                    return Messages.LocationTableLabelProvider_unknownLineNumber;
                }
                return String.valueOf(lineNumber + 1);
            }
            if (column == Column.INFO) {
                return LocationTableLabelProvider.removeWhitespaceOutsideStringLiterals(callLocation.getCallText());
            }
        }
        return "";
    }

    protected Column getColumn(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= COLUMNS.length) {
            return null;
        }
        return COLUMNS[columnIndex];
    }

    private static String removeWhitespaceOutsideStringLiterals(String s) {
        StringBuilder sb = new StringBuilder();
        boolean withinString = false;
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == '\"') {
                boolean bl = withinString = !withinString;
            }
            if (withinString) {
                sb.append(ch);
            } else if (Character.isWhitespace(ch)) {
                if (sb.length() == 0 || !Character.isWhitespace(sb.charAt(sb.length() - 1))) {
                    if (ch != ' ') {
                        ch = ' ';
                    }
                    sb.append(ch);
                }
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    protected static enum Column {
        ICON,
        LINE,
        INFO;

    }
}

