/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.buffer;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.buffer.Buffer;
import org.eclipse.handly.buffer.BufferChange;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.buffer.Messages;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.NonExpiringSnapshot;
import org.eclipse.handly.snapshot.StaleSnapshotException;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public final class ChildBuffer
extends Buffer {
    private final IBuffer parent;
    private volatile ISnapshot base;

    public ChildBuffer(IBuffer parent) {
        this.parent = parent;
        if (this.parent == null) {
            throw new IllegalArgumentException();
        }
        NonExpiringSnapshot snapshot = new NonExpiringSnapshot(parent);
        this.initWithContents(snapshot.getContents());
        this.base = snapshot.getWrappedSnapshot();
        parent.addRef();
    }

    @Override
    public void addRef() {
        this.parent.addRef();
    }

    @Override
    public void release() {
        this.parent.release();
    }

    @Override
    protected void doSave(IContext context, IProgressMonitor monitor) throws CoreException {
        try {
            String baseContents = this.base.getContents();
            if (baseContents == null) {
                throw new StaleSnapshotException();
            }
            BufferChange change = new BufferChange((TextEdit)new ReplaceEdit(0, baseContents.length(), this.getDocument().get()));
            change.setBase(this.base);
            IBufferChange undoChange = this.parent.applyChange(change, monitor);
            this.base = undoChange.getBase();
        }
        catch (StaleSnapshotException e) {
            throw new CoreException(Activator.createErrorStatus(Messages.ChildBuffer_Parent_has_been_modified_and_may_not_be_overwritten, e));
        }
    }
}

