/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.ui.DefaultEditorUtility;
import org.eclipse.handly.ui.EditorUtility;
import org.eclipse.handly.ui.IInputElementProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.ILinkHelper;

public abstract class LinkHelper
implements ILinkHelper {
    public IStructuredSelection findSelection(IEditorInput editorInput) {
        IElement inputElement = this.getInputElementProvider().getElement(editorInput);
        if (inputElement != null) {
            IElement element;
            IStructuredSelection currentSelection;
            IViewPart navigatorView = this.getNavigatorView();
            if (navigatorView != null && (currentSelection = (IStructuredSelection)navigatorView.getSite().getSelectionProvider().getSelection()) != null && currentSelection.size() == 1 && (element = (IElement)Adapters.adapt((Object)currentSelection.getFirstElement(), IElement.class)) != null && Elements.isAncestorOf((IElement)inputElement, (IElement)Elements.getParent((IElement)element))) {
                return currentSelection;
            }
            return new StructuredSelection((Object)inputElement);
        }
        IFile file = (IFile)Adapters.adapt((Object)editorInput, IFile.class);
        if (file != null) {
            return new StructuredSelection((Object)file);
        }
        return null;
    }

    public void activateEditor(IWorkbenchPage page, IStructuredSelection selection) {
        IEditorPart editor;
        if (selection == null || selection.size() != 1) {
            return;
        }
        Object element = selection.getFirstElement();
        EditorUtility editorUtility = this.getEditorUtility();
        IEditorReference reference = editorUtility.findEditor(page, element);
        if (reference != null && (editor = reference.getEditor(true)) != null && editor != page.getActiveEditor()) {
            page.bringToTop((IWorkbenchPart)editor);
            editorUtility.revealElement(editor, element);
        }
    }

    protected abstract IInputElementProvider getInputElementProvider();

    protected abstract IViewPart getNavigatorView();

    protected EditorUtility getEditorUtility() {
        return DefaultEditorUtility.INSTANCE;
    }
}

