/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.buffer.Buffer;
import org.eclipse.handly.buffer.BufferChange;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.junit.NoJobsWorkspaceTestCase;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.impl.ISourceFileImplExtension;
import org.eclipse.handly.model.impl.support.INotificationManager;
import org.eclipse.handly.model.impl.support.NotificationManager;
import org.eclipse.handly.model.impl.support.SimpleModelManager;
import org.eclipse.handly.model.impl.support.SimpleSourceConstruct;
import org.eclipse.handly.model.impl.support.SimpleSourceFile;
import org.eclipse.handly.model.impl.support.SourceElementBody;
import org.eclipse.handly.util.Property;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

public class WorkingCopyNotificationTest
extends NoJobsWorkspaceTestCase {
    private SimpleSourceFile sourceFile;
    private SimpleSourceConstruct aChild;
    private List<IElementChangeEvent> events;

    protected void setUp() throws Exception {
        super.setUp();
        NotificationManager notificationManager = new NotificationManager();
        notificationManager.addElementChangeListener(event -> {
            boolean bl = this.events.add(event);
        });
        SimpleModelManager modelManager = new SimpleModelManager();
        modelManager.model.context = Contexts.of(INotificationManager.class, (Object)notificationManager);
        IFile file = this.setUpProject("Test001").getFile("a.foo");
        this.sourceFile = new SimpleSourceFile(null, file.getName(), file, modelManager){

            @Override
            public void buildSourceStructure_(IContext context, IProgressMonitor monitor) throws CoreException {
                SourceElementBody body = new SourceElementBody();
                if ("A".equals(context.get(SOURCE_CONTENTS))) {
                    body.addChild((IElement)WorkingCopyNotificationTest.this.aChild);
                    ((Map)context.get(NEW_ELEMENTS)).put(WorkingCopyNotificationTest.this.aChild, new SourceElementBody());
                }
                ((Map)context.get(NEW_ELEMENTS)).put(this, body);
            }
        };
        this.aChild = this.sourceFile.getChild("A");
        this.events = new ArrayList<IElementChangeEvent>();
    }

    public void test1() throws Exception {
        this.sourceFile.reconcile_(Contexts.EMPTY_CONTEXT, null);
        WorkingCopyNotificationTest.assertTrue((boolean)this.events.isEmpty());
    }

    public void test2() throws Exception {
        this.sourceFile.becomeWorkingCopy_(Contexts.EMPTY_CONTEXT, null);
        try {
            WorkingCopyNotificationTest.assertEquals((int)1, (int)this.events.size());
            this.assertEvent(0, 1, "[Working copy] a.foo[*]: {WORKING COPY}");
            this.sourceFile.reconcile_(Contexts.EMPTY_CONTEXT, null);
            WorkingCopyNotificationTest.assertEquals((int)1, (int)this.events.size());
            Throwable throwable = null;
            Object var2_3 = null;
            try (IBuffer buffer = this.sourceFile.getBuffer_(Contexts.EMPTY_CONTEXT, null);){
                buffer.applyChange((IBufferChange)new BufferChange((TextEdit)new InsertEdit(0, "A")), null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.sourceFile.reconcile_(Contexts.EMPTY_CONTEXT, null);
            WorkingCopyNotificationTest.assertEquals((int)2, (int)this.events.size());
            this.assertEvent(1, 2, "[Working copy] a.foo[*]: {CHILDREN | CONTENT | FINE GRAINED}\n  A[+]: {}");
        }
        finally {
            this.sourceFile.releaseWorkingCopy_();
        }
        WorkingCopyNotificationTest.assertEquals((int)3, (int)this.events.size());
        this.assertEvent(2, 1, "a.foo[*]: {WORKING COPY}");
    }

    public void test3() throws Exception {
        this.sourceFile.becomeWorkingCopy_(Contexts.of((Property)ISourceFileImplExtension.WORKING_COPY_BUFFER, (Object)new Buffer("A")), null);
        try {
            WorkingCopyNotificationTest.assertEquals((int)2, (int)this.events.size());
            this.assertEvent(0, 1, "[Working copy] a.foo[*]: {WORKING COPY}");
            this.assertEvent(1, 2, "[Working copy] a.foo[*]: {CHILDREN | CONTENT | FINE GRAINED}\n  A[+]: {}");
            this.sourceFile.reconcile_(Contexts.of((Property)Elements.FORCE_RECONCILING, (Object)true), null);
            WorkingCopyNotificationTest.assertEquals((int)2, (int)this.events.size());
            Throwable throwable = null;
            Object var2_3 = null;
            try (IBuffer buffer = this.sourceFile.getBuffer_(Contexts.EMPTY_CONTEXT, null);){
                buffer.applyChange((IBufferChange)new BufferChange((TextEdit)new DeleteEdit(0, 1)), null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.sourceFile.reconcile_(Contexts.EMPTY_CONTEXT, null);
            WorkingCopyNotificationTest.assertEquals((int)3, (int)this.events.size());
            this.assertEvent(2, 2, "[Working copy] a.foo[*]: {CHILDREN | CONTENT | FINE GRAINED}\n  A[-]: {}");
        }
        finally {
            this.sourceFile.releaseWorkingCopy_();
        }
        WorkingCopyNotificationTest.assertEquals((int)4, (int)this.events.size());
        this.assertEvent(3, 1, "a.foo[*]: {WORKING COPY}");
    }

    public void test4() throws Exception {
        this.sourceFile.getFile_().delete(true, null);
        this.sourceFile.becomeWorkingCopy_(Contexts.EMPTY_CONTEXT, null);
        try {
            WorkingCopyNotificationTest.assertEquals((int)1, (int)this.events.size());
            this.assertEvent(0, 1, "[Working copy] a.foo[+]: {WORKING COPY}");
        }
        finally {
            this.sourceFile.releaseWorkingCopy_();
        }
        WorkingCopyNotificationTest.assertEquals((int)2, (int)this.events.size());
        this.assertEvent(1, 1, "a.foo[-]: {WORKING COPY}");
    }

    private void assertEvent(int index, int type, String expectedDelta) {
        IElementChangeEvent event = this.events.get(index);
        WorkingCopyNotificationTest.assertEquals((int)type, (int)event.getType());
        WorkingCopyNotificationTest.assertEquals((String)expectedDelta, (String)event.getDeltas()[0].toString());
    }
}

