/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.viewer;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.ui.Activator;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.ui.viewer.DeferredTreeContentProvider;
import org.eclipse.handly.util.ICollector;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.IElementCollector;

public class DeferredElementTreeContentProvider
extends DeferredTreeContentProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];

    public DeferredElementTreeContentProvider(AbstractTreeViewer viewer, IWorkbenchPartSite site) {
        super(viewer, site);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (this.shouldDefer(parentElement)) {
            return this.getDeferredTreeContentManager().getChildren(parentElement);
        }
        return this.getImmediateChildren(parentElement);
    }

    public Object getParent(Object element) {
        if (element instanceof IElement) {
            return Elements.getParent((IElement)((IElement)element));
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (this.shouldDefer(element)) {
            return this.getDeferredTreeContentManager().mayHaveChildren(element);
        }
        return this.getImmediateChildren(element).length > 0;
    }

    protected boolean shouldDefer(Object element) {
        return element instanceof ISourceFile && !Elements.isWorkingCopy((ISourceFile)((ISourceFile)element));
    }

    protected Object[] getImmediateChildren(Object parentElement) {
        if (parentElement instanceof IElement) {
            try {
                return Elements.getChildren((IElement)((IElement)parentElement));
            }
            catch (CoreException e) {
                Activator.logError(e);
            }
        }
        return NO_CHILDREN;
    }

    @Override
    protected void fetchDeferredChildren(Object parentElement, final IElementCollector collector, IProgressMonitor monitor) {
        try {
            if (parentElement instanceof IElement) {
                try {
                    Elements.fetchChildren((IElement)((IElement)parentElement), (IContext)Contexts.EMPTY_CONTEXT, (ICollector)new ICollector<Object>(){

                        public void add(Object e) {
                            collector.add(e, null);
                        }

                        public void addAll(Collection<? extends Object> c) {
                            collector.add(c.toArray(), null);
                        }
                    }, (IProgressMonitor)monitor);
                }
                catch (CoreException e) {
                    Activator.logError(e);
                }
            }
        }
        finally {
            collector.done();
        }
    }

    @Override
    protected ISchedulingRule getRule(Object parentElement) {
        return null;
    }
}

