/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.queries.operations.reflective;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.timeaware.queries.RiskyFunction;
import org.eclipse.hawk.timeaware.queries.TimeAwareEOLQueryEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeAwareNodeHistoryOperationContributor
extends OperationContributor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeAwareNodeHistoryOperationContributor.class);
    private TimeAwareEOLQueryEngine model;

    public TimeAwareNodeHistoryOperationContributor(TimeAwareEOLQueryEngine q) {
        this.model = q;
    }

    public boolean contributesTo(Object target) {
        return target instanceof EOLQueryEngine.GraphNodeWrapper && ((EOLQueryEngine.GraphNodeWrapper)target).getNode() instanceof ITimeAwareGraphNode;
    }

    public List<EOLQueryEngine.GraphNodeWrapper> getVersionsBetween(long fromInclusive, long toInclusive) throws EolRuntimeException {
        return this.getRelatedVersions(taNode -> taNode.getVersionsBetween(fromInclusive, toInclusive));
    }

    public List<EOLQueryEngine.GraphNodeWrapper> getVersionsFrom(long fromInclusive) throws EolRuntimeException {
        return this.getRelatedVersions(taNode -> taNode.getVersionsFrom(fromInclusive));
    }

    public List<EOLQueryEngine.GraphNodeWrapper> getVersionsUpTo(long toInclusive) throws EolRuntimeException {
        return this.getRelatedVersions(taNode -> taNode.getVersionsUpTo(toInclusive));
    }

    public EOLQueryEngine.GraphNodeWrapper travelInTime(long time) {
        return this.model.wrap((IGraphNode)this.castTarget(this.getTarget()).travelInTime(time));
    }

    private List<EOLQueryEngine.GraphNodeWrapper> getRelatedVersions(RiskyFunction<ITimeAwareGraphNode, List<ITimeAwareGraphNode>> f) throws EolRuntimeException {
        ITimeAwareGraphNode taNode = this.castTarget(this.getTarget());
        ArrayList<EOLQueryEngine.GraphNodeWrapper> results = new ArrayList<EOLQueryEngine.GraphNodeWrapper>();
        try {
            for (ITimeAwareGraphNode version : f.call(taNode)) {
                results.add(this.model.wrap((IGraphNode)version));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new EolRuntimeException(e.getMessage());
        }
        return results;
    }

    private ITimeAwareGraphNode castTarget(Object target) {
        return (ITimeAwareGraphNode)((EOLQueryEngine.GraphNodeWrapper)target).getNode();
    }
}

