/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.io.Serializable;
import java.util.Map;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;

public class SVNErrorCode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String myDescription;
    private int myCategory;
    private int myCode;
    private static final Map ourErrorCodes = new SVNHashMap();
    private static final int ERR_BASE = 120000;
    private static final int ERR_CATEGORY_SIZE = 5000;
    public static final int BAD_CATEGORY = 125000;
    public static final int XML_CATEGORY = 130000;
    public static final int IO_CATEGORY = 135000;
    public static final int STREAM_CATEGORY = 140000;
    public static final int NODE_CATEGORY = 145000;
    public static final int ENTRY_CATEGORY = 150000;
    public static final int WC_CATEGORY = 155000;
    public static final int FS_CATEGORY = 160000;
    public static final int REPOS_CATEGORY = 165000;
    public static final int RA_CATEGORY = 170000;
    public static final int RA_DAV_CATEGORY = 175000;
    public static final int RA_LOCAL_CATEGORY = 180000;
    public static final int SVNDIFF_CATEGORY = 185000;
    public static final int APMOD_CATEGORY = 190000;
    public static final int CLIENT_CATEGORY = 195000;
    public static final int MISC_CATEGORY = 200000;
    public static final int CL_CATEGORY = 205000;
    public static final int RA_SVN_CATEGORY = 210000;
    public static final int AUTHN_CATEGORY = 215000;
    public static final int AUTHZ_CATEGORY = 220000;
    public static final int DIFF_CATEGORY = 225000;
    public static final int RA_SERF_CATEGORY = 230000;
    public static final int MALFUNC_CATEGORY = 235000;
    public static final SVNErrorCode UNKNOWN = new SVNErrorCode(200000, 4900, "Unknown error");
    public static final SVNErrorCode IO_ERROR = new SVNErrorCode(200000, 4899, "Generic IO error");
    public static final SVNErrorCode BAD_CONTAINING_POOL = new SVNErrorCode(125000, 0, "Bad parent pool passed to svn_make_pool()");
    public static final SVNErrorCode BAD_FILENAME = new SVNErrorCode(125000, 1, "Bogus filename");
    public static final SVNErrorCode BAD_URL = new SVNErrorCode(125000, 2, "Bogus URL");
    public static final SVNErrorCode BAD_DATE = new SVNErrorCode(125000, 3, "Bogus date");
    public static final SVNErrorCode BAD_MIME_TYPE = new SVNErrorCode(125000, 4, "Bogus mime-type");
    public static final SVNErrorCode BAD_PROPERTY_VALUE = new SVNErrorCode(125000, 5, "Wrong or unexpected property value");
    public static final SVNErrorCode BAD_VERSION_FILE_FORMAT = new SVNErrorCode(125000, 6, "Version file format not correct");
    public static final SVNErrorCode BAD_RELATIVE_PATH = new SVNErrorCode(125000, 7, "Path is not an immediate child of the specified directory");
    public static final SVNErrorCode BAD_UUID = new SVNErrorCode(125000, 8, "Bogus UUID");
    public static final SVNErrorCode BAD_CONFIG_VALUE = new SVNErrorCode(125000, 9, "Invalid configuration value");
    public static final SVNErrorCode BAD_SERVER_SPECIFICATION = new SVNErrorCode(125000, 10, "Bogus server specification");
    public static final SVNErrorCode BAD_CHECKSUM_KIND = new SVNErrorCode(125000, 11, "Unsupported checksum type");
    public static final SVNErrorCode BAD_CHECKSUM_PARSE = new SVNErrorCode(125000, 12, "Invalid character in hex checksum");
    public static final SVNErrorCode XML_ATTRIB_NOT_FOUND = new SVNErrorCode(130000, 0, "No such XML tag attribute");
    public static final SVNErrorCode XML_MISSING_ANCESTRY = new SVNErrorCode(130000, 1, "<delta-pkg> is missing ancestry");
    public static final SVNErrorCode XML_UNKNOWN_ENCODING = new SVNErrorCode(130000, 2, "Unrecognized binary data encoding; can't decode");
    public static final SVNErrorCode XML_MALFORMED = new SVNErrorCode(130000, 3, "XML data was not well-formed");
    public static final SVNErrorCode XML_UNESCAPABLE_DATA = new SVNErrorCode(130000, 4, "Data cannot be safely XML-escaped");
    public static final SVNErrorCode IO_INCONSISTENT_EOL = new SVNErrorCode(135000, 0, "Inconsistent line ending style");
    public static final SVNErrorCode IO_UNKNOWN_EOL = new SVNErrorCode(135000, 1, "Unrecognized line ending style");
    public static final SVNErrorCode IO_CORRUPT_EOL = new SVNErrorCode(135000, 2, "Line endings other than expected");
    public static final SVNErrorCode IO_UNIQUE_NAMES_EXHAUSTED = new SVNErrorCode(135000, 3, "Ran out of unique names");
    public static final SVNErrorCode IO_PIPE_FRAME_ERROR = new SVNErrorCode(135000, 4, "Framing error in pipe protocol");
    public static final SVNErrorCode IO_PIPE_READ_ERROR = new SVNErrorCode(135000, 5, "Read error in pipe");
    public static final SVNErrorCode IO_WRITE_ERROR = new SVNErrorCode(135000, 6, "Write error");
    public static final SVNErrorCode STREAM_UNEXPECTED_EOF = new SVNErrorCode(140000, 0, "Unexpected EOF on stream");
    public static final SVNErrorCode STREAM_MALFORMED_DATA = new SVNErrorCode(140000, 1, "Malformed stream data");
    public static final SVNErrorCode STREAM_UNRECOGNIZED_DATA = new SVNErrorCode(140000, 2, "Unrecognized stream data");
    public static final SVNErrorCode NODE_UNKNOWN_KIND = new SVNErrorCode(145000, 0, "Unknown svn_node_kind");
    public static final SVNErrorCode NODE_UNEXPECTED_KIND = new SVNErrorCode(145000, 1, "Unexpected node kind found");
    public static final SVNErrorCode ENTRY_NOT_FOUND = new SVNErrorCode(150000, 0, "Can't find an entry");
    public static final SVNErrorCode ENTRY_EXISTS = new SVNErrorCode(150000, 2, "Entry already exists");
    public static final SVNErrorCode ENTRY_MISSING_REVISION = new SVNErrorCode(150000, 3, "Entry has no revision");
    public static final SVNErrorCode ENTRY_MISSING_URL = new SVNErrorCode(150000, 4, "Entry has no URL");
    public static final SVNErrorCode ENTRY_ATTRIBUTE_INVALID = new SVNErrorCode(150000, 5, "Entry has an invalid attribute");
    public static final SVNErrorCode ENTRY_FORBIDDEN = new SVNErrorCode(150000, 6, "Can't create an entry for a forbidden name");
    public static final SVNErrorCode WC_OBSTRUCTED_UPDATE = new SVNErrorCode(155000, 0, "Obstructed update");
    public static final SVNErrorCode WC_UNWIND_MISMATCH = new SVNErrorCode(155000, 1, "Mismatch popping the WC unwind stack");
    public static final SVNErrorCode WC_UNWIND_EMPTY = new SVNErrorCode(155000, 2, "Attempt to pop empty WC unwind stack");
    public static final SVNErrorCode WC_UNWIND_NOT_EMPTY = new SVNErrorCode(155000, 3, "Attempt to unlock with non-empty unwind stack");
    public static final SVNErrorCode WC_LOCKED = new SVNErrorCode(155000, 4, "Attempted to lock an already-locked dir");
    public static final SVNErrorCode WC_NOT_LOCKED = new SVNErrorCode(155000, 5, "Working copy not locked; this is probably a bug, please report");
    public static final SVNErrorCode WC_INVALID_LOCK = new SVNErrorCode(155000, 6, "Invalid lock");
    public static final SVNErrorCode WC_NOT_WORKING_COPY;
    public static final SVNErrorCode WC_NOT_DIRECTORY;
    public static final SVNErrorCode WC_NOT_FILE;
    public static final SVNErrorCode WC_BAD_ADM_LOG;
    public static final SVNErrorCode WC_PATH_NOT_FOUND;
    public static final SVNErrorCode WC_NOT_UP_TO_DATE;
    public static final SVNErrorCode WC_LEFT_LOCAL_MOD;
    public static final SVNErrorCode WC_SCHEDULE_CONFLICT;
    public static final SVNErrorCode WC_PATH_FOUND;
    public static final SVNErrorCode WC_FOUND_CONFLICT;
    public static final SVNErrorCode WC_CORRUPT;
    public static final SVNErrorCode WC_CORRUPT_TEXT_BASE;
    public static final SVNErrorCode WC_NODE_KIND_CHANGE;
    public static final SVNErrorCode WC_INVALID_OP_ON_CWD;
    public static final SVNErrorCode WC_BAD_ADM_LOG_START;
    public static final SVNErrorCode WC_UNSUPPORTED_FORMAT;
    public static final SVNErrorCode WC_BAD_PATH;
    public static final SVNErrorCode WC_INVALID_SCHEDULE;
    public static final SVNErrorCode WC_INVALID_RELOCATION;
    public static final SVNErrorCode WC_INVALID_SWITCH;
    public static final SVNErrorCode WC_MISMATCHED_CHANGELIST;
    public static final SVNErrorCode WC_CONFLICT_RESOLVER_FAILURE;
    public static final SVNErrorCode WC_COPYFROM_PATH_NOT_FOUND;
    public static final SVNErrorCode WC_CHANGELIST_MOVE;
    public static final SVNErrorCode WC_CANNOT_DELETE_FILE_EXTERNAL;
    public static final SVNErrorCode WC_CANNOT_MOVE_FILE_EXTERNAL;
    public static final SVNErrorCode WC_DB_ERROR;
    public static final SVNErrorCode WC_MISSING;
    public static final SVNErrorCode WC_NOT_SYMLINK;
    public static final SVNErrorCode WC_PATH_UNEXPECTED_STATUS;
    public static final SVNErrorCode WC_UPGRADE_REQUIRED;
    public static final SVNErrorCode WC_CLEANUP_REQUIRED;
    public static final SVNErrorCode WC_INVALID_OPERATION_DEPTH;
    public static final SVNErrorCode WC_PATH_ACCESS_DENIED;
    public static final SVNErrorCode WC_MIXED_REVISIONS;
    public static final SVNErrorCode WC_DUPLICATE_EXTERNALS_TARGET;
    public static final SVNErrorCode FS_GENERAL;
    public static final SVNErrorCode FS_CLEANUP;
    public static final SVNErrorCode FS_ALREADY_OPEN;
    public static final SVNErrorCode FS_NOT_OPEN;
    public static final SVNErrorCode FS_CORRUPT;
    public static final SVNErrorCode FS_PATH_SYNTAX;
    public static final SVNErrorCode FS_NO_SUCH_REVISION;
    public static final SVNErrorCode FS_NO_SUCH_TRANSACTION;
    public static final SVNErrorCode FS_NO_SUCH_ENTRY;
    public static final SVNErrorCode FS_NO_SUCH_REPRESENTATION;
    public static final SVNErrorCode FS_NO_SUCH_STRING;
    public static final SVNErrorCode FS_NO_SUCH_COPY;
    public static final SVNErrorCode FS_TRANSACTION_NOT_MUTABLE;
    public static final SVNErrorCode FS_NOT_FOUND;
    public static final SVNErrorCode FS_ID_NOT_FOUND;
    public static final SVNErrorCode FS_NOT_ID;
    public static final SVNErrorCode FS_NOT_DIRECTORY;
    public static final SVNErrorCode FS_NOT_FILE;
    public static final SVNErrorCode FS_NOT_SINGLE_PATH_COMPONENT;
    public static final SVNErrorCode FS_NOT_MUTABLE;
    public static final SVNErrorCode FS_ALREADY_EXISTS;
    public static final SVNErrorCode FS_ROOT_DIR;
    public static final SVNErrorCode FS_NOT_TXN_ROOT;
    public static final SVNErrorCode FS_NOT_REVISION_ROOT;
    public static final SVNErrorCode FS_CONFLICT;
    public static final SVNErrorCode FS_REP_CHANGED;
    public static final SVNErrorCode FS_REP_NOT_MUTABLE;
    public static final SVNErrorCode FS_MALFORMED_SKEL;
    public static final SVNErrorCode FS_TXN_OUT_OF_DATE;
    public static final SVNErrorCode FS_BERKELEY_DB;
    public static final SVNErrorCode FS_BERKELEY_DB_DEADLOCK;
    public static final SVNErrorCode FS_TRANSACTION_DEAD;
    public static final SVNErrorCode FS_TRANSACTION_NOT_DEAD;
    public static final SVNErrorCode FS_UNKNOWN_FS_TYPE;
    public static final SVNErrorCode FS_NO_USER;
    public static final SVNErrorCode FS_PATH_ALREADY_LOCKED;
    public static final SVNErrorCode FS_PATH_NOT_LOCKED;
    public static final SVNErrorCode FS_BAD_LOCK_TOKEN;
    public static final SVNErrorCode FS_NO_LOCK_TOKEN;
    public static final SVNErrorCode FS_LOCK_OWNER_MISMATCH;
    public static final SVNErrorCode FS_NO_SUCH_LOCK;
    public static final SVNErrorCode FS_LOCK_EXPIRED;
    public static final SVNErrorCode FS_OUT_OF_DATE;
    public static final SVNErrorCode FS_UNSUPPORTED_FORMAT;
    public static final SVNErrorCode FS_REP_BEING_WRITTEN;
    public static final SVNErrorCode FS_TXN_NAME_TOO_LONG;
    public static final SVNErrorCode FS_NO_SUCH_NODE_ORIGIN;
    public static final SVNErrorCode REPOS_LOCKED;
    public static final SVNErrorCode REPOS_HOOK_FAILURE;
    public static final SVNErrorCode REPOS_BAD_ARGS;
    public static final SVNErrorCode REPOS_NO_DATA_FOR_REPORT;
    public static final SVNErrorCode REPOS_BAD_REVISION_REPORT;
    public static final SVNErrorCode REPOS_UNSUPPORTED_VERSION;
    public static final SVNErrorCode REPOS_DISABLED_FEATURE;
    public static final SVNErrorCode REPOS_POST_COMMIT_HOOK_FAILED;
    public static final SVNErrorCode REPOS_POST_LOCK_HOOK_FAILED;
    public static final SVNErrorCode REPOS_POST_UNLOCK_HOOK_FAILED;
    public static final SVNErrorCode RA_ILLEGAL_URL;
    public static final SVNErrorCode RA_NOT_AUTHORIZED;
    public static final SVNErrorCode RA_UNKNOWN_AUTH;
    public static final SVNErrorCode RA_NOT_IMPLEMENTED;
    public static final SVNErrorCode RA_OUT_OF_DATE;
    public static final SVNErrorCode RA_NO_REPOS_UUID;
    public static final SVNErrorCode RA_UNSUPPORTED_ABI_VERSION;
    public static final SVNErrorCode RA_NOT_LOCKED;
    public static final SVNErrorCode RA_PARTIAL_REPLAY_NOT_SUPPORTED;
    public static final SVNErrorCode RA_UUID_MISMATCH;
    public static final SVNErrorCode RA_REPOS_ROOT_URL_MISMATCH;
    public static final SVNErrorCode RA_DAV_SOCK_INIT;
    public static final SVNErrorCode RA_DAV_CREATING_REQUEST;
    public static final SVNErrorCode RA_DAV_REQUEST_FAILED;
    public static final SVNErrorCode RA_DAV_OPTIONS_REQ_FAILED;
    public static final SVNErrorCode RA_DAV_PROPS_NOT_FOUND;
    public static final SVNErrorCode RA_DAV_ALREADY_EXISTS;
    public static final SVNErrorCode RA_DAV_INVALID_CONFIG_VALUE;
    public static final SVNErrorCode RA_DAV_PATH_NOT_FOUND;
    public static final SVNErrorCode RA_DAV_PROPPATCH_FAILED;
    public static final SVNErrorCode RA_DAV_MALFORMED_DATA;
    public static final SVNErrorCode RA_DAV_RESPONSE_HEADER_BADNESS;
    public static final SVNErrorCode RA_DAV_PRECONDITION_FAILED;
    public static final SVNErrorCode RA_DAV_METHOD_NOT_ALLOWED;
    public static final SVNErrorCode RA_DAV_RELOCATED;
    public static final SVNErrorCode RA_DAV_CONN_TIMEOUT;
    public static final SVNErrorCode RA_DAV_FORBIDDEN;
    public static final SVNErrorCode RA_LOCAL_REPOS_NOT_FOUND;
    public static final SVNErrorCode RA_LOCAL_REPOS_OPEN_FAILED;
    public static final SVNErrorCode RA_SVN_CMD_ERR;
    public static final SVNErrorCode RA_SVN_UNKNOWN_CMD;
    public static final SVNErrorCode RA_SVN_CONNECTION_CLOSED;
    public static final SVNErrorCode RA_SVN_IO_ERROR;
    public static final SVNErrorCode RA_SVN_MALFORMED_DATA;
    public static final SVNErrorCode RA_SVN_REPOS_NOT_FOUND;
    public static final SVNErrorCode RA_SVN_BAD_VERSION;
    public static final SVNErrorCode AUTHN_CREDS_UNAVAILABLE;
    public static final SVNErrorCode AUTHN_NO_PROVIDER;
    public static final SVNErrorCode AUTHN_PROVIDERS_EXHAUSTED;
    public static final SVNErrorCode AUTHN_CREDS_NOT_SAVED;
    public static final SVNErrorCode AUTHZ_ROOT_UNREADABLE;
    public static final SVNErrorCode AUTHZ_UNREADABLE;
    public static final SVNErrorCode AUTHZ_PARTIALLY_READABLE;
    public static final SVNErrorCode AUTHZ_INVALID_CONFIG;
    public static final SVNErrorCode AUTHZ_UNWRITABLE;
    public static final SVNErrorCode SVNDIFF_INVALID_HEADER;
    public static final SVNErrorCode SVNDIFF_CORRUPT_WINDOW;
    public static final SVNErrorCode SVNDIFF_BACKWARD_VIEW;
    public static final SVNErrorCode SVNDIFF_INVALID_OPS;
    public static final SVNErrorCode SVNDIFF_UNEXPECTED_END;
    public static final SVNErrorCode APMOD_MISSING_PATH_TO_FS;
    public static final SVNErrorCode APMOD_MALFORMED_URI;
    public static final SVNErrorCode APMOD_ACTIVITY_NOT_FOUND;
    public static final SVNErrorCode APMOD_BAD_BASELINE;
    public static final SVNErrorCode APMOD_CONNECTION_ABORTED;
    public static final SVNErrorCode CLIENT_VERSIONED_PATH_REQUIRED;
    public static final SVNErrorCode CLIENT_RA_ACCESS_REQUIRED;
    public static final SVNErrorCode CLIENT_BAD_REVISION;
    public static final SVNErrorCode CLIENT_DUPLICATE_COMMIT_URL;
    public static final SVNErrorCode CLIENT_IS_BINARY_FILE;
    public static final SVNErrorCode CLIENT_INVALID_EXTERNALS_DESCRIPTION;
    public static final SVNErrorCode CLIENT_MODIFIED;
    public static final SVNErrorCode CLIENT_IS_DIRECTORY;
    public static final SVNErrorCode CLIENT_REVISION_RANGE;
    public static final SVNErrorCode CLIENT_INVALID_RELOCATION;
    public static final SVNErrorCode CLIENT_REVISION_AUTHOR_CONTAINS_NEWLINE;
    public static final SVNErrorCode CLIENT_PROPERTY_NAME;
    public static final SVNErrorCode CLIENT_UNRELATED_RESOURCES;
    public static final SVNErrorCode CLIENT_MISSING_LOCK_TOKEN;
    public static final SVNErrorCode CLIENT_MULTIPLE_SOURCES_DISALLOWED;
    public static final SVNErrorCode CLIENT_NO_VERSIONED_PARENT;
    public static final SVNErrorCode CLIENT_NOT_READY_TO_MERGE;
    public static final SVNErrorCode CLIENT_FILE_EXTERNAL_OVERWRITE_VERSIONED;
    public static final SVNErrorCode CLIENT_BAD_STRIP_COUNT;
    public static final SVNErrorCode CLIENT_CYCLE_DETECTED;
    public static final SVNErrorCode CLIENT_MERGE_UPDATE_REQUIRED;
    public static final SVNErrorCode CLIENT_INVALID_MERGEINFO_NO_MERGETRACKING;
    public static final SVNErrorCode CLIENT_NO_LOCK_TOKEN;
    public static final SVNErrorCode CLIENT_FORBIDDEN_BY_SERVER;
    public static final SVNErrorCode BASE;
    public static final SVNErrorCode PLUGIN_LOAD_FAILURE;
    public static final SVNErrorCode MALFORMED_FILE;
    public static final SVNErrorCode INCOMPLETE_DATA;
    public static final SVNErrorCode INCORRECT_PARAMS;
    public static final SVNErrorCode UNVERSIONED_RESOURCE;
    public static final SVNErrorCode TEST_FAILED;
    public static final SVNErrorCode UNSUPPORTED_FEATURE;
    public static final SVNErrorCode BAD_PROP_KIND;
    public static final SVNErrorCode ILLEGAL_TARGET;
    public static final SVNErrorCode DELTA_MD5_CHECKSUM_ABSENT;
    public static final SVNErrorCode DIR_NOT_EMPTY;
    public static final SVNErrorCode EXTERNAL_PROGRAM;
    public static final SVNErrorCode SWIG_PY_EXCEPTION_SET;
    public static final SVNErrorCode CHECKSUM_MISMATCH;
    public static final SVNErrorCode CANCELLED;
    public static final SVNErrorCode INVALID_DIFF_OPTION;
    public static final SVNErrorCode PROPERTY_NOT_FOUND;
    public static final SVNErrorCode NO_AUTH_FILE_PATH;
    public static final SVNErrorCode VERSION_MISMATCH;
    public static final SVNErrorCode MERGE_INFO_PARSE_ERROR;
    public static final SVNErrorCode CEASE_INVOCATION;
    public static final SVNErrorCode REVISION_NUMBER_PARSE_ERROR;
    public static final SVNErrorCode ITER_BREAK;
    public static final SVNErrorCode UNKNOWN_CHANGELIST;
    public static final SVNErrorCode RESERVED_FILENAME_SPECIFIED;
    public static final SVNErrorCode UNKNOWN_CAPABILITY;
    public static final SVNErrorCode TEST_SKIPPED;
    public static final SVNErrorCode ATOMIC_INIT_FAILURE;
    public static final SVNErrorCode SQLITE_ERROR;
    public static final SVNErrorCode SQLITE_READONLY;
    public static final SVNErrorCode UNSUPPORTED_SCHEMA;
    public static final SVNErrorCode CL_ARG_PARSING_ERROR;
    public static final SVNErrorCode CL_INSUFFICIENT_ARGS;
    public static final SVNErrorCode CL_MUTUALLY_EXCLUSIVE_ARGS;
    public static final SVNErrorCode CL_ADM_DIR_RESERVED;
    public static final SVNErrorCode CL_LOG_MESSAGE_IS_VERSIONED_FILE;
    public static final SVNErrorCode CL_LOG_MESSAGE_IS_PATHNAME;
    public static final SVNErrorCode CL_COMMIT_IN_ADDED_DIR;
    public static final SVNErrorCode CL_NO_EXTERNAL_EDITOR;
    public static final SVNErrorCode CL_BAD_LOG_MESSAGE;
    public static final SVNErrorCode CL_UNNECESSARY_LOG_MESSAGE;
    public static final SVNErrorCode CL_NO_EXTERNAL_MERGE_TOOL;
    public static final SVNErrorCode CL_ERROR_PROCESSING_EXTERNALS;
    public static final SVNErrorCode ASSERTION_FAIL;
    public static final SVNErrorCode BAD_CHANGELIST_NAME;

    public static SVNErrorCode getErrorCode(int code) {
        SVNErrorCode errorCode = (SVNErrorCode)ourErrorCodes.get(new Integer(code));
        if (errorCode == null) {
            errorCode = UNKNOWN;
        }
        return errorCode;
    }

    protected SVNErrorCode(int category, int index, String description) {
        this.myCategory = category;
        this.myCode = category + index;
        this.myDescription = description;
        ourErrorCodes.put(new Integer(this.myCode), this);
    }

    public int getCode() {
        return this.myCode;
    }

    public int getCategory() {
        return this.myCategory;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public int hashCode() {
        return this.myCode;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != SVNErrorCode.class) {
            return false;
        }
        return this.myCode == ((SVNErrorCode)o).myCode;
    }

    public boolean isAuthentication() {
        return this == RA_NOT_AUTHORIZED || this == RA_UNKNOWN_AUTH || this.getCategory() == 220000 || this.getCategory() == 215000;
    }

    private Object readResolve() {
        return ourErrorCodes.get(new Integer(this.myCode));
    }

    public String toString() {
        return this.myCode + ": " + this.myDescription;
    }

    static {
        WC_NOT_DIRECTORY = WC_NOT_WORKING_COPY = new SVNErrorCode(155000, 7, "Path is not a working copy directory");
        WC_NOT_FILE = new SVNErrorCode(155000, 8, "Path is not a working copy file");
        WC_BAD_ADM_LOG = new SVNErrorCode(155000, 9, "Problem running log");
        WC_PATH_NOT_FOUND = new SVNErrorCode(155000, 10, "Can't find a working copy path");
        WC_NOT_UP_TO_DATE = new SVNErrorCode(155000, 11, "Working copy is not up-to-date");
        WC_LEFT_LOCAL_MOD = new SVNErrorCode(155000, 12, "Left locally modified or unversioned files");
        WC_SCHEDULE_CONFLICT = new SVNErrorCode(155000, 13, "Unmergeable scheduling requested on an entry");
        WC_PATH_FOUND = new SVNErrorCode(155000, 14, "Found a working copy path");
        WC_FOUND_CONFLICT = new SVNErrorCode(155000, 15, "A conflict in the working copy obstructs the current operation");
        WC_CORRUPT = new SVNErrorCode(155000, 16, "Working copy is corrupt");
        WC_CORRUPT_TEXT_BASE = new SVNErrorCode(155000, 17, "Working copy text base is corrupt");
        WC_NODE_KIND_CHANGE = new SVNErrorCode(155000, 18, "Cannot change node kind");
        WC_INVALID_OP_ON_CWD = new SVNErrorCode(155000, 19, "Invalid operation on the current working directory");
        WC_BAD_ADM_LOG_START = new SVNErrorCode(155000, 20, "Problem on first log entry in a working copy");
        WC_UNSUPPORTED_FORMAT = new SVNErrorCode(155000, 21, "Unsupported working copy format");
        WC_BAD_PATH = new SVNErrorCode(155000, 22, "Path syntax not supported in this context");
        WC_INVALID_SCHEDULE = new SVNErrorCode(155000, 23, "Invalid schedule");
        WC_INVALID_RELOCATION = new SVNErrorCode(155000, 24, "Invalid relocation");
        WC_INVALID_SWITCH = new SVNErrorCode(155000, 25, "Invalid switch");
        WC_MISMATCHED_CHANGELIST = new SVNErrorCode(155000, 26, "Changelist doesn't match");
        WC_CONFLICT_RESOLVER_FAILURE = new SVNErrorCode(155000, 27, "Conflict resolution failed");
        WC_COPYFROM_PATH_NOT_FOUND = new SVNErrorCode(155000, 28, "Failed to locate 'copyfrom' path in working copy");
        WC_CHANGELIST_MOVE = new SVNErrorCode(155000, 29, "Moving a path from one changelist to another");
        WC_CANNOT_DELETE_FILE_EXTERNAL = new SVNErrorCode(155000, 30, "Cannot delete a file external");
        WC_CANNOT_MOVE_FILE_EXTERNAL = new SVNErrorCode(155000, 31, "Cannot move a file external");
        WC_DB_ERROR = new SVNErrorCode(155000, 32, "Something's amiss with the wc sqlite database");
        WC_MISSING = new SVNErrorCode(155000, 33, "The working copy is missing");
        WC_NOT_SYMLINK = new SVNErrorCode(155000, 34, "The specified node is not a symlink");
        WC_PATH_UNEXPECTED_STATUS = new SVNErrorCode(155000, 35, "The specified path has an unexpected status");
        WC_UPGRADE_REQUIRED = new SVNErrorCode(155000, 36, "The working copy needs to be upgraded");
        WC_CLEANUP_REQUIRED = new SVNErrorCode(155000, 37, "Previous operation was interrupted; run 'svn cleanup'");
        WC_INVALID_OPERATION_DEPTH = new SVNErrorCode(155000, 38, "The operation can not be performed with the specified depth");
        WC_PATH_ACCESS_DENIED = new SVNErrorCode(155000, 39, "Couldn't open a working copy file because access was denied");
        WC_MIXED_REVISIONS = new SVNErrorCode(155000, 40, "Mixed-revision working copy was found but not expected");
        WC_DUPLICATE_EXTERNALS_TARGET = new SVNErrorCode(155000, 7, "Duplicate targets in svn:externals property");
        FS_GENERAL = new SVNErrorCode(160000, 0, "General filesystem error");
        FS_CLEANUP = new SVNErrorCode(160000, 1, "Error closing filesystem");
        FS_ALREADY_OPEN = new SVNErrorCode(160000, 2, "Filesystem is already open");
        FS_NOT_OPEN = new SVNErrorCode(160000, 3, "Filesystem is not open");
        FS_CORRUPT = new SVNErrorCode(160000, 4, "Filesystem is corrupt");
        FS_PATH_SYNTAX = new SVNErrorCode(160000, 5, "Invalid filesystem path syntax");
        FS_NO_SUCH_REVISION = new SVNErrorCode(160000, 6, "Invalid filesystem revision number");
        FS_NO_SUCH_TRANSACTION = new SVNErrorCode(160000, 7, "Invalid filesystem transaction name");
        FS_NO_SUCH_ENTRY = new SVNErrorCode(160000, 8, "Filesystem directory has no such entry");
        FS_NO_SUCH_REPRESENTATION = new SVNErrorCode(160000, 9, "Filesystem has no such representation");
        FS_NO_SUCH_STRING = new SVNErrorCode(160000, 10, "Filesystem has no such string");
        FS_NO_SUCH_COPY = new SVNErrorCode(160000, 11, "Filesystem has no such copy");
        FS_TRANSACTION_NOT_MUTABLE = new SVNErrorCode(160000, 12, "The specified transaction is not mutable");
        FS_NOT_FOUND = new SVNErrorCode(160000, 13, "Filesystem has no item");
        FS_ID_NOT_FOUND = new SVNErrorCode(160000, 14, "Filesystem has no such node-rev-id");
        FS_NOT_ID = new SVNErrorCode(160000, 15, "String does not represent a node or node-rev-id");
        FS_NOT_DIRECTORY = new SVNErrorCode(160000, 16, "Name does not refer to a filesystem directory");
        FS_NOT_FILE = new SVNErrorCode(160000, 17, "Name does not refer to a filesystem file");
        FS_NOT_SINGLE_PATH_COMPONENT = new SVNErrorCode(160000, 18, "Name is not a single path component");
        FS_NOT_MUTABLE = new SVNErrorCode(160000, 19, "Attempt to change immutable filesystem node");
        FS_ALREADY_EXISTS = new SVNErrorCode(160000, 20, "Item already exists in filesystem");
        FS_ROOT_DIR = new SVNErrorCode(160000, 21, "Attempt to remove or recreate fs root dir");
        FS_NOT_TXN_ROOT = new SVNErrorCode(160000, 22, "Object is not a transaction root");
        FS_NOT_REVISION_ROOT = new SVNErrorCode(160000, 23, "Object is not a revision root");
        FS_CONFLICT = new SVNErrorCode(160000, 24, "Merge conflict during commit");
        FS_REP_CHANGED = new SVNErrorCode(160000, 25, "A representation vanished or changed between reads");
        FS_REP_NOT_MUTABLE = new SVNErrorCode(160000, 26, "Tried to change an immutable representation");
        FS_MALFORMED_SKEL = new SVNErrorCode(160000, 27, "Malformed skeleton data");
        FS_TXN_OUT_OF_DATE = new SVNErrorCode(160000, 28, "Transaction is out of date");
        FS_BERKELEY_DB = new SVNErrorCode(160000, 29, "Berkeley DB error");
        FS_BERKELEY_DB_DEADLOCK = new SVNErrorCode(160000, 30, "Berkeley DB deadlock error");
        FS_TRANSACTION_DEAD = new SVNErrorCode(160000, 31, "Transaction is dead");
        FS_TRANSACTION_NOT_DEAD = new SVNErrorCode(160000, 32, "Transaction is not dead");
        FS_UNKNOWN_FS_TYPE = new SVNErrorCode(160000, 33, "Unknown FS type");
        FS_NO_USER = new SVNErrorCode(160000, 34, "No user associated with filesystem");
        FS_PATH_ALREADY_LOCKED = new SVNErrorCode(160000, 35, "Path is already locked");
        FS_PATH_NOT_LOCKED = new SVNErrorCode(160000, 36, "Path is not locked");
        FS_BAD_LOCK_TOKEN = new SVNErrorCode(160000, 37, "Lock token is incorrect");
        FS_NO_LOCK_TOKEN = new SVNErrorCode(160000, 38, "No lock token provided");
        FS_LOCK_OWNER_MISMATCH = new SVNErrorCode(160000, 39, "Username does not match lock owner");
        FS_NO_SUCH_LOCK = new SVNErrorCode(160000, 40, "Filesystem has no such lock");
        FS_LOCK_EXPIRED = new SVNErrorCode(160000, 41, "Lock has expired");
        FS_OUT_OF_DATE = new SVNErrorCode(160000, 42, "Item is out of date");
        FS_UNSUPPORTED_FORMAT = new SVNErrorCode(160000, 43, "Unsupported FS format");
        FS_REP_BEING_WRITTEN = new SVNErrorCode(160000, 44, "Representation is being written");
        FS_TXN_NAME_TOO_LONG = new SVNErrorCode(160000, 45, "The generated transaction name is too long");
        FS_NO_SUCH_NODE_ORIGIN = new SVNErrorCode(160000, 46, "Filesystem has no such node origin record");
        REPOS_LOCKED = new SVNErrorCode(165000, 0, "The repository is locked, perhaps for db recovery");
        REPOS_HOOK_FAILURE = new SVNErrorCode(165000, 1, "A repository hook failed");
        REPOS_BAD_ARGS = new SVNErrorCode(165000, 2, "Incorrect arguments supplied");
        REPOS_NO_DATA_FOR_REPORT = new SVNErrorCode(165000, 3, "A report cannot be generated because no data was supplied");
        REPOS_BAD_REVISION_REPORT = new SVNErrorCode(165000, 4, "Bogus revision report");
        REPOS_UNSUPPORTED_VERSION = new SVNErrorCode(165000, 5, "Unsupported repository version");
        REPOS_DISABLED_FEATURE = new SVNErrorCode(165000, 6, "Disabled repository feature");
        REPOS_POST_COMMIT_HOOK_FAILED = new SVNErrorCode(165000, 7, "Error running post-commit hook");
        REPOS_POST_LOCK_HOOK_FAILED = new SVNErrorCode(165000, 8, "Error running post-lock hook");
        REPOS_POST_UNLOCK_HOOK_FAILED = new SVNErrorCode(165000, 9, "Error running post-unlock hook");
        RA_ILLEGAL_URL = new SVNErrorCode(170000, 0, "Bad URL passed to RA layer");
        RA_NOT_AUTHORIZED = new SVNErrorCode(170000, 1, "Authorization failed");
        RA_UNKNOWN_AUTH = new SVNErrorCode(170000, 2, "Unknown authorization method");
        RA_NOT_IMPLEMENTED = new SVNErrorCode(170000, 3, "Repository access method not implemented");
        RA_OUT_OF_DATE = new SVNErrorCode(170000, 4, "Item is out-of-date");
        RA_NO_REPOS_UUID = new SVNErrorCode(170000, 5, "Repository has no UUID");
        RA_UNSUPPORTED_ABI_VERSION = new SVNErrorCode(170000, 6, "Unsupported RA plugin ABI version");
        RA_NOT_LOCKED = new SVNErrorCode(170000, 7, "Path is not locked");
        RA_PARTIAL_REPLAY_NOT_SUPPORTED = new SVNErrorCode(170000, 8, "Server can only replay from the root of a repository");
        RA_UUID_MISMATCH = new SVNErrorCode(170000, 9, "Repository UUID does not match expected UUID");
        RA_REPOS_ROOT_URL_MISMATCH = new SVNErrorCode(170000, 10, "Repository root URL does not match expected root URL");
        RA_DAV_SOCK_INIT = new SVNErrorCode(175000, 0, "RA layer failed to init socket layer");
        RA_DAV_CREATING_REQUEST = new SVNErrorCode(175000, 1, "RA layer failed to create HTTP request");
        RA_DAV_REQUEST_FAILED = new SVNErrorCode(175000, 2, "RA layer request failed");
        RA_DAV_OPTIONS_REQ_FAILED = new SVNErrorCode(175000, 3, "RA layer didn't receive requested OPTIONS info");
        RA_DAV_PROPS_NOT_FOUND = new SVNErrorCode(175000, 4, "RA layer failed to fetch properties");
        RA_DAV_ALREADY_EXISTS = new SVNErrorCode(175000, 5, "RA layer file already exists");
        RA_DAV_INVALID_CONFIG_VALUE = new SVNErrorCode(175000, 6, "Invalid configuration value");
        RA_DAV_PATH_NOT_FOUND = new SVNErrorCode(175000, 7, "HTTP Path Not Found");
        RA_DAV_PROPPATCH_FAILED = new SVNErrorCode(175000, 8, "Failed to execute WebDAV PROPPATCH");
        RA_DAV_MALFORMED_DATA = new SVNErrorCode(175000, 9, "Malformed network data");
        RA_DAV_RESPONSE_HEADER_BADNESS = new SVNErrorCode(175000, 10, "Unable to extract data from response header");
        RA_DAV_PRECONDITION_FAILED = new SVNErrorCode(175000, 14, "The server state conflicts with the requested preconditions");
        RA_DAV_METHOD_NOT_ALLOWED = new SVNErrorCode(175000, 15, "The URL doesn't allow the requested method");
        RA_DAV_RELOCATED = new SVNErrorCode(175000, 11, "Repository has been moved");
        RA_DAV_CONN_TIMEOUT = new SVNErrorCode(175000, 12, "Connection timed out");
        RA_DAV_FORBIDDEN = new SVNErrorCode(175000, 13, "Connection timed out");
        RA_LOCAL_REPOS_NOT_FOUND = new SVNErrorCode(180000, 0, "Couldn't find a repository");
        RA_LOCAL_REPOS_OPEN_FAILED = new SVNErrorCode(180000, 1, "Couldn't open a repository");
        RA_SVN_CMD_ERR = new SVNErrorCode(210000, 0, "Special code for wrapping server errors to report to client");
        RA_SVN_UNKNOWN_CMD = new SVNErrorCode(210000, 1, "Unknown svn protocol command");
        RA_SVN_CONNECTION_CLOSED = new SVNErrorCode(210000, 2, "Network connection closed unexpectedly");
        RA_SVN_IO_ERROR = new SVNErrorCode(210000, 3, "Network read/write error");
        RA_SVN_MALFORMED_DATA = new SVNErrorCode(210000, 4, "Malformed network data");
        RA_SVN_REPOS_NOT_FOUND = new SVNErrorCode(210000, 5, "Couldn't find a repository");
        RA_SVN_BAD_VERSION = new SVNErrorCode(210000, 6, "Client/server version mismatch");
        AUTHN_CREDS_UNAVAILABLE = new SVNErrorCode(215000, 0, "Credential data unavailable");
        AUTHN_NO_PROVIDER = new SVNErrorCode(215000, 1, "No authentication provider available");
        AUTHN_PROVIDERS_EXHAUSTED = new SVNErrorCode(215000, 2, "All authentication providers exhausted");
        AUTHN_CREDS_NOT_SAVED = new SVNErrorCode(215000, 3, "Credentials not saved");
        AUTHZ_ROOT_UNREADABLE = new SVNErrorCode(220000, 0, "Read access denied for root of edit");
        AUTHZ_UNREADABLE = new SVNErrorCode(220000, 1, "Item is not readable");
        AUTHZ_PARTIALLY_READABLE = new SVNErrorCode(220000, 2, "Item is partially readable");
        AUTHZ_INVALID_CONFIG = new SVNErrorCode(220000, 3, "Invalid authz configuration");
        AUTHZ_UNWRITABLE = new SVNErrorCode(220000, 4, "Item is not writable");
        SVNDIFF_INVALID_HEADER = new SVNErrorCode(185000, 0, "Svndiff data has invalid header");
        SVNDIFF_CORRUPT_WINDOW = new SVNErrorCode(185000, 1, "Svndiff data contains corrupt window");
        SVNDIFF_BACKWARD_VIEW = new SVNErrorCode(185000, 2, "Svndiff data contains backward-sliding source view");
        SVNDIFF_INVALID_OPS = new SVNErrorCode(185000, 3, "Svndiff data contains invalid instruction");
        SVNDIFF_UNEXPECTED_END = new SVNErrorCode(185000, 4, "Svndiff data ends unexpectedly");
        APMOD_MISSING_PATH_TO_FS = new SVNErrorCode(190000, 0, "Apache has no path to an SVN filesystem");
        APMOD_MALFORMED_URI = new SVNErrorCode(190000, 1, "Apache got a malformed URI");
        APMOD_ACTIVITY_NOT_FOUND = new SVNErrorCode(190000, 2, "Activity not found");
        APMOD_BAD_BASELINE = new SVNErrorCode(190000, 3, "Baseline incorrect");
        APMOD_CONNECTION_ABORTED = new SVNErrorCode(190000, 4, "Input/output error");
        CLIENT_VERSIONED_PATH_REQUIRED = new SVNErrorCode(195000, 0, "A path under version control is needed for this operation");
        CLIENT_RA_ACCESS_REQUIRED = new SVNErrorCode(195000, 1, "Repository access is needed for this operation");
        CLIENT_BAD_REVISION = new SVNErrorCode(195000, 2, "Bogus revision information given");
        CLIENT_DUPLICATE_COMMIT_URL = new SVNErrorCode(195000, 3, "Attempting to commit to a URL more than once");
        CLIENT_IS_BINARY_FILE = new SVNErrorCode(195000, 4, "Operation does not apply to binary file");
        CLIENT_INVALID_EXTERNALS_DESCRIPTION = new SVNErrorCode(195000, 5, "Format of an svn:externals property was invalid");
        CLIENT_MODIFIED = new SVNErrorCode(195000, 6, "Attempting restricted operation for modified resource");
        CLIENT_IS_DIRECTORY = new SVNErrorCode(195000, 7, "Operation does not apply to directory");
        CLIENT_REVISION_RANGE = new SVNErrorCode(195000, 8, "Revision range is not allowed");
        CLIENT_INVALID_RELOCATION = new SVNErrorCode(195000, 9, "Inter-repository relocation not allowed");
        CLIENT_REVISION_AUTHOR_CONTAINS_NEWLINE = new SVNErrorCode(195000, 10, "Author name cannot contain a newline");
        CLIENT_PROPERTY_NAME = new SVNErrorCode(195000, 11, "Bad property name");
        CLIENT_UNRELATED_RESOURCES = new SVNErrorCode(195000, 12, "Two versioned resources are unrelated");
        CLIENT_MISSING_LOCK_TOKEN = new SVNErrorCode(195000, 13, "Path has no lock token");
        CLIENT_MULTIPLE_SOURCES_DISALLOWED = new SVNErrorCode(195000, 14, "Operation does not support multiple sources");
        CLIENT_NO_VERSIONED_PARENT = new SVNErrorCode(195000, 15, "No versioned parent directories");
        CLIENT_NOT_READY_TO_MERGE = new SVNErrorCode(195000, 16, "Working copy and merge source not ready for reintegration");
        CLIENT_FILE_EXTERNAL_OVERWRITE_VERSIONED = new SVNErrorCode(195000, 17, "A file external cannot overwrite an existing versioned item");
        CLIENT_BAD_STRIP_COUNT = new SVNErrorCode(195000, 18, "Invalid path component strip count specified");
        CLIENT_CYCLE_DETECTED = new SVNErrorCode(195000, 19, "Detected a cycle while processing the operation");
        CLIENT_MERGE_UPDATE_REQUIRED = new SVNErrorCode(195000, 20, "Working copy and merge source not ready for reintegration");
        CLIENT_INVALID_MERGEINFO_NO_MERGETRACKING = new SVNErrorCode(195000, 21, "Invalid mergeinfo detected in merge target");
        CLIENT_NO_LOCK_TOKEN = new SVNErrorCode(195000, 22, "Can't perform this operation without a valid lock token");
        CLIENT_FORBIDDEN_BY_SERVER = new SVNErrorCode(195000, 23, "The operation is forbidden by the server");
        BASE = new SVNErrorCode(200000, 0, "A problem occurred; see later errors for details");
        PLUGIN_LOAD_FAILURE = new SVNErrorCode(200000, 1, "Failure loading plugin");
        MALFORMED_FILE = new SVNErrorCode(200000, 2, "Malformed file");
        INCOMPLETE_DATA = new SVNErrorCode(200000, 3, "Incomplete data");
        INCORRECT_PARAMS = new SVNErrorCode(200000, 4, "Incorrect parameters given");
        UNVERSIONED_RESOURCE = new SVNErrorCode(200000, 5, "Tried a versioning operation on an unversioned resource");
        TEST_FAILED = new SVNErrorCode(200000, 6, "Test failed");
        UNSUPPORTED_FEATURE = new SVNErrorCode(200000, 7, "Trying to use an unsupported feature");
        BAD_PROP_KIND = new SVNErrorCode(200000, 8, "Unexpected or unknown property kind");
        ILLEGAL_TARGET = new SVNErrorCode(200000, 9, "Illegal target for the requested operation");
        DELTA_MD5_CHECKSUM_ABSENT = new SVNErrorCode(200000, 10, "MD5 checksum is missing");
        DIR_NOT_EMPTY = new SVNErrorCode(200000, 11, "Directory needs to be empty but is not");
        EXTERNAL_PROGRAM = new SVNErrorCode(200000, 12, "Error calling external program");
        SWIG_PY_EXCEPTION_SET = new SVNErrorCode(200000, 13, "Python exception has been set with the error");
        CHECKSUM_MISMATCH = new SVNErrorCode(200000, 14, "A checksum mismatch occurred");
        CANCELLED = new SVNErrorCode(200000, 15, "The operation was interrupted");
        INVALID_DIFF_OPTION = new SVNErrorCode(200000, 16, "The specified diff option is not supported");
        PROPERTY_NOT_FOUND = new SVNErrorCode(200000, 17, "Property not found");
        NO_AUTH_FILE_PATH = new SVNErrorCode(200000, 18, "No auth file path available");
        VERSION_MISMATCH = new SVNErrorCode(200000, 19, "Incompatible library version");
        MERGE_INFO_PARSE_ERROR = new SVNErrorCode(200000, 20, "Merge info parse error");
        CEASE_INVOCATION = new SVNErrorCode(200000, 21, "Cease invocation of this API");
        REVISION_NUMBER_PARSE_ERROR = new SVNErrorCode(200000, 22, "Revision number parse error");
        ITER_BREAK = new SVNErrorCode(200000, 23, "Iteration terminated before completion");
        UNKNOWN_CHANGELIST = new SVNErrorCode(200000, 24, "Unknown changelist");
        RESERVED_FILENAME_SPECIFIED = new SVNErrorCode(200000, 25, "Reserved directory name in command line arguments");
        UNKNOWN_CAPABILITY = new SVNErrorCode(200000, 26, "Inquiry about unknown capability");
        TEST_SKIPPED = new SVNErrorCode(200000, 27, "Test skipped");
        ATOMIC_INIT_FAILURE = new SVNErrorCode(200000, 29, "Couldn't perform atomic initialization");
        SQLITE_ERROR = new SVNErrorCode(200000, 30, "SQLite error");
        SQLITE_READONLY = new SVNErrorCode(200000, 31, "Attempted to write to readonly SQLite db");
        UNSUPPORTED_SCHEMA = new SVNErrorCode(200000, 32, "Unsupported schema found in SQLite db");
        CL_ARG_PARSING_ERROR = new SVNErrorCode(205000, 0, "Client error in parsing arguments");
        CL_INSUFFICIENT_ARGS = new SVNErrorCode(205000, 1, "Not enough args provided");
        CL_MUTUALLY_EXCLUSIVE_ARGS = new SVNErrorCode(205000, 2, "Mutually exclusive arguments specified");
        CL_ADM_DIR_RESERVED = new SVNErrorCode(205000, 3, "Attempted command in administrative dir");
        CL_LOG_MESSAGE_IS_VERSIONED_FILE = new SVNErrorCode(205000, 4, "The log message file is under version control");
        CL_LOG_MESSAGE_IS_PATHNAME = new SVNErrorCode(205000, 5, "The log message is a pathname");
        CL_COMMIT_IN_ADDED_DIR = new SVNErrorCode(205000, 6, "Committing in directory scheduled for addition");
        CL_NO_EXTERNAL_EDITOR = new SVNErrorCode(205000, 7, "No external editor available");
        CL_BAD_LOG_MESSAGE = new SVNErrorCode(205000, 8, "Something is wrong with the log message's contents");
        CL_UNNECESSARY_LOG_MESSAGE = new SVNErrorCode(205000, 9, "A log message was given where none was necessary");
        CL_NO_EXTERNAL_MERGE_TOOL = new SVNErrorCode(205000, 10, "No external merge tool available");
        CL_ERROR_PROCESSING_EXTERNALS = new SVNErrorCode(205000, 11, "Failed processing one or more externals definitions");
        ASSERTION_FAIL = new SVNErrorCode(235000, 0, "Assertion failure");
        BAD_CHANGELIST_NAME = new SVNErrorCode(125000, 14, "Invalid changelist name");
    }
}

