/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.api;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class EffectiveMetamodelRuleset {
    public static final String WILDCARD = "*";
    private final Table<String, String, ImmutableSet<String>> inclusions;
    private final Table<String, String, ImmutableSet<String>> exclusions;

    public EffectiveMetamodelRuleset() {
        this.inclusions = HashBasedTable.create();
        this.exclusions = HashBasedTable.create();
    }

    public EffectiveMetamodelRuleset(EffectiveMetamodelRuleset toCopy) {
        this.inclusions = HashBasedTable.create(toCopy.inclusions);
        this.exclusions = HashBasedTable.create(toCopy.exclusions);
    }

    public EffectiveMetamodelRuleset(Map<String, Map<String, Set<String>>> inclusionRules, Map<String, Map<String, Set<String>>> exclusionRules) {
        this();
        this.loadMapIntoTable(inclusionRules, this.inclusions);
        this.loadMapIntoTable(exclusionRules, this.exclusions);
    }

    public void importRules(EffectiveMetamodelRuleset source) {
        this.exclusions.putAll(source.exclusions);
        this.inclusions.putAll(source.inclusions);
    }

    protected void loadMapIntoTable(Map<String, Map<String, Set<String>>> rawMap, Table<String, String, ImmutableSet<String>> table) {
        if (rawMap != null) {
            for (Map.Entry<String, Map<String, Set<String>>> mmEntry : rawMap.entrySet()) {
                String mmURI = mmEntry.getKey();
                for (Map.Entry<String, Set<String>> typeEntry : mmEntry.getValue().entrySet()) {
                    String typeName = typeEntry.getKey();
                    ImmutableSet slots = ImmutableSet.copyOf((Collection)typeEntry.getValue());
                    table.put((Object)mmURI, (Object)typeName, (Object)slots);
                }
            }
        }
    }

    public boolean isEverythingIncluded() {
        return this.inclusions.isEmpty() && this.exclusions.isEmpty();
    }

    public boolean isIncluded(String mmURI) {
        boolean excluded;
        boolean included = this.inclusions.isEmpty() || this.inclusions.containsRow((Object)mmURI);
        boolean bl = excluded = !included || this.exclusions.contains((Object)mmURI, (Object)WILDCARD);
        return included && !excluded;
    }

    public boolean isFullyIncluded(String mmURI) {
        boolean excluded;
        boolean included = this.inclusions.isEmpty() || this.inclusions.contains((Object)mmURI, (Object)WILDCARD);
        boolean bl = excluded = !included || this.exclusions.containsRow((Object)mmURI);
        return included && !excluded;
    }

    public boolean isIncluded(String mmURI, String typeName) {
        boolean excluded;
        boolean included = this.inclusions.isEmpty() || this.inclusions.contains((Object)mmURI, (Object)WILDCARD) || this.inclusions.contains((Object)mmURI, (Object)typeName);
        Set excludedSlots = (Set)this.exclusions.get((Object)mmURI, (Object)typeName);
        boolean bl = excluded = !included || this.exclusions.contains((Object)mmURI, (Object)WILDCARD) || excludedSlots != null && excludedSlots.contains(WILDCARD);
        return included && !excluded;
    }

    public boolean isFullyIncluded(String mmURI, String typeName) {
        boolean excluded;
        Set includedSlots = (Set)this.inclusions.get((Object)mmURI, (Object)typeName);
        boolean included = this.inclusions.isEmpty() || this.inclusions.contains((Object)mmURI, (Object)WILDCARD) || includedSlots != null && includedSlots.contains(WILDCARD);
        boolean bl = excluded = !included || this.exclusions.contains((Object)mmURI, (Object)WILDCARD) || this.exclusions.contains((Object)mmURI, (Object)typeName);
        return included && !excluded;
    }

    public boolean isIncluded(String mmURI, String typeName, String slot) {
        boolean excluded;
        Set includedSlots = (Set)this.inclusions.get((Object)mmURI, (Object)typeName);
        boolean included = this.inclusions.isEmpty() || this.inclusions.contains((Object)mmURI, (Object)WILDCARD) || includedSlots != null && (includedSlots.contains(WILDCARD) || includedSlots.contains(slot));
        Set excludedSlots = (Set)this.exclusions.get((Object)mmURI, (Object)typeName);
        boolean bl = excluded = !included || this.exclusions.contains((Object)mmURI, (Object)WILDCARD) || excludedSlots != null && (excludedSlots.contains(WILDCARD) || excludedSlots.contains(slot));
        return included && !excluded;
    }

    public void include(String mmURI) {
        this.inclusions.put((Object)mmURI, (Object)WILDCARD, (Object)ImmutableSet.of((Object)WILDCARD));
    }

    public void include(String mmURI, String type) {
        this.inclusions.put((Object)mmURI, (Object)type, (Object)ImmutableSet.of((Object)WILDCARD));
    }

    public void include(String mmURI, String type, ImmutableSet<String> slots) {
        this.inclusions.put((Object)mmURI, (Object)type, slots);
    }

    public void exclude(String mmURI) {
        this.exclusions.put((Object)mmURI, (Object)WILDCARD, (Object)ImmutableSet.of((Object)WILDCARD));
    }

    public void exclude(String mmURI, String type) {
        this.exclusions.put((Object)mmURI, (Object)type, (Object)ImmutableSet.of((Object)WILDCARD));
    }

    public void exclude(String mmURI, String type, ImmutableSet<String> slots) {
        if (slots == null || slots.isEmpty()) {
            this.exclusions.remove((Object)mmURI, (Object)type);
        } else {
            this.exclusions.put((Object)mmURI, (Object)type, slots);
        }
    }

    public void reset(String mmURI) {
        this.inclusions.remove((Object)mmURI, (Object)WILDCARD);
        this.exclusions.remove((Object)mmURI, (Object)WILDCARD);
    }

    public void reset(String mmURI, String type) {
        ImmutableSet oldExclusions;
        ImmutableSet oldInclusions = (ImmutableSet)this.inclusions.remove((Object)mmURI, (Object)type);
        if (oldInclusions != null && !oldInclusions.contains((Object)WILDCARD)) {
            this.inclusions.put((Object)mmURI, (Object)type, (Object)oldInclusions);
        }
        if ((oldExclusions = (ImmutableSet)this.exclusions.remove((Object)mmURI, (Object)type)) != null && !oldExclusions.contains((Object)WILDCARD)) {
            this.exclusions.put((Object)mmURI, (Object)type, (Object)oldExclusions);
        }
    }

    public void reset(String mmURI, String type, String slot) {
        ImmutableSet oldExclusions;
        ImmutableSet oldInclusions = (ImmutableSet)this.inclusions.remove((Object)mmURI, (Object)type);
        if (oldInclusions != null) {
            if (!oldInclusions.contains((Object)slot)) {
                this.inclusions.put((Object)mmURI, (Object)type, (Object)oldInclusions);
            } else {
                this.inclusions.put((Object)mmURI, (Object)type, this.copyWithout(slot, (ImmutableSet<String>)oldInclusions));
            }
        }
        if ((oldExclusions = (ImmutableSet)this.inclusions.remove((Object)mmURI, (Object)type)) != null) {
            if (!oldExclusions.contains((Object)slot)) {
                this.inclusions.put((Object)mmURI, (Object)type, (Object)oldExclusions);
            } else {
                this.inclusions.put((Object)mmURI, (Object)type, this.copyWithout(slot, (ImmutableSet<String>)oldExclusions));
            }
        }
    }

    protected ImmutableSet<String> copyWithout(String slot, ImmutableSet<String> oldInclusions) {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (String s : oldInclusions) {
            if (slot.equals(s)) continue;
            builder.add((Object)s);
        }
        ImmutableSet newSet = builder.build();
        return newSet;
    }

    public Table<String, String, ImmutableSet<String>> getInclusionRules() {
        return Tables.unmodifiableTable(this.inclusions);
    }

    public Table<String, String, ImmutableSet<String>> getExclusionRules() {
        return Tables.unmodifiableTable(this.exclusions);
    }

    public ImmutableSet<String> getIncludedSlots(String mmURI, String typeName) {
        if (this.isEverythingIncluded()) {
            return ImmutableSet.of((Object)WILDCARD);
        }
        if (this.exclusions.contains((Object)mmURI, (Object)WILDCARD)) {
            return ImmutableSet.of();
        }
        ImmutableSet included = (ImmutableSet)this.inclusions.get((Object)mmURI, (Object)typeName);
        if (included == null) {
            return ImmutableSet.of();
        }
        ImmutableSet excluded = (ImmutableSet)this.exclusions.get((Object)mmURI, (Object)typeName);
        if (excluded == null) {
            return included;
        }
        ImmutableSet.Builder result = new ImmutableSet.Builder();
        for (String slot : included) {
            if (excluded.contains((Object)slot)) continue;
            result.add((Object)slot);
        }
        return result.build();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.exclusions == null ? 0 : this.exclusions.hashCode());
        result = 31 * result + (this.inclusions == null ? 0 : this.inclusions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EffectiveMetamodelRuleset other = (EffectiveMetamodelRuleset)obj;
        if (this.exclusions == null ? other.exclusions != null : !this.exclusions.equals(other.exclusions)) {
            return false;
        }
        return !(this.inclusions == null ? other.inclusions != null : !this.inclusions.equals(other.inclusions));
    }
}

