/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.emf.metamodel;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hawk.core.IMetaModelResourceFactory;
import org.eclipse.hawk.core.model.IHawkMetaModelResource;
import org.eclipse.hawk.core.model.IHawkObject;
import org.eclipse.hawk.emf.EMFWrapperFactory;

public class EMFMetaModelResource
implements IHawkMetaModelResource {
    private EMFWrapperFactory wf;
    private Resource res;
    private IMetaModelResourceFactory p;

    public void unload() {
        this.res = null;
    }

    public EMFMetaModelResource(Resource r, EMFWrapperFactory wf, IMetaModelResourceFactory pa) {
        this.res = r;
        this.p = pa;
        this.wf = wf;
    }

    public Set<IHawkObject> getAllContents() {
        TreeIterator it = this.res.getAllContents();
        HashSet<IHawkObject> ret = new HashSet<IHawkObject>();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof EClass) {
                ret.add(this.wf.createClass((EClass)o));
                continue;
            }
            if (!(o instanceof EPackage)) continue;
            ret.add(this.wf.createPackage((EPackage)o, this));
        }
        return ret;
    }

    public IMetaModelResourceFactory getMetaModelResourceFactory() {
        return this.p;
    }

    public void save(OutputStream output, Map<Object, Object> hashMap) throws IOException {
        this.res.save(output, hashMap);
    }

    public String toString() {
        return this.res.getURI().toString();
    }

    public Resource getResource() {
        return this.res;
    }
}

