/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.orientdb.indexes;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.hawk.core.graph.EmptyIGraphIterable;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.orientdb.OrientDatabase;
import org.eclipse.hawk.orientdb.OrientIndexStore;
import org.eclipse.hawk.orientdb.OrientNode;
import org.eclipse.hawk.orientdb.indexes.AbstractOrientIndex;
import org.eclipse.hawk.orientdb.indexes.IndexCursorFactoriesIterable;
import org.eclipse.hawk.orientdb.indexes.IndexCursorFactoryNodeIterable;
import org.eclipse.hawk.orientdb.indexes.OIndexCursorFactory;
import org.eclipse.hawk.orientdb.indexes.ResultSetIterable;
import org.eclipse.hawk.orientdb.indexes.SingleKeyOIndexCursorFactory;
import org.eclipse.hawk.orientdb.indexes.StarKeyOIndexCursorFactoryIterable;

public class OrientNodeIndex
extends AbstractOrientIndex
implements IGraphNodeIndex {
    private static final List<PostponedIndexAdd> postponed = new ArrayList<PostponedIndexAdd>();

    public OrientNodeIndex(String name, OrientDatabase graph) {
        super(name, graph, AbstractOrientIndex.IndexType.NODE);
        OrientIndexStore idxStore = graph.getIndexStore();
        idxStore.addNodeIndex(name);
    }

    public IGraphIterable<IGraphNode> query(String key, Object valueExpr) {
        valueExpr = OrientNodeIndex.normalizeValue(valueExpr);
        if ("*".equals(key)) {
            Set<String> valueIdxNames = this.graph.getIndexStore().getNodeFieldIndexNames(this.name);
            StarKeyOIndexCursorFactoryIterable iterFactories = new StarKeyOIndexCursorFactoryIterable(valueExpr, this, valueIdxNames);
            return new IndexCursorFactoriesIterable<IGraphNode>(iterFactories, this.graph, IGraphNode.class);
        }
        SingleKeyOIndexCursorFactory factory = new SingleKeyOIndexCursorFactory(valueExpr, this, key);
        return new IndexCursorFactoryNodeIterable<IGraphNode>(factory, this.graph, IGraphNode.class);
    }

    public IGraphIterable<IGraphNode> query(final String key, Number nFrom, Number nTo, final boolean fromInclusive, final boolean toInclusive) {
        if (nFrom instanceof Float || nFrom instanceof Double) {
            final double dFrom = nFrom.doubleValue();
            final double dTo = nTo.doubleValue();
            final OIndex<?> idx = this.getIndex(Double.class);
            if (idx == null) {
                return new EmptyIGraphIterable();
            }
            return new IndexCursorFactoryNodeIterable<IGraphNode>(new OIndexCursorFactory(){

                @Override
                public Iterator<OIdentifiable> query() {
                    return OrientNodeIndex.iterateEntriesBetween(key, dFrom, dTo, fromInclusive, toInclusive, idx, OrientNodeIndex.this.graph.getGraph());
                }
            }, this.graph, IGraphNode.class);
        }
        final int lFrom = nFrom.intValue();
        final int lTo = nTo.intValue();
        final OIndex<?> idx = this.getIndex(Integer.class);
        if (idx == null) {
            return new EmptyIGraphIterable();
        }
        return new IndexCursorFactoryNodeIterable<IGraphNode>(new OIndexCursorFactory(){

            @Override
            public Iterator<OIdentifiable> query() {
                return OrientNodeIndex.iterateEntriesBetween(key, fromInclusive ? lFrom : lFrom + 1, toInclusive ? lTo : lTo - 1, true, true, idx, OrientNodeIndex.this.graph.getGraph());
            }
        }, this.graph, IGraphNode.class);
    }

    public IGraphIterable<IGraphNode> get(String key, Object valueExpr) {
        valueExpr = OrientNodeIndex.normalizeValue(valueExpr);
        return new ResultSetIterable<IGraphNode>(key, valueExpr, this, IGraphNode.class);
    }

    public void add(IGraphNode n, Map<String, Object> derived) {
        if (derived == null) {
            return;
        }
        OrientNode orientNode = (OrientNode)n;
        for (Map.Entry<String, Object> entry : derived.entrySet()) {
            String field = entry.getKey();
            Object rawValue = entry.getValue();
            if (rawValue == null) continue;
            Object valueExpr = OrientNodeIndex.normalizeValue(rawValue);
            Class<?> valueClass = valueExpr.getClass();
            OIndex<?> idx = this.getOrCreateFieldIndex(field, valueClass);
            ORID identity = orientNode.getId();
            OCompositeKey idxKey = new OCompositeKey(new Object[]{field, valueExpr});
            if (this.graph.getGraph().getURL().startsWith("remote:") && identity.isNew()) {
                postponed.add(new PostponedIndexAdd(idx, idxKey, (OIdentifiable)identity));
                this.graph.addPostponedIndex(this);
            } else {
                idx.put((Object)idxKey, (OIdentifiable)identity);
            }
            orientNode.addIndexKey(idx.getName(), field, valueExpr);
        }
    }

    public void add(IGraphNode n, String s, Object derived) {
        this.add(n, Collections.singletonMap(s, derived));
    }

    public void remove(IGraphNode n) {
        OrientNode oNode = (OrientNode)n;
        ORID toRemove = oNode.getId().isPersistent() ? oNode.getId() : oNode.getDocument();
        List<Map.Entry<String, Map<String, List<Object>>>> indices = oNode.removeIndexFields(this.escapedName);
        for (Map.Entry<String, Map<String, List<Object>>> index : indices) {
            String indexName = index.getKey();
            OIndex oIndex = this.getIndexManager().getIndex(indexName);
            for (Map.Entry<String, List<Object>> idxEntry : index.getValue().entrySet()) {
                String field = idxEntry.getKey();
                for (Object key : idxEntry.getValue()) {
                    oIndex.remove((Object)new OCompositeKey(new Object[]{field, key}), (OIdentifiable)toRemove);
                }
            }
        }
    }

    public void remove(IGraphNode n, String field, Object value) {
        OrientNode oNode = (OrientNode)n;
        if (field == null && value == null) {
            this.remove(n);
        } else if (field == null) {
            OrientIndexStore store = this.graph.getIndexStore();
            for (String fieldName : store.getNodeFieldIndexNames(this.name)) {
                this.remove(n, fieldName, value);
            }
        } else if (value == null) {
            this.remove(field, oNode);
        } else {
            OIndex<?> idx = this.getIndex((value = OrientNodeIndex.normalizeValue(value)).getClass());
            if (idx != null) {
                idx.remove((Object)new OCompositeKey(new Object[]{field, value}), (OIdentifiable)oNode.getDocument());
                oNode.removeIndexKey(this.getSBTreeIndexName(value.getClass()), field, value);
            }
        }
    }

    private void remove(String field, OrientNode n) {
        this.remove(String.class, field, n);
        this.remove(Double.class, field, n);
        this.remove(Integer.class, field, n);
    }

    private void remove(Class<?> keyClass, String field, OrientNode n) {
        Collection<Object> keys = n.removeIndexField(this.getSBTreeIndexName(keyClass), field);
        OIndex<?> idx = this.getIndex(keyClass);
        ORID toRemove = n.getId().isPersistent() ? n.getId() : n.getDocument();
        for (Object key : keys) {
            idx.remove((Object)new OCompositeKey(new Object[]{field, key}), (OIdentifiable)toRemove);
        }
    }

    public void flush() {
    }

    public void delete() {
        this.clearIndexOfType(String.class);
        this.clearIndexOfType(Double.class);
        this.clearIndexOfType(Integer.class);
        OrientIndexStore store = this.graph.getIndexStore();
        store.removeNodeIndex(this.name);
    }

    protected void clearIndexOfType(Class<?> klass) {
        String sIdxStrings;
        OIndexManager indexManager = this.getIndexManager();
        OIndex idxStrings = indexManager.getIndex(sIdxStrings = this.getSBTreeIndexName(klass));
        if (idxStrings != null) {
            idxStrings.clear();
        }
    }

    public List<PostponedIndexAdd> getPostponedIndexAdditions() {
        return postponed;
    }

    public static class PostponedIndexAdd {
        private final OIndex<?> index;
        private final Object key;
        private final OIdentifiable value;

        private PostponedIndexAdd(OIndex<?> index, Object key, OIdentifiable value) {
            this.index = index;
            this.key = key;
            this.value = value;
        }

        public OIndex<?> getIndex() {
            return this.index;
        }

        public Object getKey() {
            return this.key;
        }

        public OIdentifiable getValue() {
            return this.value;
        }
    }
}

