/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.servlet.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.eclipse.hawk.service.servlet.processors.IAuthenticatedProcessorFactory;

public class RequestAwareThriftServlet
extends HttpServlet {
    private static final long serialVersionUID = 2824688119881763947L;
    private final IAuthenticatedProcessorFactory processorFactory;
    private final TProtocolFactory inProtocolFactory;
    private final TProtocolFactory outProtocolFactory;
    private final Collection<Map.Entry<String, String>> customHeaders;

    public RequestAwareThriftServlet(IAuthenticatedProcessorFactory processorFactory, TProtocolFactory inProtocolFactory, TProtocolFactory outProtocolFactory) {
        this.processorFactory = processorFactory;
        this.inProtocolFactory = inProtocolFactory;
        this.outProtocolFactory = outProtocolFactory;
        this.customHeaders = new ArrayList<Map.Entry<String, String>>();
    }

    public RequestAwareThriftServlet(IAuthenticatedProcessorFactory processorFactory, TProtocolFactory protocolFactory) {
        this(processorFactory, protocolFactory, protocolFactory);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        TIOStreamTransport inTransport = null;
        TIOStreamTransport outTransport = null;
        try {
            TIOStreamTransport transport;
            response.setContentType("application/x-thrift");
            if (this.customHeaders != null) {
                for (Map.Entry<String, String> header : this.customHeaders) {
                    response.addHeader(header.getKey(), header.getValue());
                }
            }
            ServletInputStream in = request.getInputStream();
            ServletOutputStream out = response.getOutputStream();
            inTransport = transport = new TIOStreamTransport((InputStream)in, (OutputStream)out);
            outTransport = transport;
            TProtocol inProtocol = this.inProtocolFactory.getProtocol((TTransport)inTransport);
            TProtocol outProtocol = this.outProtocolFactory.getProtocol((TTransport)outTransport);
            TProcessor processor = this.processorFactory.create(request);
            processor.process(inProtocol, outProtocol);
            out.flush();
        }
        catch (TException te) {
            throw new ServletException((Throwable)te);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void addCustomHeader(final String key, final String value) {
        this.customHeaders.add(new Map.Entry<String, String>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public String getValue() {
                return value;
            }

            @Override
            public String setValue(String value2) {
                return null;
            }
        });
    }

    public void setCustomHeaders(Collection<Map.Entry<String, String>> headers) {
        this.customHeaders.clear();
        this.customHeaders.addAll(headers);
    }
}

