/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.servlet.utils;

import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.graph.GraphWrapper;
import org.eclipse.hawk.graph.Slot;
import org.eclipse.hawk.graph.TypeNode;
import org.eclipse.hawk.service.api.ModelElementType;
import org.eclipse.hawk.service.api.SlotMetadata;

public class HawkModelElementTypeEncoder {
    private final GraphWrapper graph;

    public HawkModelElementTypeEncoder(GraphWrapper gw) {
        this.graph = gw;
    }

    public ModelElementType encode(String id) {
        TypeNode me = this.graph.getTypeNodeById(id);
        return this.encode(me);
    }

    public ModelElementType encode(TypeNode me) {
        ModelElementType t = new ModelElementType();
        t.setMetamodelUri(me.getMetamodelURI());
        t.setTypeName(me.getTypeName());
        t.setId(me.getNode().getId().toString());
        for (Slot s : me.getSlots().values()) {
            SlotMetadata sm = new SlotMetadata();
            sm.setIsMany(s.isMany());
            sm.setIsOrdered(s.isOrdered());
            sm.setIsUnique(s.isUnique());
            sm.setName(s.getName());
            sm.setType(s.getType());
            if (s.isAttribute()) {
                t.addToAttributes(sm);
                continue;
            }
            t.addToReferences(sm);
        }
        return t;
    }

    public Object encode(IGraphNode n) {
        return this.encode(new TypeNode(n));
    }
}

