/*
 * Decompiled with CFR 0.152.
 */
package com.github.peterwippermann.junit4.parameterizedsuite.util;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.junit.runners.Parameterized;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class ParameterizedUtil {
    public static Iterable<Object> getParameters(TestClass testClass) throws Throwable {
        Object parameters = ParameterizedUtil.getParametersMethod(testClass).invokeExplosively(null, new Object[0]);
        if (parameters instanceof Iterable) {
            return (Iterable)parameters;
        }
        if (parameters instanceof Object[]) {
            return Arrays.asList((Object[])parameters);
        }
        throw ParameterizedUtil.parametersMethodReturnedWrongType(testClass);
    }

    private static FrameworkMethod getParametersMethod(TestClass testClass) throws Exception {
        List methods = testClass.getAnnotatedMethods(Parameterized.Parameters.class);
        for (FrameworkMethod each : methods) {
            if (!each.isStatic() || !each.isPublic()) continue;
            return each;
        }
        throw new Exception("No public static parameters method on class " + testClass.getName());
    }

    private static Exception parametersMethodReturnedWrongType(TestClass testClass) throws Exception {
        String className = testClass.getName();
        String methodName = ParameterizedUtil.getParametersMethod(testClass).getName();
        String message = MessageFormat.format("{0}.{1}() must return an Iterable of arrays.", className, methodName);
        return new Exception(message);
    }

    public static Object[] normalizeParameter(Object singleParameterAsArrayOrObject) {
        return ParameterizedUtil.isParameterAnArray(singleParameterAsArrayOrObject) ? (Object[])singleParameterAsArrayOrObject : ParameterizedUtil.convertSingleParameterToArray(singleParameterAsArrayOrObject);
    }

    public static Object[] convertSingleParameterToArray(Object singleParameter) {
        return new Object[]{singleParameter};
    }

    public static boolean isParameterAnArray(Object singleParameterAsArrayOrObject) {
        return singleParameterAsArrayOrObject instanceof Object[];
    }

    public static String buildTestName(String pattern, int index, Object[] parameters) {
        String finalPattern = pattern.replaceAll("\\{index\\}", Integer.toString(index));
        return "[" + MessageFormat.format(finalPattern, parameters) + "]";
    }

    public static String getNamePatternForParameters(TestClass testClass) throws Exception {
        Parameterized.Parameters parametersAnnotation = (Parameterized.Parameters)ParameterizedUtil.getParametersMethod(testClass).getAnnotation(Parameterized.Parameters.class);
        return parametersAnnotation.name();
    }
}

