/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.greycat.lucene;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.eclipse.hawk.greycat.lucene.CaseInsensitiveWhitespaceAnalyzer;
import org.eclipse.hawk.greycat.lucene.GreycatLuceneIndexer;
import org.eclipse.hawk.greycat.lucene.ListCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SoftTxLucene {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoftTxLucene.class);
    private final Directory storage;
    private final Analyzer analyzer;
    private final IndexWriter writer;
    private final List<IUndoable> rollbackLog = new LinkedList<IUndoable>();
    private final ScheduledExecutorService executor;
    private final SearcherManager searchManager;

    public SoftTxLucene(File dir) throws IOException {
        this.storage = new MMapDirectory(dir.toPath());
        this.analyzer = new CaseInsensitiveWhitespaceAnalyzer();
        this.writer = new IndexWriter(this.storage, new IndexWriterConfig(this.analyzer));
        this.searchManager = new SearcherManager(this.writer, true, false, null);
        this.executor = Executors.newScheduledThreadPool(1);
        this.executor.scheduleWithFixedDelay(() -> {
            List<IUndoable> list = this.rollbackLog;
            synchronized (list) {
                try {
                    this.writer.commit();
                    this.refreshReader();
                }
                catch (IOException e) {
                    LOGGER.error("Periodic commit of Lucene at " + this.storage + " failed", (Throwable)e);
                }
            }
        }, 30L, 30L, TimeUnit.SECONDS);
    }

    public SearcherCloseable getSearcher() throws IOException {
        return new SearcherCloseable();
    }

    private void refreshReader() throws IOException {
        this.searchManager.maybeRefresh();
    }

    public void flush() {
        try {
            this.writer.flush();
            this.searchManager.maybeRefreshBlocking();
        }
        catch (IOException e) {
            LOGGER.error("Failed to flush index", (Throwable)e);
        }
    }

    public void shutdown() {
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(300L, TimeUnit.SECONDS);
            this.writer.close();
            this.storage.close();
            LOGGER.info("Shutdown of Lucene complete.");
        }
        catch (IOException e) {
            LOGGER.error("Error during Lucene shutdown", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.error("Gave up waiting for Lucene to commit", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        List<IUndoable> list = this.rollbackLog;
        synchronized (list) {
            this.rollbackLog.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IOException {
        List<IUndoable> list = this.rollbackLog;
        synchronized (list) {
            ListIterator<IUndoable> itUndoable = this.rollbackLog.listIterator(this.rollbackLog.size());
            while (itUndoable.hasPrevious()) {
                itUndoable.previous().undoWork();
            }
            this.rollbackLog.clear();
            this.refreshReader();
        }
    }

    public void update(final Term term, final Document oldDocument, final Document newDocument) throws IOException {
        this.doWork(new IUndoable(){
            private Document prevDocument = null;

            @Override
            public void doWork() throws IOException {
                this.prevDocument = GreycatLuceneIndexer.copy(oldDocument);
                SoftTxLucene.this.writer.updateDocument(term, (Iterable)newDocument);
                SoftTxLucene.this.refreshReader();
            }

            @Override
            public void undoWork() throws IOException {
                if (this.prevDocument == null) {
                    SoftTxLucene.this.writer.deleteDocuments(new Term[]{term});
                } else {
                    SoftTxLucene.this.writer.updateDocument(term, (Iterable)this.prevDocument);
                }
            }
        });
    }

    public void delete(final Term term) throws IOException {
        this.doWork(new IUndoable(){
            private Document oldDocument = null;

            @Override
            public void doWork() throws IOException {
                this.oldDocument = GreycatLuceneIndexer.copy(SoftTxLucene.this.getDocument(term));
                SoftTxLucene.this.writer.deleteDocuments(new Term[]{term});
                SoftTxLucene.this.refreshReader();
            }

            @Override
            public void undoWork() throws IOException {
                if (this.oldDocument != null) {
                    SoftTxLucene.this.writer.addDocument((Iterable)this.oldDocument);
                }
            }
        });
    }

    public void delete(final Query query) throws IOException {
        this.doWork(new IUndoable(){
            private List<Document> oldDocuments;

            @Override
            public void doWork() throws IOException {
                Throwable throwable = null;
                Object var2_3 = null;
                try (SearcherCloseable sc = new SearcherCloseable();){
                    ListCollector lc = new ListCollector(sc.get());
                    sc.get().search(query, (Collector)lc);
                    this.oldDocuments = lc.getDocuments().stream().map(d -> GreycatLuceneIndexer.copy(d)).collect(Collectors.toList());
                    SoftTxLucene.this.writer.deleteDocuments(new Query[]{query});
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }

            @Override
            public void undoWork() throws IOException {
                for (Document old : this.oldDocuments) {
                    SoftTxLucene.this.writer.addDocument((Iterable)old);
                }
            }
        });
    }

    private Document getDocument(Term term) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (SearcherCloseable sc = new SearcherCloseable();){
            IndexSearcher searcher = sc.get();
            TopDocs topDocs = searcher.search((Query)new TermQuery(term), 1);
            if (topDocs.totalHits > 0L) {
                return searcher.doc(topDocs.scoreDocs[0].doc);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork(IUndoable iUndoable) throws IOException {
        List<IUndoable> list = this.rollbackLog;
        synchronized (list) {
            iUndoable.doWork();
            this.rollbackLog.add(iUndoable);
        }
    }

    private static interface IUndoable {
        public void doWork() throws IOException;

        public void undoWork() throws IOException;
    }

    public class SearcherCloseable
    implements Closeable {
        private IndexSearcher searcher;

        public SearcherCloseable() throws IOException {
            this.searcher = (IndexSearcher)SoftTxLucene.this.searchManager.acquire();
        }

        public IndexSearcher get() {
            return this.searcher;
        }

        @Override
        public void close() {
            if (this.searcher != null) {
                try {
                    SoftTxLucene.this.searchManager.release((Object)this.searcher);
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
                this.searcher = null;
            }
        }
    }
}

