/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.emf.impl;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hawk.service.api.SubscriptionDurability;
import org.eclipse.hawk.service.api.utils.APIUtils;
import org.eclipse.hawk.service.emf.HawkModelDescriptor;
import org.eclipse.hawk.service.emf.impl.HawkResourceImpl;

public class HawkResourceFactoryImpl
implements Resource.Factory {
    private static final String URLPARAM_CLIENTID = "clientID";
    private static final String URLPARAM_DURABILITY = "durability";
    private static final String URLPARAM_SUBSCRIBE = "subscribe";
    private static final String URLPARAM_LOADING_MODE = "loadingMode";
    private static final String URLPARAM_REPOSITORY = "repository";
    private static final String URLPARAM_THRIFT_PROTOCOL = "tprotocol";
    private static final String URLPARAM_FILE_PATTERNS = "filePatterns";
    private static final String URLPARAM_INSTANCE = "instance";
    private static final String URLPARAM_QUERY = "query";
    private static final String URLPARAM_QUERY_LANGUAGE = "queryLanguage";
    private static final String URLPARAM_DEFAULT_NAMESPACES = "defaultNS";
    private static final String URLPARAM_SPLIT = "split";

    public HawkResourceImpl createResource(URI uri) {
        if (this.isHawkURL(uri)) {
            HawkModelDescriptor descriptor = this.parseHawkURL(uri);
            return new HawkResourceImpl(uri, descriptor);
        }
        return new HawkResourceImpl(uri);
    }

    public static String generateHawkURL(HawkModelDescriptor d, boolean removeDefaultValues) throws UnsupportedEncodingException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        HawkResourceFactoryImpl.addParameter(params, URLPARAM_INSTANCE, d.getHawkInstance(), "myhawk", removeDefaultValues);
        HawkResourceFactoryImpl.addParameter(params, URLPARAM_FILE_PATTERNS, HawkResourceFactoryImpl.join(d.getHawkFilePatterns(), ","), "*", removeDefaultValues);
        HawkResourceFactoryImpl.addParameter(params, URLPARAM_THRIFT_PROTOCOL, d.getThriftProtocol().name().toUpperCase(), HawkModelDescriptor.DEFAULT_TPROTOCOL.name().toUpperCase(), removeDefaultValues);
        HawkResourceFactoryImpl.addParameter(params, URLPARAM_REPOSITORY, d.getHawkRepository(), "*", removeDefaultValues);
        HawkResourceFactoryImpl.addParameter(params, URLPARAM_LOADING_MODE, d.getLoadingMode().name().toUpperCase(), HawkModelDescriptor.DEFAULT_LOADING_MODE.name().toUpperCase(), removeDefaultValues);
        HawkResourceFactoryImpl.addParameter(params, URLPARAM_QUERY_LANGUAGE, d.getHawkQueryLanguage(), "", removeDefaultValues);
        HawkResourceFactoryImpl.addParameter(params, URLPARAM_QUERY, d.getHawkQuery(), "", removeDefaultValues);
        HawkResourceFactoryImpl.addParameter(params, URLPARAM_DEFAULT_NAMESPACES, d.getDefaultNamespaces(), "", removeDefaultValues);
        HawkResourceFactoryImpl.addParameter(params, URLPARAM_SPLIT, String.valueOf(d.isSplit()), "true", removeDefaultValues);
        HawkResourceFactoryImpl.addParameter(params, URLPARAM_SUBSCRIBE, String.valueOf(d.isSubscribed()), "false", removeDefaultValues);
        if (d.isSubscribed()) {
            HawkResourceFactoryImpl.addParameter(params, URLPARAM_DURABILITY, d.getSubscriptionDurability().name().toUpperCase(), HawkModelDescriptor.DEFAULT_DURABILITY.name().toUpperCase(), removeDefaultValues);
            HawkResourceFactoryImpl.addParameter(params, URLPARAM_CLIENTID, d.getSubscriptionClientID(), null, removeDefaultValues);
        }
        StringBuffer url = new StringBuffer("hawk+");
        url.append(d.getHawkURL());
        url.append("?");
        url.append(URLEncodedUtils.format(params, (Charset)Charset.forName("UTF-8")));
        return url.toString();
    }

    protected static void addParameter(List<NameValuePair> params, String key, String value, String defaultValue, boolean ignoreDefaultValue) {
        if (!ignoreDefaultValue || defaultValue == null || !defaultValue.equals(value)) {
            params.add((NameValuePair)new BasicNameValuePair(key, value));
        }
    }

    protected HawkModelDescriptor parseHawkURL(URI uri) {
        HawkModelDescriptor descriptor = new HawkModelDescriptor();
        String instanceURL = uri.trimQuery().toString().replaceFirst("hawk[+]", "");
        descriptor.setHawkURL(instanceURL);
        List pairs = URLEncodedUtils.parse((String)uri.query(), (Charset)Charset.forName("UTF-8"));
        for (NameValuePair pair : pairs) {
            String v = pair.getValue();
            switch (pair.getName()) {
                case "instance": {
                    descriptor.setHawkInstance(v);
                    break;
                }
                case "filePatterns": {
                    descriptor.setHawkFilePatterns(v.split(","));
                    break;
                }
                case "tprotocol": {
                    descriptor.setThriftProtocol(APIUtils.ThriftProtocol.valueOf((String)v.toUpperCase()));
                    break;
                }
                case "repository": {
                    descriptor.setHawkRepository(v);
                    break;
                }
                case "loadingMode": {
                    descriptor.setLoadingMode(HawkModelDescriptor.LoadingMode.valueOf(v.toUpperCase()));
                    break;
                }
                case "split": {
                    descriptor.setSplit(Boolean.valueOf(v));
                    break;
                }
                case "subscribe": {
                    descriptor.setSubscribed(Boolean.valueOf(v));
                    break;
                }
                case "durability": {
                    descriptor.setSubscriptionDurability(SubscriptionDurability.valueOf((String)v.toUpperCase()));
                    break;
                }
                case "clientID": {
                    descriptor.setSubscriptionClientID(v);
                    break;
                }
                case "queryLanguage": {
                    descriptor.setHawkQueryLanguage(v);
                    break;
                }
                case "query": {
                    descriptor.setHawkQuery(v);
                }
            }
        }
        return descriptor;
    }

    protected boolean isHawkURL(URI uri) {
        return uri.hasAbsolutePath() && uri.scheme() != null && uri.scheme().startsWith("hawk+");
    }

    private static String join(Object[] iterable, String delim) {
        StringBuffer sbuf = new StringBuffer();
        boolean first = true;
        Object[] objectArray = iterable;
        int n = iterable.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (first) {
                first = false;
            } else {
                sbuf.append(',');
            }
            sbuf.append(o.toString());
            ++n2;
        }
        return sbuf.toString();
    }
}

