/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.epsilon.emc;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.epsilon.emc.AbstractHawkModel;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.epsilon.emc.pgetters.GraphPropertyGetter;
import org.eclipse.hawk.epsilon.emc.tracking.AccessListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeriveFeature {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeriveFeature.class);

    public Object deriveFeature(Map<String, EolModule> cachedModules, IModelIndexer indexer, IGraphNode n, EOLQueryEngine containerModel, String EOLScript) throws Exception {
        EolModule currentModule;
        block3: {
            String actualEOLScript = EOLScript.startsWith("_NYD##") ? EOLScript.substring("_NYD##".length()) : EOLScript;
            try {
                currentModule = this.setupModule(cachedModules, indexer, n, containerModel, actualEOLScript);
                if (currentModule != null) break block3;
                return "DERIVATION_PARSE_ERROR";
            }
            catch (Exception e) {
                LOGGER.error("ERROR IN DERIVING ATTRIBUTE, returning \"DERIVATION_OTHER_ERROR\" as value", (Throwable)e);
                return "DERIVATION_OTHER_ERROR";
            }
        }
        GraphPropertyGetter pg = (GraphPropertyGetter)containerModel.getPropertyGetter();
        AccessListener accessListener = pg.getAccessListener();
        accessListener.setSourceObject("" + n.getId());
        return this.runModule(n, currentModule);
    }

    public Object deriveTimelineAnnotation(Map<String, EolModule> cachedModules, IModelIndexer indexer, IGraphNode n, EOLQueryEngine containerModel, String EOLScript) throws Exception {
        GraphPropertyGetter pg = (GraphPropertyGetter)containerModel.getPropertyGetter();
        boolean originalBroadcast = pg.getBroadcastStatus();
        pg.setBroadcastAccess(false);
        try {
            EolModule currentModule = this.setupModule(cachedModules, indexer, n, containerModel, EOLScript);
            if (currentModule == null) {
                return "DERIVATION_PARSE_ERROR";
            }
            Object object = this.runModule(n, currentModule);
            return object;
        }
        catch (Exception e) {
            LOGGER.error("ERROR IN DERIVING ATTRIBUTE, returning \"DERIVATION_OTHER_ERROR\" as value", (Throwable)e);
        }
        finally {
            pg.setBroadcastAccess(originalBroadcast);
        }
        return "DERIVATION_OTHER_ERROR";
    }

    private Object runModule(IGraphNode n, EolModule currentModule) {
        try {
            Object ret = currentModule.execute();
            return this.normalizeResult(ret);
        }
        catch (Exception e) {
            LOGGER.error("error in derive feature on {}, returning derivation execution error", n.getId());
            LOGGER.error(e.getMessage(), (Throwable)e);
            return "DERIVATION_EXECUTION_ERROR";
        }
    }

    private Object normalizeResult(Object ret) {
        if (!(ret instanceof Collection)) {
            return AbstractHawkModel.toPrimitive(ret);
        }
        AbstractCollection collection = null;
        collection = ret instanceof Set ? new LinkedHashSet() : new LinkedList();
        Collection srcCollection = (Collection)ret;
        Class elemClass = null;
        for (Object o : srcCollection) {
            Object converted = AbstractHawkModel.toPrimitive(o);
            if (converted != null) {
                collection.add(converted);
            }
            if (elemClass != null) continue;
            elemClass = converted.getClass();
        }
        if (elemClass == null) {
            elemClass = String.class;
        }
        Object r = Array.newInstance(elemClass, collection.size());
        return collection.toArray((Object[])r);
    }

    private EolModule setupModule(Map<String, EolModule> cachedModules, IModelIndexer indexer, IGraphNode n, EOLQueryEngine containerModel, String actualEOLScript) throws Exception {
        EolModule currentModule;
        if (!cachedModules.containsKey(actualEOLScript)) {
            LOGGER.debug("adding new module to cache, key: {}", (Object)(actualEOLScript.length() > 100 ? String.valueOf(actualEOLScript.substring(0, 100)) + "\n[! long script, snipped !]" : actualEOLScript));
            currentModule = this.initModule(indexer, containerModel);
            currentModule.parse(actualEOLScript);
            List pps = currentModule.getParseProblems();
            for (ParseProblem p : pps) {
                LOGGER.error("Parsing problem: {}", (Object)p);
            }
            if (pps.size() > 0) {
                LOGGER.error("There were parse problems, returning \"DERIVATION_PARSE_ERROR\" as value\n");
                return null;
            }
            cachedModules.put(actualEOLScript, currentModule);
        } else {
            currentModule = cachedModules.get(actualEOLScript);
        }
        IGraphNode modelElementNode = ((IGraphEdge)n.getIncoming().iterator().next()).getStartNode();
        EOLQueryEngine.GraphNodeWrapper meGW = containerModel.wrap(modelElementNode);
        currentModule.getContext().getFrameStack().put(Variable.createReadOnlyVariable((String)"self", (Object)meGW));
        return currentModule;
    }

    private EolModule initModule(IModelIndexer m, EOLQueryEngine model) throws Exception {
        EolModule currentModule = new EolModule();
        model.load(m);
        currentModule.getContext().getModelRepository().addModel((IModel)model);
        return currentModule;
    }
}

