/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.integration.tests.emf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.graph.syncValidationListener.SyncValidationListener;
import org.eclipse.hawk.integration.tests.IntegrationTestSuite;
import org.eclipse.hawk.integration.tests.ModelIndexingTest;
import org.eclipse.hawk.integration.tests.emf.EMFModelSupportFactory;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runners.Parameterized;

public class SubtreeContextTest
extends ModelIndexingTest {
    @Rule
    public ModelIndexingTest.GraphChangeListenerRule<SyncValidationListener> syncValidation = new ModelIndexingTest.GraphChangeListenerRule((ModelIndexingTest)this, (IGraphChangeListener)new SyncValidationListener());
    @Rule
    public TemporaryFolder modelFolder = new TemporaryFolder();
    private File folderOriginal;
    private File folderFragmented;
    private String originalRepoURI;
    private String fragmentedRepoURI;

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> params() {
        return IntegrationTestSuite.caseParams();
    }

    public SubtreeContextTest(File baseDir, IGraphDatabaseFactory dbf) {
        super(baseDir, dbf, new EMFModelSupportFactory());
    }

    @Before
    public void setUp() throws Throwable {
        Assume.assumeFalse((boolean)this.db.getClass().isAnnotationPresent(Deprecated.class));
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Ecore.ecore"), new File(this.baseDir, "resources/metamodels/JDTAST.ecore")});
        this.folderOriginal = new File(this.baseDir, "resources/models/set0-reduced").getCanonicalFile();
        this.folderFragmented = new File(this.baseDir, "resources/models/set0-reduced-fragmented").getCanonicalFile();
        this.originalRepoURI = this.folderOriginal.toPath().toUri().toString();
        this.fragmentedRepoURI = this.folderFragmented.toPath().toUri().toString();
    }

    protected void prepareBoth() throws Exception, Throwable {
        this.prepareOriginal();
        this.prepareFragmented();
    }

    protected void prepareFragmented() throws Exception, Throwable {
        this.requestFolderIndex(this.folderFragmented);
        this.scheduleAndWait(() -> {
            this.assertNoValidationErrors("There should be no validation errors on the fragmented model");
            return null;
        });
    }

    private void assertNoValidationErrors(String message) {
        List errors = this.syncValidation.getListener().getErrors();
        if (!errors.isEmpty()) {
            List messages = errors.stream().map(e -> e.getMessage()).collect(Collectors.toList());
            Assert.fail((String)(String.valueOf(message) + ":\n" + String.join((CharSequence)"\n\n", messages)));
        }
    }

    protected void prepareOriginal() throws Exception, Throwable {
        this.requestFolderIndex(this.folderOriginal);
        this.scheduleAndWait(() -> {
            this.assertNoValidationErrors("There should be no validation errors on the original model");
            return null;
        });
    }

    @Test
    public void allContents() throws Throwable {
        this.prepareBoth();
        int originalSize = (Integer)this.eol("return Model.allContents.size;", SubtreeContextTest.ctx("REPOSITORY", this.originalRepoURI));
        int fragmentedSize = (Integer)this.eol("return Model.allContents.size;", SubtreeContextTest.ctx("REPOSITORY", this.fragmentedRepoURI));
        Assert.assertEquals((long)originalSize, (long)fragmentedSize);
        Assert.assertEquals((Object)(originalSize * 2), (Object)this.eol("return Model.allContents.size;"));
        int subtreeOriginalSize = (Integer)this.eol("return Model.allContents.size;", SubtreeContextTest.ctx("REPOSITORY", this.originalRepoURI, "SUBTREE", "/set0.xmi"));
        Assert.assertEquals((long)originalSize, (long)subtreeOriginalSize);
        int subtreeFragmentedSize = (Integer)this.eol("return Model.allContents.size;", SubtreeContextTest.ctx("REPOSITORY", this.fragmentedRepoURI, "SUBTREE", "/set0.xmi"));
        Assert.assertEquals((long)subtreeFragmentedSize, (long)subtreeOriginalSize);
        int originalJavaContents = (Integer)this.eol("return 1 + IJavaProject.all.first.eAllContents.size;", SubtreeContextTest.ctx("REPOSITORY", this.originalRepoURI));
        int fileBasedJavaContents = (Integer)this.eol("return Model.allContents.size;", SubtreeContextTest.ctx("REPOSITORY", this.fragmentedRepoURI, "FILE", "/IJavaProject_org.eclipse.jdt.apt.pluggable.core/*"));
        int subtreeJavaContents = (Integer)this.eol("return Model.allContents.size;", SubtreeContextTest.ctx("REPOSITORY", this.fragmentedRepoURI, "SUBTREE", "/IJavaProject_org.eclipse.jdt.apt.pluggable.core/IJavaProject_org.eclipse.jdt.apt.pluggable.core.xmi"));
        Assert.assertEquals((long)originalJavaContents, (long)fileBasedJavaContents);
        Assert.assertEquals((long)originalJavaContents, (long)subtreeJavaContents);
    }

    @Test
    public void getAllOf() throws Throwable {
        this.prepareBoth();
        String eolQuery = "return IType.all.size;";
        int fileClasses = (Integer)this.eol("return IType.all.size;", SubtreeContextTest.ctx("REPOSITORY", this.fragmentedRepoURI, "FILE", "/IJavaProject_org.eclipse.jdt.apt.pluggable.core/*"));
        int fileFirstClasses = (Integer)this.eol("return IType.all.size;", SubtreeContextTest.ctx("REPOSITORY", this.fragmentedRepoURI, "FILE", "/IJavaProject_org.eclipse.jdt.apt.pluggable.core/*", "FILEFIRST", "true"));
        Assert.assertEquals((long)fileClasses, (long)fileFirstClasses);
        int subtreeClasses = (Integer)this.eol("return IType.all.size;", SubtreeContextTest.ctx("REPOSITORY", this.fragmentedRepoURI, "SUBTREE", "/IJavaProject_org.eclipse.jdt.apt.pluggable.core/IJavaProject_org.eclipse.jdt.apt.pluggable.core.xmi"));
        Assert.assertEquals((long)fileClasses, (long)subtreeClasses);
        int subtreeFileFirstClasses = (Integer)this.eol("return IType.all.size;", SubtreeContextTest.ctx("REPOSITORY", this.fragmentedRepoURI, "SUBTREE", "/IJavaProject_org.eclipse.jdt.apt.pluggable.core/IJavaProject_org.eclipse.jdt.apt.pluggable.core.xmi", "FILEFIRST", "true"));
        Assert.assertEquals((long)fileClasses, (long)subtreeFileFirstClasses);
        int subtreeClassesDerived = (Integer)this.eol("return IType.all.size;", SubtreeContextTest.ctx("REPOSITORY", this.fragmentedRepoURI, "SUBTREE", "/IJavaProject_org.eclipse.jdt.apt.pluggable.core/IJavaProject_org.eclipse.jdt.apt.pluggable.core.xmi", "SUBTREE_DERIVEDALLOF", "true"));
        Assert.assertEquals((long)fileClasses, (long)subtreeClassesDerived);
    }

    @Test
    public void getAllOfCountsSubtypes() throws Throwable {
        this.prepareFragmented();
        int binpkgCount = (Integer)this.eol("return BinaryPackageFragmentRoot.all.size;", SubtreeContextTest.ctx("REPOSITORY", this.fragmentedRepoURI, "SUBTREE", "/set0.xmi", "SUBTREE_DERIVEDALLOF", "true"));
        int ipkgCount = (Integer)this.eol("return IPackageFragmentRoot.all.size;", SubtreeContextTest.ctx("REPOSITORY", this.fragmentedRepoURI, "SUBTREE", "/set0.xmi", "SUBTREE_DERIVEDALLOF", "true"));
        Assert.assertTrue((String)String.format("IPackageFragmentRoot.all.size should be > than BinaryPackageFragmentRoot.all.size: checking %d > %d", ipkgCount, binpkgCount), (ipkgCount > binpkgCount ? 1 : 0) != 0);
        ArrayList<String> pathsTouched = new ArrayList<String>();
        Random rnd = new Random(42L);
        for (File f : FileUtils.listFiles((File)this.folderFragmented, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE)) {
            if (!(rnd.nextDouble() < 0.2)) continue;
            FileUtils.touch((File)f);
            pathsTouched.add(f.getName());
        }
        this.indexer.requestImmediateSync();
        this.scheduleAndWait(() -> {
            int ipkgCount2 = (Integer)this.eol("return IPackageFragmentRoot.all.size;", SubtreeContextTest.ctx("REPOSITORY", this.fragmentedRepoURI, "SUBTREE", "/set0.xmi", "SUBTREE_DERIVEDALLOF", "true"));
            Assert.assertEquals((String)("IPackageFragmentRoot.all.size should stay the same after touching " + pathsTouched), (long)ipkgCount, (long)ipkgCount2);
            return null;
        });
    }

    @Test
    public void subtreeTraversalScoping() throws Throwable {
        this.prepareBoth();
        String eolQuery = "return IJavaProject.all.first.externalPackageFragmentRoots.size;";
        int fileClasses = (Integer)this.eol("return IJavaProject.all.first.externalPackageFragmentRoots.size;", SubtreeContextTest.ctx("REPOSITORY", this.fragmentedRepoURI, "FILE", "/IJavaProject_org.eclipse.jdt.apt.pluggable.core/*", "ENABLE_TRAVERSAL_SCOPING", "true"));
        Assert.assertEquals((long)0L, (long)fileClasses);
        int subtreeClasses = (Integer)this.eol("return IJavaProject.all.first.externalPackageFragmentRoots.size;", SubtreeContextTest.ctx("REPOSITORY", this.fragmentedRepoURI, "SUBTREE", "/IJavaProject_org.eclipse.jdt.apt.pluggable.core/IJavaProject_org.eclipse.jdt.apt.pluggable.core.xmi", "ENABLE_TRAVERSAL_SCOPING", "true"));
        Assert.assertEquals((long)0L, (long)subtreeClasses);
    }

    @Test
    public void getFiles() throws Throwable {
        this.prepareBoth();
        int fragmentedFilesCount = (Integer)this.eol("return Model.files.size;", SubtreeContextTest.ctx("REPOSITORY", this.fragmentedRepoURI, "FILE", "/IJavaProject_org.eclipse.jdt.apt.pluggable.core/*"));
        int subtreeFilesCount = (Integer)this.eol("return Model.files.size;", SubtreeContextTest.ctx("REPOSITORY", this.fragmentedRepoURI, "SUBTREE", "/IJavaProject_org.eclipse.jdt.apt.pluggable.core/IJavaProject_org.eclipse.jdt.apt.pluggable.core.xmi"));
        Assert.assertEquals((long)fragmentedFilesCount, (long)subtreeFilesCount);
    }

    private static Map<String, Object> ctx(String ... opts) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        int i = 0;
        while (i + 1 < opts.length) {
            String key = opts[i];
            String value = opts[i + 1];
            ctx.put(key, value);
            i += 2;
        }
        return ctx;
    }

    public static void main(String[] args) throws IOException {
        new Fragmenter().run();
    }

    private static class Fragmenter {
        private static final String pathToMetamodel = "resources/metamodels/JDTAST.ecore";
        private static final String pathToOriginal = "resources/models/set0-reduced/set0.xmi";
        private static final String pathToFragmented = "resources/models/set0-reduced-fragmented/set0.xmi";
        private ResourceSetImpl rs;

        private Fragmenter() {
        }

        public void run() throws IOException {
            this.rs = new ResourceSetImpl();
            this.rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
            Resource rEcoreMM = this.rs.createResource(URI.createFileURI((String)new File(pathToMetamodel).getAbsolutePath()));
            rEcoreMM.load(null);
            for (EObject rawEPackage : rEcoreMM.getContents()) {
                EPackage epackage = (EPackage)rawEPackage;
                this.rs.getPackageRegistry().put((Object)epackage.getNsURI(), (Object)epackage);
            }
            this.rs.getResources().remove((Object)rEcoreMM);
            File fOriginal = new File(pathToOriginal);
            Resource rRoot = this.rs.createResource(URI.createFileURI((String)fOriginal.getAbsolutePath()));
            rRoot.load(null);
            File fFragmented = new File(pathToFragmented);
            if (fFragmented.getParentFile().exists()) {
                FileUtils.deleteDirectory((File)fFragmented.getParentFile());
            }
            rRoot.setURI(URI.createFileURI((String)fFragmented.getAbsolutePath()));
            this.fragment(rRoot);
            for (Resource r : this.rs.getResources()) {
                r.save(null);
            }
            for (Resource r : this.rs.getResources()) {
                r.unload();
            }
            this.rs = null;
        }

        private void fragment(Resource rRoot) {
            File fRoot = new File(rRoot.getURI().toFileString());
            File fRootFolder = fRoot.getParentFile();
            TreeIterator itContents = rRoot.getAllContents();
            while (itContents.hasNext()) {
                String eClassName;
                EObject eob = (EObject)itContents.next();
                if (rRoot.getContents().contains((Object)eob)) continue;
                switch (eClassName = eob.eClass().getName()) {
                    case "IJavaProject": 
                    case "BinaryPackageFragmentRoot": 
                    case "IPackageFragment": {
                        EStructuralFeature sf = eob.eClass().getEStructuralFeature("elementName");
                        String name = eob.eGet(sf).toString();
                        File fFolder = new File(fRootFolder, String.format("%s_%s", eClassName, name));
                        fFolder.mkdirs();
                        File fChild = new File(fFolder, String.format("%s_%s.xmi", eClassName, name));
                        URI uriChild = URI.createFileURI((String)fChild.getAbsolutePath());
                        Resource r = this.rs.createResource(uriChild);
                        itContents.prune();
                        r.getContents().add((Object)eob);
                        this.fragment(r);
                    }
                }
            }
        }
    }
}

