/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.backend.tests;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.hawk.backend.tests.BackendTestSuite;
import org.eclipse.hawk.backend.tests.LogbackOnlyErrorsRule;
import org.eclipse.hawk.backend.tests.RedirectSystemErrorRule;
import org.eclipse.hawk.backend.tests.TemporaryDatabaseTest;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class IndexTest
extends TemporaryDatabaseTest {
    @Rule
    public RedirectSystemErrorRule errRule = new RedirectSystemErrorRule();
    @Rule
    public LogbackOnlyErrorsRule logRule = new LogbackOnlyErrorsRule();

    @Parameterized.Parameters(name="Parameters are {0}")
    public static Iterable<Object[]> params() {
        return BackendTestSuite.caseParams();
    }

    public IndexTest(IGraphDatabaseFactory dbFactory) {
        super(dbFactory);
    }

    @Test
    public void query() throws Exception {
        IGraphTransaction tx;
        String mmBarURI = "http://foo/bar";
        String mmFileURI = "file://a/b/c.d";
        Map<String, String> mmBarNodeProps = Collections.singletonMap("_hawkid", "http://foo/bar");
        Map<String, String> mmFileNodeProps = Collections.singletonMap("_hawkid", "file://a/b/c.d");
        Throwable throwable = null;
        Object var6_12 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphNode mmNode = this.db.createNode(mmBarNodeProps, "metamodel");
                this.db.getMetamodelIndex().add(mmNode, Collections.singletonMap("id", "http://foo/bar"));
                IGraphNode mmFileNode = this.db.createNode(mmFileNodeProps, "metamodel");
                this.db.getMetamodelIndex().add(mmFileNode, Collections.singletonMap("id", "file://a/b/c.d"));
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var6_12 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphIterable iter = this.db.getMetamodelIndex().query("id", (Object)"http://*");
                Assert.assertSame((Object)this.db, (Object)((IGraphNode)iter.getSingle()).getGraph());
                Assert.assertEquals((long)1L, (long)iter.size());
                Assert.assertTrue((boolean)((IGraphNode)iter.getSingle()).getProperty("_hawkid").toString().startsWith("http://"));
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var6_12 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphIterable iter3 = this.db.getMetamodelIndex().query("id", (Object)"http://foo/bar");
                Assert.assertEquals((long)1L, (long)iter3.size());
                IGraphNode node = (IGraphNode)iter3.getSingle();
                Assert.assertSame((Object)this.db, (Object)node.getGraph());
                Assert.assertEquals((Object)"http://foo/bar", (Object)node.getProperty("_hawkid"));
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        throwable = null;
        var6_12 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphIterable iter4 = this.db.getMetamodelIndex().query("id", (Object)"*");
                Assert.assertSame((Object)this.db, (Object)((IGraphNode)iter4.getSingle()).getGraph());
                Assert.assertEquals((long)2L, (long)iter4.size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
        throwable = null;
        var6_12 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphIterable iter2 = this.db.getMetamodelIndex().get("id", (Object)"file://a/b/c.d");
                Assert.assertEquals((long)1L, (long)iter2.size());
                Assert.assertEquals((Object)"file://a/b/c.d", (Object)((IGraphNode)iter2.getSingle()).getProperty("_hawkid"));
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        throwable = null;
        var6_12 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals(new HashSet<String>(Arrays.asList("http://foo/bar", "file://a/b/c.d")), (Object)this.db.getKnownMMUris());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable7) {
            if (throwable == null) {
                throwable = throwable7;
            } else if (throwable != throwable7) {
                throwable.addSuppressed(throwable7);
            }
            throw throwable;
        }
    }

    @Test
    public void queryWithPipes() throws Exception {
        IGraphTransaction tx;
        String sN1 = "/a||/foo/bar";
        String sN2 = "/b||/test";
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphNode n1 = this.db.createNode(null, "metamodel");
                this.db.getMetamodelIndex().add(n1, "id", (Object)"/a||/foo/bar");
                IGraphNode n2 = this.db.createNode(null, "metamodel");
                this.db.getMetamodelIndex().add(n2, "id", (Object)"/b||/test");
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)1L, (long)this.db.getMetamodelIndex().query("id", (Object)"/*||/foo/*").size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void removeByNode() throws Exception {
        String mmBarURI = this.populateForRemove();
        IGraphIterable<? extends IGraphNode> iter = this.checkBeforeRemove(mmBarURI);
        Throwable throwable = null;
        Object var4_5 = null;
        try (IGraphTransaction tx = this.db.beginTransaction();){
            this.db.getMetamodelIndex().remove((IGraphNode)iter.getSingle());
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.checkAfterRemove(mmBarURI);
    }

    @Test
    public void removeByNodeMultipleIndicesRemoveOne() throws Exception {
        IGraphNode n;
        IGraphTransaction tx;
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                n = this.db.createNode(null, "x");
                this.db.getMetamodelIndex().add(n, "a", (Object)1);
                this.db.getFileIndex().add(n, "f", (Object)"/x/y");
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_4 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)1L, (long)this.db.getMetamodelIndex().query("*", (Object)"*").size());
                Assert.assertEquals((long)1L, (long)this.db.getFileIndex().query("*", (Object)"*").size());
                this.db.getMetamodelIndex().remove(n);
                Assert.assertEquals((long)0L, (long)this.db.getMetamodelIndex().query("*", (Object)"*").size());
                Assert.assertEquals((long)1L, (long)this.db.getFileIndex().query("*", (Object)"*").size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void removeByNodeMultipleIndicesRemoveAll() throws Exception {
        IGraphNode n;
        IGraphTransaction tx;
        Throwable throwable = null;
        Object var3_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                n = this.db.createNode(null, "x");
                this.db.getMetamodelIndex().add(n, "a", (Object)1);
                this.db.getFileIndex().add(n, "f", (Object)"/x/y");
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)1L, (long)this.db.getMetamodelIndex().query("*", (Object)"*").size());
                Assert.assertEquals((long)1L, (long)this.db.getFileIndex().query("*", (Object)"*").size());
                for (String idxName : this.db.getNodeIndexNames()) {
                    this.db.getOrCreateNodeIndex(idxName).remove(n);
                }
                for (String idxName : this.db.getNodeIndexNames()) {
                    Assert.assertEquals((long)0L, (long)this.db.getOrCreateNodeIndex(idxName).query("*", (Object)"*").size());
                }
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var3_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                for (String idxName : this.db.getNodeIndexNames()) {
                    Assert.assertEquals((long)0L, (long)this.db.getOrCreateNodeIndex(idxName).query("*", (Object)"*").size());
                }
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void removeByFullKey() throws Exception {
        String mmBarURI = this.populateForRemove();
        IGraphIterable<? extends IGraphNode> iter = this.checkBeforeRemove(mmBarURI);
        Throwable throwable = null;
        Object var4_5 = null;
        try (IGraphTransaction tx = this.db.beginTransaction();){
            this.db.getMetamodelIndex().remove((IGraphNode)iter.getSingle(), "id", (Object)mmBarURI);
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.checkAfterRemove(mmBarURI);
    }

    @Test
    public void removeByFullKeyInt() throws Exception {
        IGraphNode n1;
        IGraphTransaction tx;
        String key = "int";
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                n1 = this.db.createNode(null, "v");
                IGraphNode n2 = this.db.createNode(null, "v");
                this.db.getMetamodelIndex().add(n1, "int", (Object)1);
                this.db.getMetamodelIndex().add(n2, "int", (Object)2);
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var5_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphNodeIndex mmIdx = this.db.getMetamodelIndex();
                Assert.assertEquals((long)2L, (long)mmIdx.query("int", (Number)1, (Number)2, true, true).size());
                mmIdx.remove(n1, "int", (Object)1);
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var5_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)0L, (long)this.db.getMetamodelIndex().get("int", (Object)1).size());
                Assert.assertEquals((long)1L, (long)this.db.getMetamodelIndex().get("int", (Object)2).size());
                Assert.assertEquals((long)1L, (long)this.db.getMetamodelIndex().query("int", (Number)1, (Number)2, true, true).size());
                Assert.assertEquals((long)1L, (long)this.db.getMetamodelIndex().query("int", (Object)"*").size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void removeByFullKeyDouble() throws Exception {
        IGraphNode n1;
        IGraphTransaction tx;
        String key = "double";
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                n1 = this.db.createNode(null, "v");
                IGraphNode n2 = this.db.createNode(null, "v");
                this.db.getMetamodelIndex().add(n1, "double", (Object)1.1);
                this.db.getMetamodelIndex().add(n2, "double", (Object)2.3);
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var5_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphNodeIndex mmIdx = this.db.getMetamodelIndex();
                mmIdx.remove(n1, "double", (Object)1.1);
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var5_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)0L, (long)this.db.getMetamodelIndex().get("double", (Object)1.1).size());
                Assert.assertEquals((long)1L, (long)this.db.getMetamodelIndex().get("double", (Object)2.3).size());
                Assert.assertEquals((long)1L, (long)this.db.getMetamodelIndex().query("double", (Number)1.0, (Number)3.0, false, false).size());
                Assert.assertEquals((long)1L, (long)this.db.getMetamodelIndex().query("double", (Object)"*").size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void removeByValueNode() throws Exception {
        String mmBarURI = this.populateForRemove();
        IGraphIterable<? extends IGraphNode> iter = this.checkBeforeRemove(mmBarURI);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (IGraphTransaction tx = this.db.beginTransaction();){
                this.db.getMetamodelIndex().remove((IGraphNode)iter.getSingle(), null, (Object)mmBarURI);
                tx.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (UnsupportedOperationException ex) {
            Assume.assumeTrue((String)"Removing a node by value with no key is not supported on this backend", (boolean)false);
        }
        this.checkAfterRemove(mmBarURI);
    }

    @Test
    public void removeByFieldNode() throws Exception {
        String mmBarURI = this.populateForRemove();
        IGraphIterable<? extends IGraphNode> iter = this.checkBeforeRemove(mmBarURI);
        Throwable throwable = null;
        Object var4_5 = null;
        try (IGraphTransaction tx = this.db.beginTransaction();){
            this.db.getMetamodelIndex().remove((IGraphNode)iter.getSingle(), "id", null);
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.checkAfterRemove(mmBarURI);
    }

    @Test
    public void removeByNode3Arg() throws Exception {
        String mmBarURI = this.populateForRemove();
        IGraphIterable<? extends IGraphNode> iter = this.checkBeforeRemove(mmBarURI);
        Throwable throwable = null;
        Object var4_5 = null;
        try (IGraphTransaction tx = this.db.beginTransaction();){
            this.db.getMetamodelIndex().remove((IGraphNode)iter.getSingle(), null, null);
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.checkAfterRemove(mmBarURI);
    }

    @Test
    public void integerExact() throws Exception {
        IGraphTransaction tx;
        String mmBarURI = "http://foo/bar";
        Map<String, String> mmBarNodeProps = Collections.singletonMap("_hawkid", "http://foo/bar");
        IGraphNodeIndex idx = this.db.getMetamodelIndex();
        Throwable throwable = null;
        Object var5_7 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphNode mmNode = this.db.createNode(mmBarNodeProps, "metamodel");
                idx.add(mmNode, Collections.singletonMap("value", 5));
                IGraphNode mmNode2 = this.db.createNode(mmBarNodeProps, "metamodel");
                idx.add(mmNode2, Collections.singletonMap("value", 8));
                IGraphNode mmNode3 = this.db.createNode(mmBarNodeProps, "metamodel");
                idx.add(mmNode3, Collections.singletonMap("value", 8));
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var5_7 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)0L, (long)idx.get("value", (Object)1).size());
                Assert.assertEquals((long)0L, (long)idx.query("value", (Object)1).size());
                Assert.assertEquals((long)1L, (long)idx.get("value", (Object)5).size());
                Assert.assertEquals((long)1L, (long)idx.query("value", (Object)5).size());
                Assert.assertEquals((long)2L, (long)idx.get("value", (Object)8).size());
                Assert.assertEquals((long)2L, (long)idx.query("value", (Object)8).size());
                Assert.assertEquals((long)3L, (long)idx.query("value", (Object)"*").size());
                Assert.assertEquals((long)3L, (long)idx.query("*", (Object)"*").size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void doubleExact() throws Exception {
        IGraphTransaction tx;
        String mmBarURI = "http://foo/bar";
        Map<String, String> mmBarNodeProps = Collections.singletonMap("_hawkid", "http://foo/bar");
        IGraphNodeIndex idx = this.db.getMetamodelIndex();
        Throwable throwable = null;
        Object var5_7 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphNode mmNode = this.db.createNode(mmBarNodeProps, "metamodel");
                idx.add(mmNode, Collections.singletonMap("value", 5.3));
                IGraphNode mmNode2 = this.db.createNode(mmBarNodeProps, "metamodel");
                idx.add(mmNode2, Collections.singletonMap("value", 8.1));
                IGraphNode mmNode3 = this.db.createNode(mmBarNodeProps, "metamodel");
                idx.add(mmNode3, Collections.singletonMap("value", 8.1));
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var5_7 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)0L, (long)idx.get("value", (Object)5.2).size());
                Assert.assertEquals((long)0L, (long)idx.query("value", (Object)5.2).size());
                Assert.assertEquals((long)0L, (long)idx.get("value", (Object)8.4).size());
                Assert.assertEquals((long)0L, (long)idx.query("value", (Object)8.4).size());
                Assert.assertEquals((long)1L, (long)idx.get("value", (Object)5.3).size());
                Assert.assertEquals((long)1L, (long)idx.query("value", (Object)5.3).size());
                Assert.assertEquals((long)2L, (long)idx.get("value", (Object)8.1).size());
                Assert.assertEquals((long)2L, (long)idx.query("value", (Object)8.1).size());
                Assert.assertEquals((long)3L, (long)idx.query("value", (Object)"*").size());
                Assert.assertEquals((long)3L, (long)idx.query("*", (Object)"*").size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void integerRanges() throws Exception {
        IGraphTransaction tx;
        String mmBarURI = "http://foo/bar";
        Map<String, String> mmBarNodeProps = Collections.singletonMap("_hawkid", "http://foo/bar");
        IGraphNodeIndex idx = this.db.getMetamodelIndex();
        Throwable throwable = null;
        Object var5_7 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphNode mmNode = this.db.createNode(mmBarNodeProps, "metamodel");
                idx.add(mmNode, Collections.singletonMap("value", 5));
                IGraphNode mmNode2 = this.db.createNode(mmBarNodeProps, "metamodel");
                idx.add(mmNode2, Collections.singletonMap("value", 8));
                IGraphNode mmNode3 = this.db.createNode(mmBarNodeProps, "metamodel");
                idx.add(mmNode3, Collections.singletonMap("value", 1));
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var5_7 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)3L, (long)idx.query("value", (Number)0, (Number)10, false, false).size());
                Assert.assertEquals((long)1L, (long)idx.query("value", (Number)1, (Number)8, false, false).size());
                Assert.assertEquals((long)2L, (long)idx.query("value", (Number)1, (Number)8, true, false).size());
                Assert.assertEquals((long)2L, (long)idx.query("value", (Number)1, (Number)8, false, true).size());
                Assert.assertEquals((long)3L, (long)idx.query("value", (Number)1, (Number)8, true, true).size());
                Assert.assertEquals((long)2L, (long)idx.query("value", (Number)2, (Number)8, true, true).size());
                Assert.assertEquals((long)2L, (long)idx.query("value", (Number)1, (Number)7, true, true).size());
                Assert.assertEquals((long)1L, (long)idx.query("value", (Number)4, (Number)6, false, false).size());
                Assert.assertEquals((long)1L, (long)idx.query("value", (Number)5, (Number)5, true, true).size());
                Assert.assertEquals((long)0L, (long)idx.query("value", (Number)5, (Number)5, false, false).size());
                Assert.assertEquals((long)0L, (long)idx.query("value", (Number)5, (Number)4, false, false).size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void floatingRanges() throws Exception {
        IGraphTransaction tx;
        String mmBarURI = "http://foo/bar";
        Map<String, String> mmBarNodeProps = Collections.singletonMap("_hawkid", "http://foo/bar");
        IGraphNodeIndex idx = this.db.getMetamodelIndex();
        Throwable throwable = null;
        Object var5_7 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphNode mmNode = this.db.createNode(mmBarNodeProps, "metamodel");
                idx.add(mmNode, Collections.singletonMap("value", 5.3));
                IGraphNode mmNode2 = this.db.createNode(mmBarNodeProps, "metamodel");
                idx.add(mmNode2, Collections.singletonMap("value", 8.1));
                IGraphNode mmNode3 = this.db.createNode(mmBarNodeProps, "metamodel");
                idx.add(mmNode3, Collections.singletonMap("value", 1.34));
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var5_7 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)3L, (long)idx.query("value", (Number)0.0, (Number)10.0, false, false).size());
                Assert.assertEquals((long)3L, (long)idx.query("value", (Number)1.3, (Number)8.2, false, false).size());
                Assert.assertEquals((long)2L, (long)idx.query("value", (Number)1.4, (Number)8.2, false, false).size());
                Assert.assertEquals((long)2L, (long)idx.query("value", (Number)1.3, (Number)8.0, false, false).size());
                Assert.assertEquals((long)1L, (long)idx.query("value", (Number)1.4, (Number)8.0, false, false).size());
                Assert.assertEquals((long)1L, (long)idx.query("value", (Number)5.2, (Number)5.4, false, false).size());
                Assert.assertEquals((long)0L, (long)idx.query("value", (Number)5.2, (Number)5.2, false, false).size());
                Assert.assertEquals((long)0L, (long)idx.query("value", (Number)5.2, (Number)5.1, false, false).size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void invalidIndexNames() throws Exception {
        IGraphNode n;
        char[] invalidChars = ":,; %=/\\".toCharArray();
        Throwable throwable = null;
        Object var4_5 = null;
        try (IGraphTransaction tx = this.db.beginTransaction();){
            n = this.db.createNode(null, "eobject");
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        char[] cArray = invalidChars;
        int n2 = invalidChars.length;
        int n3 = 0;
        while (n3 < n2) {
            IGraphNodeIndex idx;
            IGraphTransaction tx;
            char invalidChar = cArray[n3];
            String name = "my" + invalidChar + "index";
            Throwable throwable3 = null;
            Object var9_16 = null;
            try {
                tx = this.db.beginTransaction();
                try {
                    Assert.assertFalse((boolean)this.db.nodeIndexExists(name));
                    idx = this.db.getOrCreateNodeIndex(name);
                    idx.add(n, "id", (Object)1);
                    tx.success();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
            throwable3 = null;
            var9_16 = null;
            try {
                tx = this.db.beginTransaction();
                try {
                    Assert.assertTrue((String)("Index " + name + " should be listed"), (boolean)this.db.getNodeIndexNames().contains(name));
                    Assert.assertTrue((boolean)this.db.nodeIndexExists(name));
                    idx = this.db.getOrCreateNodeIndex(name);
                    IGraphIterable results = idx.query("id", (Object)1);
                    Assert.assertEquals((String)("Exact query for index " + name + " should produce one result"), (long)1L, (long)results.size());
                    results = idx.query("id", (Number)0, (Number)1, true, true);
                    Assert.assertEquals((String)("Range query for index " + name + " should produce one result"), (long)1L, (long)results.size());
                    IGraphIterable allID = idx.query("id", (Object)"*");
                    Assert.assertEquals((String)("Should find exactly one match in " + name), (long)1L, (long)allID.size());
                    tx.success();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable3 == null) {
                    throwable3 = throwable5;
                } else if (throwable3 != throwable5) {
                    throwable3.addSuppressed(throwable5);
                }
                throw throwable3;
            }
            ++n3;
        }
    }

    @Test
    public void getMultipleMatches() throws Exception {
        IGraphNodeIndex idxRoots;
        IGraphTransaction tx;
        String objLabel = "object";
        String fileIdxKey = "file";
        String fileNodeLabel = "file";
        String fileEdgeLabel = "inFile";
        Throwable throwable = null;
        Object var7_10 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                idxRoots = this.db.getOrCreateNodeIndex("roots");
                IGraphNode n1 = this.db.createNode(null, "object");
                IGraphNode n2 = this.db.createNode(null, "object");
                IGraphNode n3 = this.db.createNode(null, "object");
                IGraphNode f1 = this.db.createNode(null, "file");
                IGraphNode f2 = this.db.createNode(null, "file");
                this.db.createRelationship(n1, f1, "inFile");
                this.db.createRelationship(n2, f1, "inFile");
                this.db.createRelationship(n3, f2, "inFile");
                idxRoots.add(n1, "file", (Object)"a.xmi");
                idxRoots.add(n2, "file", (Object)"a.xmi");
                idxRoots.add(n3, "file", (Object)"b.xmi");
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var7_10 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphIterable aRoots = idxRoots.get("file", (Object)"a.xmi");
                Assert.assertEquals((long)2L, (long)aRoots.size());
                Assert.assertEquals((long)2L, (long)this.iteratorSize(aRoots.iterator()));
                Assert.assertNotNull((Object)aRoots.getSingle());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var7_10 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphIterable bRoots = idxRoots.get("file", (Object)"b.xmi");
                Assert.assertEquals((long)1L, (long)bRoots.size());
                Assert.assertEquals((long)1L, (long)this.iteratorSize(bRoots.iterator()));
                Assert.assertNotNull((Object)bRoots.getSingle());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        throwable = null;
        var7_10 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphIterable cRoots = idxRoots.get("file", (Object)"c.xmi");
                Assert.assertEquals((long)0L, (long)cRoots.size());
                Assert.assertEquals((long)0L, (long)this.iteratorSize(cRoots.iterator()));
                try {
                    cRoots.getSingle();
                    Assert.fail((String)"NoSuchElementException should have been thrown");
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    @Test
    public void addNullValue() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IGraphTransaction tx = this.db.beginTransaction();){
            IGraphNodeIndex idxRoots = this.db.getOrCreateNodeIndex("roots");
            IGraphNode n1 = this.db.createNode(null, "eobject");
            idxRoots.add(n1, "file", null);
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void addNullMap() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IGraphTransaction tx = this.db.beginTransaction();){
            IGraphNodeIndex idxRoots = this.db.getOrCreateNodeIndex("roots");
            IGraphNode n1 = this.db.createNode(null, "eobject");
            idxRoots.add(n1, null);
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void addPreservesPriorValue() throws Exception {
        IGraphNodeIndex idxRoots;
        IGraphTransaction tx;
        Throwable throwable = null;
        Object var4_4 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                idxRoots = this.db.getOrCreateNodeIndex("roots");
                IGraphNode x = this.db.createNode(null, "eobject");
                idxRoots.add(x, "a", (Object)"1");
                idxRoots.add(x, "a", (Object)"2");
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_4 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)1L, (long)idxRoots.query("a", (Object)"1").size());
                Assert.assertEquals((long)1L, (long)idxRoots.query("a", (Object)"2").size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void addThenReuseIterable() throws Exception {
        Throwable throwable = null;
        Object var4_3 = null;
        try (IGraphTransaction tx = this.db.beginTransaction();){
            IGraphNodeIndex idxRoots = this.db.getOrCreateNodeIndex("roots");
            IGraphNode x = this.db.createNode(null, "eobject");
            IGraphIterable iterNodes = idxRoots.get("a", (Object)"1");
            Assert.assertFalse((boolean)iterNodes.iterator().hasNext());
            idxRoots.add(x, "a", (Object)"1");
            Assert.assertTrue((boolean)iterNodes.iterator().hasNext());
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void deleteRecreate() throws Exception {
        IGraphNode x;
        IGraphNodeIndex idxRoots;
        IGraphTransaction tx;
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                idxRoots = this.db.getOrCreateNodeIndex("roots");
                x = this.db.createNode(null, "eobject");
                idxRoots.add(x, "a", (Object)"1");
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)1L, (long)idxRoots.query("a", (Object)"1").size());
                idxRoots.delete();
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var4_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                idxRoots = this.db.getOrCreateNodeIndex("roots");
                idxRoots.flush();
                Assert.assertEquals((long)0L, (long)idxRoots.query("a", (Object)"*").size());
                idxRoots.add(x, "a", (Object)"2");
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        throwable = null;
        var4_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)0L, (long)idxRoots.query("a", (Object)"1").size());
                Assert.assertEquals((long)1L, (long)idxRoots.query("a", (Object)"2").size());
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    @Test
    public void nodeDelete() throws Exception {
        IGraphIterable results;
        IGraphTransaction tx;
        Throwable throwable = null;
        Object var2_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphNode n = this.db.createNode(null, "x");
                this.db.getMetamodelIndex().add(n, "a", (Object)1);
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var2_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                results = this.db.getMetamodelIndex().get("a", (Object)1);
                Assert.assertEquals((long)1L, (long)results.size());
                ((IGraphNode)results.getSingle()).delete();
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var2_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                results = this.db.getMetamodelIndex().get("a", (Object)1);
                Assert.assertEquals((long)0L, (long)results.size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void indexKeyAdditionRollback() throws Exception {
        IGraphNode n;
        IGraphTransaction tx;
        Throwable throwable = null;
        Object var3_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                n = this.db.createNode(null, "x");
                this.db.getMetamodelIndex().add(n, "b", (Object)1);
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                this.db.getMetamodelIndex().add(n, "a", (Object)1);
                tx.failure();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var3_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)0L, (long)this.db.getMetamodelIndex().query("a", (Object)"*").size());
                Assert.assertEquals((long)1L, (long)this.db.getMetamodelIndex().query("b", (Object)"*").size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void indexKeyRemovalRollback() throws Exception {
        IGraphNode n;
        IGraphTransaction tx;
        Throwable throwable = null;
        Object var3_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                n = this.db.createNode(null, "x");
                this.db.getMetamodelIndex().add(n, "b", (Object)1);
                this.db.getMetamodelIndex().add(n, "c", (Object)"x");
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)1L, (long)this.db.getMetamodelIndex().query("b", (Object)1).size());
                Assert.assertEquals((long)1L, (long)this.db.getMetamodelIndex().query("c", (Object)"x").size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var3_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                this.db.getMetamodelIndex().remove(n, "b", (Object)1);
                this.db.getMetamodelIndex().remove(n, "c", (Object)"x");
                tx.failure();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        throwable = null;
        var3_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)1L, (long)this.db.getMetamodelIndex().query("b", (Object)1).size());
                Assert.assertEquals((long)1L, (long)this.db.getMetamodelIndex().query("c", (Object)"x").size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    @Test
    public void indexDeletionRollback() throws Exception {
        IGraphTransaction tx;
        Throwable throwable = null;
        Object var2_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphNode n1 = this.db.createNode(null, "x");
                IGraphNode n2 = this.db.createNode(null, "y");
                this.db.getMetamodelIndex().add(n1, "b", (Object)1);
                this.db.getMetamodelIndex().add(n2, "b", (Object)3);
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var2_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)2L, (long)this.db.getMetamodelIndex().query("b", (Object)"*").size());
                this.db.getMetamodelIndex().delete();
                this.db.getMetamodelIndex().flush();
                Assert.assertEquals((long)0L, (long)this.db.getMetamodelIndex().query("b", (Object)"*").size());
                tx.failure();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var2_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)2L, (long)this.db.getMetamodelIndex().query("b", (Object)"*").size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void indexNodeDeletionRollback() throws Exception {
        IGraphNode n2;
        IGraphTransaction tx;
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphNode n1 = this.db.createNode(null, "x");
                n2 = this.db.createNode(null, "y");
                this.db.getMetamodelIndex().add(n1, "b", (Object)1);
                this.db.getMetamodelIndex().add(n2, "b", (Object)3);
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)2L, (long)this.db.getMetamodelIndex().query("b", (Object)"*").size());
                this.db.getMetamodelIndex().remove(n2);
                Assert.assertEquals((long)1L, (long)this.db.getMetamodelIndex().query("b", (Object)"*").size());
                tx.failure();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var4_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)2L, (long)this.db.getMetamodelIndex().query("b", (Object)"*").size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private String populateForRemove() throws Exception {
        String mmBarURI = "http://foo/bar";
        Map<String, String> mmBarNodeProps = Collections.singletonMap("_hawkid", "http://foo/bar");
        Throwable throwable = null;
        Object var4_5 = null;
        try (IGraphTransaction tx = this.db.beginTransaction();){
            IGraphNode mmNode = this.db.createNode(mmBarNodeProps, "metamodel");
            IGraphNodeIndex mmIdx = this.db.getMetamodelIndex();
            mmIdx.add(mmNode, Collections.singletonMap("id", "http://foo/bar"));
            IGraphNode mmNode2 = this.db.createNode(mmBarNodeProps, "metamodel");
            mmIdx.add(mmNode2, Collections.singletonMap("id", "file://foo"));
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return "http://foo/bar";
    }

    private void checkAfterRemove(String mmBarURI) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (IGraphTransaction tx = this.db.beginTransaction();){
            IGraphNodeIndex mmIdx = this.db.getMetamodelIndex();
            Assert.assertEquals((long)0L, (long)mmIdx.query("id", (Object)mmBarURI).size());
            Assert.assertEquals((long)0L, (long)mmIdx.query("id", (Object)"http://*").size());
            Assert.assertEquals((long)1L, (long)mmIdx.query("id", (Object)"file://*").size());
            Assert.assertEquals((long)1L, (long)mmIdx.query("id", (Object)"fil*://*").size());
            Assert.assertEquals((long)1L, (long)mmIdx.query("id", (Object)"*file://*").size());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private IGraphIterable<? extends IGraphNode> checkBeforeRemove(String mmBarURI) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (IGraphTransaction tx = this.db.beginTransaction();){
            IGraphIterable iter = this.db.getMetamodelIndex().query("id", (Object)mmBarURI);
            Assert.assertEquals((long)1L, (long)iter.size());
            tx.success();
            return iter;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private int iteratorSize(Iterator<?> it) {
        int count = 0;
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }
}

