/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.core.graph;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.IHawkPlugin;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.core.graph.IGraphTransaction;

public interface IGraphDatabase
extends IHawkPlugin {
    public String getPath();

    public void run(File var1, IConsole var2);

    public void shutdown() throws Exception;

    public void delete() throws Exception;

    public IGraphNodeIndex getOrCreateNodeIndex(String var1);

    public IGraphNodeIndex getMetamodelIndex();

    public IGraphNodeIndex getFileIndex();

    public IGraphTransaction beginTransaction() throws Exception;

    public boolean isTransactional();

    public void enterBatchMode();

    public void exitBatchMode();

    public IGraphIterable<? extends IGraphNode> allNodes(String var1);

    public IGraphNode createNode(Map<String, Object> var1, String var2);

    default public IGraphEdge createRelationship(IGraphNode start, IGraphNode target, String type) {
        return this.createRelationship(start, target, type, null);
    }

    public IGraphEdge createRelationship(IGraphNode var1, IGraphNode var2, String var3, Map<String, Object> var4);

    public Object getGraph();

    public IGraphNode getNodeById(Object var1);

    default public boolean nodeIndexExists(String name) {
        return this.getNodeIndexNames().contains(name);
    }

    public String getTempDir();

    public Mode currentMode();

    public Set<String> getNodeIndexNames();

    default public Set<String> getKnownMMUris() {
        HashSet<String> mmURIs = new HashSet<String>();
        for (IGraphNode iGraphNode : this.getMetamodelIndex().query("*", "*")) {
            String mmURI = (String)iGraphNode.getProperty("_hawkid");
            mmURIs.add(mmURI);
        }
        return mmURIs;
    }

    @Override
    default public IHawkPlugin.Category getCategory() {
        return IHawkPlugin.Category.BACKEND;
    }

    public static enum Mode {
        TX_MODE,
        NO_TX_MODE,
        UNKNOWN;

    }
}

