/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.integration.tests.uml;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.integration.tests.uml.AbstractUMLIndexingTest;
import org.junit.Assert;
import org.junit.Test;

public class UMLWorkspaceIndexingTest
extends AbstractUMLIndexingTest {
    public UMLWorkspaceIndexingTest(File baseDir, IGraphDatabaseFactory dbf) {
        super(baseDir, dbf);
    }

    @Test
    public void workspaceCrosslinks() throws Throwable {
        File testResourcesBase = new File(new File(this.baseDir, "resources/models/uml"), "crossfile-refs").getCanonicalFile();
        IProject project1 = this.openProject(new File(testResourcesBase, "model1"));
        IProject project2 = this.openProject(new File(testResourcesBase, "model2"));
        try {
            this.requestWorkspaceIndex();
            this.scheduleAndWait(() -> {
                Assert.assertEquals((Object)3, (Object)this.eolWorkspace("return Class.all.size;"));
                Assert.assertEquals(new HashSet<String>(Arrays.asList("Class1", "Class3")), (Object)this.eolWorkspace("return Class.all.selectOne(c|c.name='Class2').generalization.general.name.flatten.asSet;"));
                return false;
            });
        }
        finally {
            project1.close(null);
            project2.close(null);
        }
    }
}

