/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui.emfresource.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphDatabase;
import org.eclipse.hawk.osgiserver.HModel;
import org.eclipse.hawk.ui2.util.HUIManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectHawkInstancePage
extends WizardPage {
    private String selectedInstance;
    private boolean isSplit = true;
    private String sRepoPatterns = "*";
    private String sFilePatterns = "*";
    private Long timepoint;
    private Text txtTimepoint;

    public SelectHawkInstancePage() {
        super("Create new local Hawk model descriptor");
        this.setTitle("Select Local Hawk Instance");
        this.setDescription("Select one of the Hawk instances in this Eclipse installation.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 4);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        Label lblInstance = new Label(container, 0);
        lblInstance.setText("Hawk instance:");
        GridData layoutData = new GridData(16384, 128, false, false);
        layoutData.verticalIndent = 5;
        lblInstance.setLayoutData((Object)layoutData);
        ListViewer viewer = new ListViewer(container, 2048);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.setInput((Object)this.getHawkNames());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                if (sel instanceof IStructuredSelection) {
                    IStructuredSelection ssel = (IStructuredSelection)sel;
                    if (ssel.isEmpty()) {
                        SelectHawkInstancePage.this.selectedInstance = null;
                        SelectHawkInstancePage.this.txtTimepoint.setEnabled(false);
                        SelectHawkInstancePage.this.txtTimepoint.setText("");
                    } else {
                        SelectHawkInstancePage.this.selectedInstance = (String)ssel.getFirstElement();
                        IGraphDatabase selectedGraph = HUIManager.getInstance().getHawkByName(SelectHawkInstancePage.this.selectedInstance).getGraph();
                        if (selectedGraph instanceof ITimeAwareGraphDatabase) {
                            SelectHawkInstancePage.this.txtTimepoint.setEnabled(true);
                            SelectHawkInstancePage.this.txtTimepoint.setText("0");
                        } else {
                            SelectHawkInstancePage.this.txtTimepoint.setEnabled(false);
                            SelectHawkInstancePage.this.txtTimepoint.setText("");
                        }
                    }
                    SelectHawkInstancePage.this.checkComplete();
                }
            }
        });
        GridData viewerLayoutData = new GridData(4, 4, true, true);
        viewer.getList().setLayoutData((Object)viewerLayoutData);
        final Button btnSplit = new Button(container, 32);
        btnSplit.setText("Split by file");
        btnSplit.setSelection(this.isSplit);
        btnSplit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectHawkInstancePage.this.isSplit = btnSplit.getSelection();
            }
        });
        GridData btnSplitLD = new GridData();
        btnSplitLD.horizontalSpan = 2;
        btnSplit.setLayoutData((Object)btnSplitLD);
        Label lblRepo = new Label(container, 0);
        lblRepo.setText("Repository pattern(s):");
        final Text txtRepo = new Text(container, 2048);
        txtRepo.setToolTipText("Patterns for the repositories that should be exposed, separated by commas. '*' means 'any 0+ characters'.");
        txtRepo.setText(this.sRepoPatterns);
        txtRepo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectHawkInstancePage.this.sRepoPatterns = txtRepo.getText();
                SelectHawkInstancePage.this.checkComplete();
            }
        });
        txtRepo.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lblFiles = new Label(container, 0);
        lblFiles.setText("File pattern(s):");
        final Text txtFiles = new Text(container, 2048);
        txtFiles.setText(this.sFilePatterns);
        txtFiles.setToolTipText("Patterns for the files that should be exposed, separated by commas. '*' means 'any 0+ characters'.");
        txtFiles.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectHawkInstancePage.this.sFilePatterns = txtFiles.getText();
                SelectHawkInstancePage.this.checkComplete();
            }
        });
        txtFiles.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lblTimepoint = new Label(container, 0);
        lblTimepoint.setText("Timepoint:");
        this.txtTimepoint = new Text(container, 2048);
        this.txtTimepoint.setText("");
        this.txtTimepoint.setToolTipText("Non-negative integer with the graph timepoint to be loaded. Only applicable for time-aware backends.");
        this.txtTimepoint.setEnabled(false);
        this.txtTimepoint.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                block6: {
                    try {
                        try {
                            if (SelectHawkInstancePage.this.txtTimepoint.getText().trim().length() > 0) {
                                SelectHawkInstancePage.this.timepoint = Long.parseLong(SelectHawkInstancePage.this.txtTimepoint.getText());
                                break block6;
                            }
                            SelectHawkInstancePage.this.timepoint = null;
                        }
                        catch (NumberFormatException ex) {
                            SelectHawkInstancePage.this.setErrorMessage("Timepoint is not a valid number");
                            SelectHawkInstancePage.this.timepoint = -1L;
                            SelectHawkInstancePage.this.checkComplete();
                        }
                    }
                    finally {
                        SelectHawkInstancePage.this.checkComplete();
                    }
                }
            }
        });
        this.txtTimepoint.setLayoutData((Object)new GridData(4, 4, true, false));
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    private String[] getHawkNames() {
        HUIManager hManager = HUIManager.getInstance();
        Set hawks = hManager.getHawks();
        ArrayList<String> hawkNames = new ArrayList<String>();
        for (HModel hawk : hawks) {
            if (hawk.getGraph() == null) continue;
            hawkNames.add(hawk.getName());
        }
        Collections.sort(hawkNames);
        String[] arrHawkNames = hawkNames.toArray(new String[hawkNames.size()]);
        return arrHawkNames;
    }

    public String getSelectedInstance() {
        return this.selectedInstance;
    }

    public boolean isSplit() {
        return this.isSplit;
    }

    public List<String> getRepositoryPatterns() {
        return Arrays.asList(this.sRepoPatterns.split(","));
    }

    public List<String> getFilePatterns() {
        return Arrays.asList(this.sFilePatterns.split(","));
    }

    public Long getTimepoint() {
        return this.timepoint;
    }

    protected void checkComplete() {
        this.setPageComplete(this.selectedInstance != null && this.sRepoPatterns.length() > 0 && this.sFilePatterns.length() > 0 && (this.timepoint == null || this.timepoint >= 0L));
    }
}

