/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui2.dialog;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.hawk.core.IMetaModelIntrospector;
import org.eclipse.hawk.osgiserver.HModel;
import org.eclipse.hawk.osgiserver.HModelSchedulingRule;
import org.eclipse.hawk.ui2.dialog.HStateBasedDialog;
import org.eclipse.hawk.ui2.util.TypeCascadeSelectionAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.FrameworkUtil;

final class HIndexedAttributeDialog
extends HStateBasedDialog {
    private Combo cmbMetamodel;
    private Combo cmbType;
    private Combo cmbAttributeName;

    private String getMetamodelURI() {
        return this.cmbMetamodel.getText().trim();
    }

    private String getTargetType() {
        return this.cmbType.getText().trim();
    }

    private String getAttributeName() {
        return this.cmbAttributeName.getText().trim();
    }

    HIndexedAttributeDialog(HModel hModel, Shell parentShell) {
        super(hModel, parentShell);
    }

    protected void okPressed() {
        final String uri = this.getMetamodelURI();
        final String type = this.getTargetType();
        final String name = this.getAttributeName();
        if (!(uri.isEmpty() || type.isEmpty() || name.isEmpty())) {
            String jobName = "Add indexed attribute " + name + " to " + this.hawkModel.getName();
            Job addIndexedJob = new Job(jobName){

                protected IStatus run(IProgressMonitor monitor) {
                    String symbolicName = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName();
                    try {
                        HIndexedAttributeDialog.this.hawkModel.addIndexedAttribute(uri, type, name);
                    }
                    catch (Exception e1) {
                        return new Status(4, symbolicName, "Failed", (Throwable)e1);
                    }
                    return new Status(0, symbolicName, "Done");
                }
            };
            addIndexedJob.setRule((ISchedulingRule)new HModelSchedulingRule(this.hawkModel));
            addIndexedJob.schedule();
        }
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button ok = this.getButton(0);
        ok.setText("OK");
        ok.setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText("Add an indexed attribute");
        Composite container = new Composite(parent, 4);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        container.setLayout((Layout)gridLayout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        Label l = new Label(container, 0);
        l.setText("Metamodel URI:");
        this.cmbMetamodel = new Combo(container, 8);
        List metamodels = this.hawkModel.getRegisteredMetamodels();
        Collections.sort(metamodels);
        for (String s : metamodels) {
            this.cmbMetamodel.add(s);
        }
        this.cmbMetamodel.setLayoutData((Object)new GridData(4, 1, true, false));
        l = new Label(container, 0);
        l.setText("Target Type:");
        this.cmbType = new Combo(container, 2048);
        GridData data = new GridData(1, 1, true, false);
        data.minimumWidth = 200;
        this.cmbType.setLayoutData((Object)data);
        l = new Label(container, 0);
        l.setText("Attribute Name:");
        this.cmbAttributeName = new Combo(container, 2048);
        data = new GridData(1, 1, true, false);
        data.minimumWidth = 200;
        this.cmbAttributeName.setLayoutData((Object)data);
        this.cmbMetamodel.addSelectionListener((SelectionListener)new TypeCascadeSelectionAdapter(this.hawkModel, this.cmbType));
        this.cmbMetamodel.addSelectionListener((SelectionListener)new EvaluateOKSelectionListener());
        this.cmbType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String metamodelURI = HIndexedAttributeDialog.this.getMetamodelURI();
                String typeName = HIndexedAttributeDialog.this.getTargetType();
                HIndexedAttributeDialog.this.cmbAttributeName.removeAll();
                IMetaModelIntrospector introspector = HIndexedAttributeDialog.this.hawkModel.getIntrospector();
                if (introspector != null) {
                    List attributes = introspector.getAttributes(metamodelURI, typeName);
                    for (String sAttribute : attributes) {
                        HIndexedAttributeDialog.this.cmbAttributeName.add(sAttribute);
                    }
                    HIndexedAttributeDialog.this.cmbAttributeName.select(0);
                }
            }
        });
        this.cmbType.addModifyListener(this::evaluateOKEnabled);
        this.cmbAttributeName.addModifyListener(this::evaluateOKEnabled);
        this.setTitle("Create indexed attribute");
        this.setMessage("Specify the configuration of the new indexed attribute.");
        return parent;
    }

    private void evaluateOKEnabled(ModifyEvent e) {
        this.evaluateOKEnabled();
    }

    private void evaluateOKEnabled() {
        String uri = this.getMetamodelURI();
        String type = this.getTargetType();
        String name = this.getAttributeName();
        Button ok = this.getButton(0);
        if (!(uri.isEmpty() || type.isEmpty() || name.isEmpty())) {
            this.enableIfRunning(this.hawkModel.getStatus());
        } else {
            ok.setEnabled(false);
        }
    }

    protected class EvaluateOKSelectionListener
    extends SelectionAdapter {
        protected EvaluateOKSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            HIndexedAttributeDialog.this.evaluateOKEnabled();
        }
    }
}

